/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoomsResponse extends ChimeResponse implements
        ToCopyableBuilder<ListRoomsResponse.Builder, ListRoomsResponse> {
    private static final SdkField<List<Room>> ROOMS_FIELD = SdkField
            .<List<Room>> builder(MarshallingType.LIST)
            .memberName("Rooms")
            .getter(getter(ListRoomsResponse::rooms))
            .setter(setter(Builder::rooms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rooms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Room> builder(MarshallingType.SDK_POJO)
                                            .constructor(Room::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRoomsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ROOMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Room> rooms;

    private final String nextToken;

    private ListRoomsResponse(BuilderImpl builder) {
        super(builder);
        this.rooms = builder.rooms;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Rooms property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRooms() {
        return rooms != null && !(rooms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The room details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRooms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The room details.
     */
    public final List<Room> rooms() {
        return rooms;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRooms() ? rooms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoomsResponse)) {
            return false;
        }
        ListRoomsResponse other = (ListRoomsResponse) obj;
        return hasRooms() == other.hasRooms() && Objects.equals(rooms(), other.rooms())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRoomsResponse").add("Rooms", hasRooms() ? rooms() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rooms":
            return Optional.ofNullable(clazz.cast(rooms()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoomsResponse, T> g) {
        return obj -> g.apply((ListRoomsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRoomsResponse> {
        /**
         * <p>
         * The room details.
         * </p>
         * 
         * @param rooms
         *        The room details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rooms(Collection<Room> rooms);

        /**
         * <p>
         * The room details.
         * </p>
         * 
         * @param rooms
         *        The room details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rooms(Room... rooms);

        /**
         * <p>
         * The room details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Room>.Builder} avoiding the need to create
         * one manually via {@link List<Room>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Room>.Builder#build()} is called immediately and its result
         * is passed to {@link #rooms(List<Room>)}.
         * 
         * @param rooms
         *        a consumer that will call methods on {@link List<Room>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rooms(List<Room>)
         */
        Builder rooms(Consumer<Room.Builder>... rooms);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<Room> rooms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoomsResponse model) {
            super(model);
            rooms(model.rooms);
            nextToken(model.nextToken);
        }

        public final Collection<Room.Builder> getRooms() {
            if (rooms instanceof SdkAutoConstructList) {
                return null;
            }
            return rooms != null ? rooms.stream().map(Room::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rooms(Collection<Room> rooms) {
            this.rooms = RoomListCopier.copy(rooms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(Room... rooms) {
            rooms(Arrays.asList(rooms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(Consumer<Room.Builder>... rooms) {
            rooms(Stream.of(rooms).map(c -> Room.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRooms(Collection<Room.BuilderImpl> rooms) {
            this.rooms = RoomListCopier.copyFromBuilder(rooms);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRoomsResponse build() {
            return new ListRoomsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
