/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The emergency calling configuration details associated with an Amazon Chime Voice Connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmergencyCallingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EmergencyCallingConfiguration.Builder, EmergencyCallingConfiguration> {
    private static final SdkField<List<DNISEmergencyCallingConfiguration>> DNIS_FIELD = SdkField
            .<List<DNISEmergencyCallingConfiguration>> builder(MarshallingType.LIST)
            .memberName("DNIS")
            .getter(getter(EmergencyCallingConfiguration::dnis))
            .setter(setter(Builder::dnis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNIS").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DNISEmergencyCallingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DNISEmergencyCallingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DNISEmergencyCallingConfiguration> dnis;

    private EmergencyCallingConfiguration(BuilderImpl builder) {
        this.dnis = builder.dnis;
    }

    /**
     * Returns true if the DNIS property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDnis() {
        return dnis != null && !(dnis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Dialed Number Identification Service (DNIS) emergency calling configuration details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDnis()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Dialed Number Identification Service (DNIS) emergency calling configuration details.
     */
    public final List<DNISEmergencyCallingConfiguration> dnis() {
        return dnis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDnis() ? dnis() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmergencyCallingConfiguration)) {
            return false;
        }
        EmergencyCallingConfiguration other = (EmergencyCallingConfiguration) obj;
        return hasDnis() == other.hasDnis() && Objects.equals(dnis(), other.dnis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmergencyCallingConfiguration").add("DNIS", hasDnis() ? dnis() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DNIS":
            return Optional.ofNullable(clazz.cast(dnis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmergencyCallingConfiguration, T> g) {
        return obj -> g.apply((EmergencyCallingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmergencyCallingConfiguration> {
        /**
         * <p>
         * The Dialed Number Identification Service (DNIS) emergency calling configuration details.
         * </p>
         * 
         * @param dnis
         *        The Dialed Number Identification Service (DNIS) emergency calling configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnis(Collection<DNISEmergencyCallingConfiguration> dnis);

        /**
         * <p>
         * The Dialed Number Identification Service (DNIS) emergency calling configuration details.
         * </p>
         * 
         * @param dnis
         *        The Dialed Number Identification Service (DNIS) emergency calling configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnis(DNISEmergencyCallingConfiguration... dnis);

        /**
         * <p>
         * The Dialed Number Identification Service (DNIS) emergency calling configuration details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DNISEmergencyCallingConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<DNISEmergencyCallingConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DNISEmergencyCallingConfiguration>.Builder#build()} is
         * called immediately and its result is passed to {@link #dnis(List<DNISEmergencyCallingConfiguration>)}.
         * 
         * @param dnis
         *        a consumer that will call methods on {@link List<DNISEmergencyCallingConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnis(List<DNISEmergencyCallingConfiguration>)
         */
        Builder dnis(Consumer<DNISEmergencyCallingConfiguration.Builder>... dnis);
    }

    static final class BuilderImpl implements Builder {
        private List<DNISEmergencyCallingConfiguration> dnis = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmergencyCallingConfiguration model) {
            dnis(model.dnis);
        }

        public final Collection<DNISEmergencyCallingConfiguration.Builder> getDnis() {
            if (dnis instanceof SdkAutoConstructList) {
                return null;
            }
            return dnis != null ? dnis.stream().map(DNISEmergencyCallingConfiguration::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder dnis(Collection<DNISEmergencyCallingConfiguration> dnis) {
            this.dnis = DNISEmergencyCallingConfigurationListCopier.copy(dnis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnis(DNISEmergencyCallingConfiguration... dnis) {
            dnis(Arrays.asList(dnis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnis(Consumer<DNISEmergencyCallingConfiguration.Builder>... dnis) {
            dnis(Stream.of(dnis).map(c -> DNISEmergencyCallingConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDnis(Collection<DNISEmergencyCallingConfiguration.BuilderImpl> dnis) {
            this.dnis = DNISEmergencyCallingConfigurationListCopier.copyFromBuilder(dnis);
        }

        @Override
        public EmergencyCallingConfiguration build() {
            return new EmergencyCallingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
