/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.Room;
import software.amazon.awssdk.services.chime.model.RoomListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoomsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListRoomsResponse> {
    private static final SdkField<List<Room>> ROOMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rooms").getter(ListRoomsResponse.getter(ListRoomsResponse::rooms)).setter(ListRoomsResponse.setter(Builder::rooms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rooms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Room::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRoomsResponse.getter(ListRoomsResponse::nextToken)).setter(ListRoomsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Room> rooms;
    private final String nextToken;

    private ListRoomsResponse(BuilderImpl builder) {
        super(builder);
        this.rooms = builder.rooms;
        this.nextToken = builder.nextToken;
    }

    public boolean hasRooms() {
        return this.rooms != null && !(this.rooms instanceof SdkAutoConstructList);
    }

    public List<Room> rooms() {
        return this.rooms;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rooms());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoomsResponse)) {
            return false;
        }
        ListRoomsResponse other = (ListRoomsResponse)((Object)obj);
        return Objects.equals(this.rooms(), other.rooms()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRoomsResponse").add("Rooms", this.rooms()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rooms": {
                return Optional.ofNullable(clazz.cast(this.rooms()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoomsResponse, T> g) {
        return obj -> g.apply((ListRoomsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<Room> rooms = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoomsResponse model) {
            super(model);
            this.rooms(model.rooms);
            this.nextToken(model.nextToken);
        }

        public final Collection<Room.Builder> getRooms() {
            return this.rooms != null ? (Collection)this.rooms.stream().map(Room::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rooms(Collection<Room> rooms) {
            this.rooms = RoomListCopier.copy(rooms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(Room ... rooms) {
            this.rooms(Arrays.asList(rooms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(Consumer<Room.Builder> ... rooms) {
            this.rooms(Stream.of(rooms).map(c -> (Room)((Room.Builder)Room.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRooms(Collection<Room.BuilderImpl> rooms) {
            this.rooms = RoomListCopier.copyFromBuilder(rooms);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRoomsResponse build() {
            return new ListRoomsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoomsResponse> {
        public Builder rooms(Collection<Room> var1);

        public Builder rooms(Room ... var1);

        public Builder rooms(Consumer<Room.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

