/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.RetentionSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRetentionSettingsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, GetRetentionSettingsResponse> {
    private static final SdkField<RetentionSettings> RETENTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetentionSettings").getter(GetRetentionSettingsResponse.getter(GetRetentionSettingsResponse::retentionSettings)).setter(GetRetentionSettingsResponse.setter(Builder::retentionSettings)).constructor(RetentionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionSettings").build()}).build();
    private static final SdkField<Instant> INITIATE_DELETION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InitiateDeletionTimestamp").getter(GetRetentionSettingsResponse.getter(GetRetentionSettingsResponse::initiateDeletionTimestamp)).setter(GetRetentionSettingsResponse.setter(Builder::initiateDeletionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiateDeletionTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_SETTINGS_FIELD, INITIATE_DELETION_TIMESTAMP_FIELD));
    private final RetentionSettings retentionSettings;
    private final Instant initiateDeletionTimestamp;

    private GetRetentionSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.retentionSettings = builder.retentionSettings;
        this.initiateDeletionTimestamp = builder.initiateDeletionTimestamp;
    }

    public RetentionSettings retentionSettings() {
        return this.retentionSettings;
    }

    public Instant initiateDeletionTimestamp() {
        return this.initiateDeletionTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiateDeletionTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRetentionSettingsResponse)) {
            return false;
        }
        GetRetentionSettingsResponse other = (GetRetentionSettingsResponse)((Object)obj);
        return Objects.equals(this.retentionSettings(), other.retentionSettings()) && Objects.equals(this.initiateDeletionTimestamp(), other.initiateDeletionTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"GetRetentionSettingsResponse").add("RetentionSettings", (Object)this.retentionSettings()).add("InitiateDeletionTimestamp", (Object)this.initiateDeletionTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetentionSettings": {
                return Optional.ofNullable(clazz.cast(this.retentionSettings()));
            }
            case "InitiateDeletionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.initiateDeletionTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRetentionSettingsResponse, T> g) {
        return obj -> g.apply((GetRetentionSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private RetentionSettings retentionSettings;
        private Instant initiateDeletionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRetentionSettingsResponse model) {
            super(model);
            this.retentionSettings(model.retentionSettings);
            this.initiateDeletionTimestamp(model.initiateDeletionTimestamp);
        }

        public final RetentionSettings.Builder getRetentionSettings() {
            return this.retentionSettings != null ? this.retentionSettings.toBuilder() : null;
        }

        @Override
        public final Builder retentionSettings(RetentionSettings retentionSettings) {
            this.retentionSettings = retentionSettings;
            return this;
        }

        public final void setRetentionSettings(RetentionSettings.BuilderImpl retentionSettings) {
            this.retentionSettings = retentionSettings != null ? retentionSettings.build() : null;
        }

        public final Instant getInitiateDeletionTimestamp() {
            return this.initiateDeletionTimestamp;
        }

        @Override
        public final Builder initiateDeletionTimestamp(Instant initiateDeletionTimestamp) {
            this.initiateDeletionTimestamp = initiateDeletionTimestamp;
            return this;
        }

        public final void setInitiateDeletionTimestamp(Instant initiateDeletionTimestamp) {
            this.initiateDeletionTimestamp = initiateDeletionTimestamp;
        }

        @Override
        public GetRetentionSettingsResponse build() {
            return new GetRetentionSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRetentionSettingsResponse> {
        public Builder retentionSettings(RetentionSettings var1);

        default public Builder retentionSettings(Consumer<RetentionSettings.Builder> retentionSettings) {
            return this.retentionSettings((RetentionSettings)((RetentionSettings.Builder)RetentionSettings.builder().applyMutation(retentionSettings)).build());
        }

        public Builder initiateDeletionTimestamp(Instant var1);
    }
}

