/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.StreamingNotificationTarget;
import software.amazon.awssdk.services.chime.model.StreamingNotificationTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamingConfiguration> {
    private static final SdkField<Integer> DATA_RETENTION_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataRetentionInHours").getter(StreamingConfiguration.getter(StreamingConfiguration::dataRetentionInHours)).setter(StreamingConfiguration.setter(Builder::dataRetentionInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionInHours").build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(StreamingConfiguration.getter(StreamingConfiguration::disabled)).setter(StreamingConfiguration.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final SdkField<List<StreamingNotificationTarget>> STREAMING_NOTIFICATION_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StreamingNotificationTargets").getter(StreamingConfiguration.getter(StreamingConfiguration::streamingNotificationTargets)).setter(StreamingConfiguration.setter(Builder::streamingNotificationTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingNotificationTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamingNotificationTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_RETENTION_IN_HOURS_FIELD, DISABLED_FIELD, STREAMING_NOTIFICATION_TARGETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer dataRetentionInHours;
    private final Boolean disabled;
    private final List<StreamingNotificationTarget> streamingNotificationTargets;

    private StreamingConfiguration(BuilderImpl builder) {
        this.dataRetentionInHours = builder.dataRetentionInHours;
        this.disabled = builder.disabled;
        this.streamingNotificationTargets = builder.streamingNotificationTargets;
    }

    public Integer dataRetentionInHours() {
        return this.dataRetentionInHours;
    }

    public Boolean disabled() {
        return this.disabled;
    }

    public boolean hasStreamingNotificationTargets() {
        return this.streamingNotificationTargets != null && !(this.streamingNotificationTargets instanceof SdkAutoConstructList);
    }

    public List<StreamingNotificationTarget> streamingNotificationTargets() {
        return this.streamingNotificationTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRetentionInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingNotificationTargets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingConfiguration)) {
            return false;
        }
        StreamingConfiguration other = (StreamingConfiguration)obj;
        return Objects.equals(this.dataRetentionInHours(), other.dataRetentionInHours()) && Objects.equals(this.disabled(), other.disabled()) && Objects.equals(this.streamingNotificationTargets(), other.streamingNotificationTargets());
    }

    public String toString() {
        return ToString.builder((String)"StreamingConfiguration").add("DataRetentionInHours", (Object)this.dataRetentionInHours()).add("Disabled", (Object)this.disabled()).add("StreamingNotificationTargets", this.streamingNotificationTargets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataRetentionInHours": {
                return Optional.ofNullable(clazz.cast(this.dataRetentionInHours()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
            case "StreamingNotificationTargets": {
                return Optional.ofNullable(clazz.cast(this.streamingNotificationTargets()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingConfiguration, T> g) {
        return obj -> g.apply((StreamingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dataRetentionInHours;
        private Boolean disabled;
        private List<StreamingNotificationTarget> streamingNotificationTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingConfiguration model) {
            this.dataRetentionInHours(model.dataRetentionInHours);
            this.disabled(model.disabled);
            this.streamingNotificationTargets(model.streamingNotificationTargets);
        }

        public final Integer getDataRetentionInHours() {
            return this.dataRetentionInHours;
        }

        @Override
        public final Builder dataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
            return this;
        }

        public final void setDataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        public final Collection<StreamingNotificationTarget.Builder> getStreamingNotificationTargets() {
            return this.streamingNotificationTargets != null ? (Collection)this.streamingNotificationTargets.stream().map(StreamingNotificationTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder streamingNotificationTargets(Collection<StreamingNotificationTarget> streamingNotificationTargets) {
            this.streamingNotificationTargets = StreamingNotificationTargetListCopier.copy(streamingNotificationTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingNotificationTargets(StreamingNotificationTarget ... streamingNotificationTargets) {
            this.streamingNotificationTargets(Arrays.asList(streamingNotificationTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingNotificationTargets(Consumer<StreamingNotificationTarget.Builder> ... streamingNotificationTargets) {
            this.streamingNotificationTargets(Stream.of(streamingNotificationTargets).map(c -> (StreamingNotificationTarget)((StreamingNotificationTarget.Builder)StreamingNotificationTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStreamingNotificationTargets(Collection<StreamingNotificationTarget.BuilderImpl> streamingNotificationTargets) {
            this.streamingNotificationTargets = StreamingNotificationTargetListCopier.copyFromBuilder(streamingNotificationTargets);
        }

        public StreamingConfiguration build() {
            return new StreamingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamingConfiguration> {
        public Builder dataRetentionInHours(Integer var1);

        public Builder disabled(Boolean var1);

        public Builder streamingNotificationTargets(Collection<StreamingNotificationTarget> var1);

        public Builder streamingNotificationTargets(StreamingNotificationTarget ... var1);

        public Builder streamingNotificationTargets(Consumer<StreamingNotificationTarget.Builder> ... var1);
    }
}

