/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.E164PhoneNumberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAvailablePhoneNumbersResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, SearchAvailablePhoneNumbersResponse> {
    private static final SdkField<List<String>> E164_PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("E164PhoneNumbers").getter(SearchAvailablePhoneNumbersResponse.getter(SearchAvailablePhoneNumbersResponse::e164PhoneNumbers)).setter(SearchAvailablePhoneNumbersResponse.setter(Builder::e164PhoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E164_PHONE_NUMBERS_FIELD));
    private final List<String> e164PhoneNumbers;

    private SearchAvailablePhoneNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.e164PhoneNumbers = builder.e164PhoneNumbers;
    }

    public boolean hasE164PhoneNumbers() {
        return this.e164PhoneNumbers != null && !(this.e164PhoneNumbers instanceof SdkAutoConstructList);
    }

    public List<String> e164PhoneNumbers() {
        return this.e164PhoneNumbers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.e164PhoneNumbers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAvailablePhoneNumbersResponse)) {
            return false;
        }
        SearchAvailablePhoneNumbersResponse other = (SearchAvailablePhoneNumbersResponse)((Object)obj);
        return Objects.equals(this.e164PhoneNumbers(), other.e164PhoneNumbers());
    }

    public String toString() {
        return ToString.builder((String)"SearchAvailablePhoneNumbersResponse").add("E164PhoneNumbers", (Object)(this.e164PhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "E164PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.e164PhoneNumbers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAvailablePhoneNumbersResponse, T> g) {
        return obj -> g.apply((SearchAvailablePhoneNumbersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<String> e164PhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAvailablePhoneNumbersResponse model) {
            super(model);
            this.e164PhoneNumbers(model.e164PhoneNumbers);
        }

        public final Collection<String> getE164PhoneNumbers() {
            return this.e164PhoneNumbers;
        }

        @Override
        public final Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder e164PhoneNumbers(String ... e164PhoneNumbers) {
            this.e164PhoneNumbers(Arrays.asList(e164PhoneNumbers));
            return this;
        }

        public final void setE164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
        }

        @Override
        public SearchAvailablePhoneNumbersResponse build() {
            return new SearchAvailablePhoneNumbersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAvailablePhoneNumbersResponse> {
        public Builder e164PhoneNumbers(Collection<String> var1);

        public Builder e164PhoneNumbers(String ... var1);
    }
}

