/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVoiceConnectorRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, CreateVoiceConnectorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateVoiceConnectorRequest.getter(CreateVoiceConnectorRequest::name)).setter(CreateVoiceConnectorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsRegion").getter(CreateVoiceConnectorRequest.getter(CreateVoiceConnectorRequest::awsRegionAsString)).setter(CreateVoiceConnectorRequest.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final SdkField<Boolean> REQUIRE_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireEncryption").getter(CreateVoiceConnectorRequest.getter(CreateVoiceConnectorRequest::requireEncryption)).setter(CreateVoiceConnectorRequest.setter(Builder::requireEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireEncryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, AWS_REGION_FIELD, REQUIRE_ENCRYPTION_FIELD));
    private final String name;
    private final String awsRegion;
    private final Boolean requireEncryption;

    private CreateVoiceConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.awsRegion = builder.awsRegion;
        this.requireEncryption = builder.requireEncryption;
    }

    public String name() {
        return this.name;
    }

    public VoiceConnectorAwsRegion awsRegion() {
        return VoiceConnectorAwsRegion.fromValue(this.awsRegion);
    }

    public String awsRegionAsString() {
        return this.awsRegion;
    }

    public Boolean requireEncryption() {
        return this.requireEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireEncryption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVoiceConnectorRequest)) {
            return false;
        }
        CreateVoiceConnectorRequest other = (CreateVoiceConnectorRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.awsRegionAsString(), other.awsRegionAsString()) && Objects.equals(this.requireEncryption(), other.requireEncryption());
    }

    public String toString() {
        return ToString.builder((String)"CreateVoiceConnectorRequest").add("Name", (Object)this.name()).add("AwsRegion", (Object)this.awsRegionAsString()).add("RequireEncryption", (Object)this.requireEncryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegionAsString()));
            }
            case "RequireEncryption": {
                return Optional.ofNullable(clazz.cast(this.requireEncryption()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVoiceConnectorRequest, T> g) {
        return obj -> g.apply((CreateVoiceConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String name;
        private String awsRegion;
        private Boolean requireEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVoiceConnectorRequest model) {
            super(model);
            this.name(model.name);
            this.awsRegion(model.awsRegion);
            this.requireEncryption(model.requireEncryption);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        @Override
        public final Builder awsRegion(VoiceConnectorAwsRegion awsRegion) {
            this.awsRegion(awsRegion == null ? null : awsRegion.toString());
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final Boolean getRequireEncryption() {
            return this.requireEncryption;
        }

        @Override
        public final Builder requireEncryption(Boolean requireEncryption) {
            this.requireEncryption = requireEncryption;
            return this;
        }

        public final void setRequireEncryption(Boolean requireEncryption) {
            this.requireEncryption = requireEncryption;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVoiceConnectorRequest build() {
            return new CreateVoiceConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVoiceConnectorRequest> {
        public Builder name(String var1);

        public Builder awsRegion(String var1);

        public Builder awsRegion(VoiceConnectorAwsRegion var1);

        public Builder requireEncryption(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

