/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.PhoneNumber;
import software.amazon.awssdk.services.chime.model.PhoneNumberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPhoneNumbersResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListPhoneNumbersResponse> {
    private static final SdkField<List<PhoneNumber>> PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPhoneNumbersResponse.getter(ListPhoneNumbersResponse::phoneNumbers)).setter(ListPhoneNumbersResponse.setter(Builder::phoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPhoneNumbersResponse.getter(ListPhoneNumbersResponse::nextToken)).setter(ListPhoneNumbersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PhoneNumber> phoneNumbers;
    private final String nextToken;

    private ListPhoneNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumbers = builder.phoneNumbers;
        this.nextToken = builder.nextToken;
    }

    public boolean hasPhoneNumbers() {
        return this.phoneNumbers != null && !(this.phoneNumbers instanceof SdkAutoConstructList);
    }

    public List<PhoneNumber> phoneNumbers() {
        return this.phoneNumbers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersResponse)) {
            return false;
        }
        ListPhoneNumbersResponse other = (ListPhoneNumbersResponse)((Object)obj);
        return Objects.equals(this.phoneNumbers(), other.phoneNumbers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPhoneNumbersResponse").add("PhoneNumbers", this.phoneNumbers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.phoneNumbers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersResponse, T> g) {
        return obj -> g.apply((ListPhoneNumbersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<PhoneNumber> phoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersResponse model) {
            super(model);
            this.phoneNumbers(model.phoneNumbers);
            this.nextToken(model.nextToken);
        }

        public final Collection<PhoneNumber.Builder> getPhoneNumbers() {
            return this.phoneNumbers != null ? (Collection)this.phoneNumbers.stream().map(PhoneNumber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumber ... phoneNumbers) {
            this.phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumber.Builder> ... phoneNumbers) {
            this.phoneNumbers(Stream.of(phoneNumbers).map(c -> (PhoneNumber)((PhoneNumber.Builder)PhoneNumber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumbers(Collection<PhoneNumber.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copyFromBuilder(phoneNumbers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPhoneNumbersResponse build() {
            return new ListPhoneNumbersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPhoneNumbersResponse> {
        public Builder phoneNumbers(Collection<PhoneNumber> var1);

        public Builder phoneNumbers(PhoneNumber ... var1);

        public Builder phoneNumbers(Consumer<PhoneNumber.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

