/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.Bot;
import software.amazon.awssdk.services.chime.model.BotListCopier;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotsResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ListBotsResponse> {
    private static final SdkField<List<Bot>> BOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListBotsResponse.getter(ListBotsResponse::bots)).setter(ListBotsResponse.setter(Builder::bots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Bot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBotsResponse.getter(ListBotsResponse::nextToken)).setter(ListBotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Bot> bots;
    private final String nextToken;

    private ListBotsResponse(BuilderImpl builder) {
        super(builder);
        this.bots = builder.bots;
        this.nextToken = builder.nextToken;
    }

    public boolean hasBots() {
        return this.bots != null && !(this.bots instanceof SdkAutoConstructList);
    }

    public List<Bot> bots() {
        return this.bots;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bots());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotsResponse)) {
            return false;
        }
        ListBotsResponse other = (ListBotsResponse)((Object)obj);
        return Objects.equals(this.bots(), other.bots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListBotsResponse").add("Bots", this.bots()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bots": {
                return Optional.ofNullable(clazz.cast(this.bots()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotsResponse, T> g) {
        return obj -> g.apply((ListBotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<Bot> bots = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotsResponse model) {
            super(model);
            this.bots(model.bots);
            this.nextToken(model.nextToken);
        }

        public final Collection<Bot.Builder> getBots() {
            return this.bots != null ? (Collection)this.bots.stream().map(Bot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bots(Collection<Bot> bots) {
            this.bots = BotListCopier.copy(bots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bots(Bot ... bots) {
            this.bots(Arrays.asList(bots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bots(Consumer<Bot.Builder> ... bots) {
            this.bots(Stream.of(bots).map(c -> (Bot)((Bot.Builder)Bot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBots(Collection<Bot.BuilderImpl> bots) {
            this.bots = BotListCopier.copyFromBuilder(bots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBotsResponse build() {
            return new ListBotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotsResponse> {
        public Builder bots(Collection<Bot> var1);

        public Builder bots(Bot ... var1);

        public Builder bots(Consumer<Bot.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

