/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventsConfiguration> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EventsConfiguration.getter(EventsConfiguration::botId)).setter(EventsConfiguration.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BotId").build()}).build();
    private static final SdkField<String> OUTBOUND_EVENTS_HTTPS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EventsConfiguration.getter(EventsConfiguration::outboundEventsHTTPSEndpoint)).setter(EventsConfiguration.setter(Builder::outboundEventsHTTPSEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundEventsHTTPSEndpoint").build()}).build();
    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EventsConfiguration.getter(EventsConfiguration::lambdaFunctionArn)).setter(EventsConfiguration.setter(Builder::lambdaFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, OUTBOUND_EVENTS_HTTPS_ENDPOINT_FIELD, LAMBDA_FUNCTION_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String botId;
    private final String outboundEventsHTTPSEndpoint;
    private final String lambdaFunctionArn;

    private EventsConfiguration(BuilderImpl builder) {
        this.botId = builder.botId;
        this.outboundEventsHTTPSEndpoint = builder.outboundEventsHTTPSEndpoint;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
    }

    public String botId() {
        return this.botId;
    }

    public String outboundEventsHTTPSEndpoint() {
        return this.outboundEventsHTTPSEndpoint;
    }

    public String lambdaFunctionArn() {
        return this.lambdaFunctionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outboundEventsHTTPSEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsConfiguration)) {
            return false;
        }
        EventsConfiguration other = (EventsConfiguration)obj;
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.outboundEventsHTTPSEndpoint(), other.outboundEventsHTTPSEndpoint()) && Objects.equals(this.lambdaFunctionArn(), other.lambdaFunctionArn());
    }

    public String toString() {
        return ToString.builder((String)"EventsConfiguration").add("BotId", (Object)this.botId()).add("OutboundEventsHTTPSEndpoint", (Object)(this.outboundEventsHTTPSEndpoint() == null ? null : "*** Sensitive Data Redacted ***")).add("LambdaFunctionArn", (Object)(this.lambdaFunctionArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BotId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "OutboundEventsHTTPSEndpoint": {
                return Optional.ofNullable(clazz.cast(this.outboundEventsHTTPSEndpoint()));
            }
            case "LambdaFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventsConfiguration, T> g) {
        return obj -> g.apply((EventsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botId;
        private String outboundEventsHTTPSEndpoint;
        private String lambdaFunctionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EventsConfiguration model) {
            this.botId(model.botId);
            this.outboundEventsHTTPSEndpoint(model.outboundEventsHTTPSEndpoint);
            this.lambdaFunctionArn(model.lambdaFunctionArn);
        }

        public final String getBotId() {
            return this.botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getOutboundEventsHTTPSEndpoint() {
            return this.outboundEventsHTTPSEndpoint;
        }

        @Override
        public final Builder outboundEventsHTTPSEndpoint(String outboundEventsHTTPSEndpoint) {
            this.outboundEventsHTTPSEndpoint = outboundEventsHTTPSEndpoint;
            return this;
        }

        public final void setOutboundEventsHTTPSEndpoint(String outboundEventsHTTPSEndpoint) {
            this.outboundEventsHTTPSEndpoint = outboundEventsHTTPSEndpoint;
        }

        public final String getLambdaFunctionArn() {
            return this.lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        public EventsConfiguration build() {
            return new EventsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventsConfiguration> {
        public Builder botId(String var1);

        public Builder outboundEventsHTTPSEndpoint(String var1);

        public Builder lambdaFunctionArn(String var1);
    }
}

