/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSlackChannelConfigurationResponse extends ChatbotResponse implements
        ToCopyableBuilder<UpdateSlackChannelConfigurationResponse.Builder, UpdateSlackChannelConfigurationResponse> {
    private static final SdkField<SlackChannelConfiguration> CHANNEL_CONFIGURATION_FIELD = SdkField
            .<SlackChannelConfiguration> builder(MarshallingType.SDK_POJO).memberName("ChannelConfiguration")
            .getter(getter(UpdateSlackChannelConfigurationResponse::channelConfiguration))
            .setter(setter(Builder::channelConfiguration)).constructor(SlackChannelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SlackChannelConfiguration channelConfiguration;

    private UpdateSlackChannelConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.channelConfiguration = builder.channelConfiguration;
    }

    /**
     * <p>
     * The configuration for a Slack channel configured with AWS Chatbot.
     * </p>
     * 
     * @return The configuration for a Slack channel configured with AWS Chatbot.
     */
    public final SlackChannelConfiguration channelConfiguration() {
        return channelConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSlackChannelConfigurationResponse)) {
            return false;
        }
        UpdateSlackChannelConfigurationResponse other = (UpdateSlackChannelConfigurationResponse) obj;
        return Objects.equals(channelConfiguration(), other.channelConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSlackChannelConfigurationResponse").add("ChannelConfiguration", channelConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelConfiguration":
            return Optional.ofNullable(clazz.cast(channelConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelConfiguration", CHANNEL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSlackChannelConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateSlackChannelConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChatbotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSlackChannelConfigurationResponse> {
        /**
         * <p>
         * The configuration for a Slack channel configured with AWS Chatbot.
         * </p>
         * 
         * @param channelConfiguration
         *        The configuration for a Slack channel configured with AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelConfiguration(SlackChannelConfiguration channelConfiguration);

        /**
         * <p>
         * The configuration for a Slack channel configured with AWS Chatbot.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlackChannelConfiguration.Builder}
         * avoiding the need to create one manually via {@link SlackChannelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlackChannelConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #channelConfiguration(SlackChannelConfiguration)}.
         * 
         * @param channelConfiguration
         *        a consumer that will call methods on {@link SlackChannelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelConfiguration(SlackChannelConfiguration)
         */
        default Builder channelConfiguration(Consumer<SlackChannelConfiguration.Builder> channelConfiguration) {
            return channelConfiguration(SlackChannelConfiguration.builder().applyMutation(channelConfiguration).build());
        }
    }

    static final class BuilderImpl extends ChatbotResponse.BuilderImpl implements Builder {
        private SlackChannelConfiguration channelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSlackChannelConfigurationResponse model) {
            super(model);
            channelConfiguration(model.channelConfiguration);
        }

        public final SlackChannelConfiguration.Builder getChannelConfiguration() {
            return channelConfiguration != null ? channelConfiguration.toBuilder() : null;
        }

        public final void setChannelConfiguration(SlackChannelConfiguration.BuilderImpl channelConfiguration) {
            this.channelConfiguration = channelConfiguration != null ? channelConfiguration.build() : null;
        }

        @Override
        public final Builder channelConfiguration(SlackChannelConfiguration channelConfiguration) {
            this.channelConfiguration = channelConfiguration;
            return this;
        }

        @Override
        public UpdateSlackChannelConfigurationResponse build() {
            return new UpdateSlackChannelConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
