/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMicrosoftTeamsUserIdentitiesResponse extends ChatbotResponse implements
        ToCopyableBuilder<ListMicrosoftTeamsUserIdentitiesResponse.Builder, ListMicrosoftTeamsUserIdentitiesResponse> {
    private static final SdkField<List<TeamsUserIdentity>> TEAMS_USER_IDENTITIES_FIELD = SdkField
            .<List<TeamsUserIdentity>> builder(MarshallingType.LIST)
            .memberName("TeamsUserIdentities")
            .getter(getter(ListMicrosoftTeamsUserIdentitiesResponse::teamsUserIdentities))
            .setter(setter(Builder::teamsUserIdentities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamsUserIdentities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TeamsUserIdentity> builder(MarshallingType.SDK_POJO)
                                            .constructor(TeamsUserIdentity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMicrosoftTeamsUserIdentitiesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEAMS_USER_IDENTITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TeamsUserIdentity> teamsUserIdentities;

    private final String nextToken;

    private ListMicrosoftTeamsUserIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.teamsUserIdentities = builder.teamsUserIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TeamsUserIdentities property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTeamsUserIdentities() {
        return teamsUserIdentities != null && !(teamsUserIdentities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * User level permissions associated to a channel configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTeamsUserIdentities} method.
     * </p>
     * 
     * @return User level permissions associated to a channel configuration.
     */
    public final List<TeamsUserIdentity> teamsUserIdentities() {
        return teamsUserIdentities;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * MaxResults.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by MaxResults.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTeamsUserIdentities() ? teamsUserIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMicrosoftTeamsUserIdentitiesResponse)) {
            return false;
        }
        ListMicrosoftTeamsUserIdentitiesResponse other = (ListMicrosoftTeamsUserIdentitiesResponse) obj;
        return hasTeamsUserIdentities() == other.hasTeamsUserIdentities()
                && Objects.equals(teamsUserIdentities(), other.teamsUserIdentities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMicrosoftTeamsUserIdentitiesResponse")
                .add("TeamsUserIdentities", hasTeamsUserIdentities() ? teamsUserIdentities() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TeamsUserIdentities":
            return Optional.ofNullable(clazz.cast(teamsUserIdentities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TeamsUserIdentities", TEAMS_USER_IDENTITIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMicrosoftTeamsUserIdentitiesResponse, T> g) {
        return obj -> g.apply((ListMicrosoftTeamsUserIdentitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChatbotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMicrosoftTeamsUserIdentitiesResponse> {
        /**
         * <p>
         * User level permissions associated to a channel configuration.
         * </p>
         * 
         * @param teamsUserIdentities
         *        User level permissions associated to a channel configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamsUserIdentities(Collection<TeamsUserIdentity> teamsUserIdentities);

        /**
         * <p>
         * User level permissions associated to a channel configuration.
         * </p>
         * 
         * @param teamsUserIdentities
         *        User level permissions associated to a channel configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamsUserIdentities(TeamsUserIdentity... teamsUserIdentities);

        /**
         * <p>
         * User level permissions associated to a channel configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chatbot.model.TeamsUserIdentity.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.chatbot.model.TeamsUserIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chatbot.model.TeamsUserIdentity.Builder#build()} is called immediately
         * and its result is passed to {@link #teamsUserIdentities(List<TeamsUserIdentity>)}.
         * 
         * @param teamsUserIdentities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chatbot.model.TeamsUserIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teamsUserIdentities(java.util.Collection<TeamsUserIdentity>)
         */
        Builder teamsUserIdentities(Consumer<TeamsUserIdentity.Builder>... teamsUserIdentities);

        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by MaxResults.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChatbotResponse.BuilderImpl implements Builder {
        private List<TeamsUserIdentity> teamsUserIdentities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMicrosoftTeamsUserIdentitiesResponse model) {
            super(model);
            teamsUserIdentities(model.teamsUserIdentities);
            nextToken(model.nextToken);
        }

        public final List<TeamsUserIdentity.Builder> getTeamsUserIdentities() {
            List<TeamsUserIdentity.Builder> result = TeamsUserIdentitiesListCopier.copyToBuilder(this.teamsUserIdentities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTeamsUserIdentities(Collection<TeamsUserIdentity.BuilderImpl> teamsUserIdentities) {
            this.teamsUserIdentities = TeamsUserIdentitiesListCopier.copyFromBuilder(teamsUserIdentities);
        }

        @Override
        public final Builder teamsUserIdentities(Collection<TeamsUserIdentity> teamsUserIdentities) {
            this.teamsUserIdentities = TeamsUserIdentitiesListCopier.copy(teamsUserIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamsUserIdentities(TeamsUserIdentity... teamsUserIdentities) {
            teamsUserIdentities(Arrays.asList(teamsUserIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamsUserIdentities(Consumer<TeamsUserIdentity.Builder>... teamsUserIdentities) {
            teamsUserIdentities(Stream.of(teamsUserIdentities).map(c -> TeamsUserIdentity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMicrosoftTeamsUserIdentitiesResponse build() {
            return new ListMicrosoftTeamsUserIdentitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
