/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.ChatbotResponse;
import software.amazon.awssdk.services.chatbot.model.SlackUserIdentitiesListCopier;
import software.amazon.awssdk.services.chatbot.model.SlackUserIdentity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSlackUserIdentitiesResponse
extends ChatbotResponse
implements ToCopyableBuilder<Builder, DescribeSlackUserIdentitiesResponse> {
    private static final SdkField<List<SlackUserIdentity>> SLACK_USER_IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SlackUserIdentities").getter(DescribeSlackUserIdentitiesResponse.getter(DescribeSlackUserIdentitiesResponse::slackUserIdentities)).setter(DescribeSlackUserIdentitiesResponse.setter(Builder::slackUserIdentities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackUserIdentities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlackUserIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSlackUserIdentitiesResponse.getter(DescribeSlackUserIdentitiesResponse::nextToken)).setter(DescribeSlackUserIdentitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLACK_USER_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSlackUserIdentitiesResponse.memberNameToFieldInitializer();
    private final List<SlackUserIdentity> slackUserIdentities;
    private final String nextToken;

    private DescribeSlackUserIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.slackUserIdentities = builder.slackUserIdentities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSlackUserIdentities() {
        return this.slackUserIdentities != null && !(this.slackUserIdentities instanceof SdkAutoConstructList);
    }

    public final List<SlackUserIdentity> slackUserIdentities() {
        return this.slackUserIdentities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlackUserIdentities() ? this.slackUserIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSlackUserIdentitiesResponse)) {
            return false;
        }
        DescribeSlackUserIdentitiesResponse other = (DescribeSlackUserIdentitiesResponse)((Object)obj);
        return this.hasSlackUserIdentities() == other.hasSlackUserIdentities() && Objects.equals(this.slackUserIdentities(), other.slackUserIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSlackUserIdentitiesResponse").add("SlackUserIdentities", this.hasSlackUserIdentities() ? this.slackUserIdentities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SlackUserIdentities": {
                return Optional.ofNullable(clazz.cast(this.slackUserIdentities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SlackUserIdentities", SLACK_USER_IDENTITIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSlackUserIdentitiesResponse, T> g) {
        return obj -> g.apply((DescribeSlackUserIdentitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChatbotResponse.BuilderImpl
    implements Builder {
        private List<SlackUserIdentity> slackUserIdentities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSlackUserIdentitiesResponse model) {
            super(model);
            this.slackUserIdentities(model.slackUserIdentities);
            this.nextToken(model.nextToken);
        }

        public final List<SlackUserIdentity.Builder> getSlackUserIdentities() {
            List<SlackUserIdentity.Builder> result = SlackUserIdentitiesListCopier.copyToBuilder(this.slackUserIdentities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlackUserIdentities(Collection<SlackUserIdentity.BuilderImpl> slackUserIdentities) {
            this.slackUserIdentities = SlackUserIdentitiesListCopier.copyFromBuilder(slackUserIdentities);
        }

        @Override
        public final Builder slackUserIdentities(Collection<SlackUserIdentity> slackUserIdentities) {
            this.slackUserIdentities = SlackUserIdentitiesListCopier.copy(slackUserIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackUserIdentities(SlackUserIdentity ... slackUserIdentities) {
            this.slackUserIdentities(Arrays.asList(slackUserIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackUserIdentities(Consumer<SlackUserIdentity.Builder> ... slackUserIdentities) {
            this.slackUserIdentities(Stream.of(slackUserIdentities).map(c -> (SlackUserIdentity)((SlackUserIdentity.Builder)SlackUserIdentity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSlackUserIdentitiesResponse build() {
            return new DescribeSlackUserIdentitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChatbotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSlackUserIdentitiesResponse> {
        public Builder slackUserIdentities(Collection<SlackUserIdentity> var1);

        public Builder slackUserIdentities(SlackUserIdentity ... var1);

        public Builder slackUserIdentities(Consumer<SlackUserIdentity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

