/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotAsyncClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.SlackUserIdentity;

public class DescribeSlackUserIdentitiesPublisher
implements SdkPublisher<DescribeSlackUserIdentitiesResponse> {
    private final ChatbotAsyncClient client;
    private final DescribeSlackUserIdentitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSlackUserIdentitiesPublisher(ChatbotAsyncClient client, DescribeSlackUserIdentitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSlackUserIdentitiesPublisher(ChatbotAsyncClient client, DescribeSlackUserIdentitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSlackUserIdentitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSlackUserIdentitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SlackUserIdentity> slackUserIdentities() {
        Function<DescribeSlackUserIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.slackUserIdentities() != null) {
                return response.slackUserIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSlackUserIdentitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSlackUserIdentitiesResponseFetcher
    implements AsyncPageFetcher<DescribeSlackUserIdentitiesResponse> {
        private DescribeSlackUserIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSlackUserIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSlackUserIdentitiesResponse> nextPage(DescribeSlackUserIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSlackUserIdentitiesPublisher.this.client.describeSlackUserIdentities(DescribeSlackUserIdentitiesPublisher.this.firstRequest);
            }
            return DescribeSlackUserIdentitiesPublisher.this.client.describeSlackUserIdentities((DescribeSlackUserIdentitiesRequest)((Object)DescribeSlackUserIdentitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

