/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssessmentRunAgentsRequest extends InspectorRequest implements
        ToCopyableBuilder<ListAssessmentRunAgentsRequest.Builder, ListAssessmentRunAgentsRequest> {
    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentRunArn").getter(getter(ListAssessmentRunAgentsRequest::assessmentRunArn))
            .setter(setter(Builder::assessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()).build();

    private static final SdkField<AgentFilter> FILTER_FIELD = SdkField.<AgentFilter> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(ListAssessmentRunAgentsRequest::filter)).setter(setter(Builder::filter))
            .constructor(AgentFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssessmentRunAgentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAssessmentRunAgentsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARN_FIELD,
            FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assessmentRunArn;

    private final AgentFilter filter;

    private final String nextToken;

    private final Integer maxResults;

    private ListAssessmentRunAgentsRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArn = builder.assessmentRunArn;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ARN that specifies the assessment run whose agents you want to list.
     * </p>
     * 
     * @return The ARN that specifies the assessment run whose agents you want to list.
     */
    public final String assessmentRunArn() {
        return assessmentRunArn;
    }

    /**
     * <p>
     * You can use this parameter to specify a subset of data to be included in the action's response.
     * </p>
     * <p>
     * For a record to match a filter, all specified filter attributes must match. When multiple values are specified
     * for a filter attribute, any of the values can match.
     * </p>
     * 
     * @return You can use this parameter to specify a subset of data to be included in the action's response.</p>
     *         <p>
     *         For a record to match a filter, all specified filter attributes must match. When multiple values are
     *         specified for a filter attribute, any of the values can match.
     */
    public final AgentFilter filter() {
        return filter;
    }

    /**
     * <p>
     * You can use this parameter when paginating results. Set the value of this parameter to null on your first call to
     * the <b>ListAssessmentRunAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request
     * with the value of <b>NextToken</b> from the previous response to continue listing data.
     * </p>
     * 
     * @return You can use this parameter when paginating results. Set the value of this parameter to null on your first
     *         call to the <b>ListAssessmentRunAgents</b> action. Subsequent calls to the action fill <b>nextToken</b>
     *         in the request with the value of <b>NextToken</b> from the previous response to continue listing data.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * You can use this parameter to indicate the maximum number of items that you want in the response. The default
     * value is 10. The maximum value is 500.
     * </p>
     * 
     * @return You can use this parameter to indicate the maximum number of items that you want in the response. The
     *         default value is 10. The maximum value is 500.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentRunAgentsRequest)) {
            return false;
        }
        ListAssessmentRunAgentsRequest other = (ListAssessmentRunAgentsRequest) obj;
        return Objects.equals(assessmentRunArn(), other.assessmentRunArn()) && Objects.equals(filter(), other.filter())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssessmentRunAgentsRequest").add("AssessmentRunArn", assessmentRunArn())
                .add("Filter", filter()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentRunArn":
            return Optional.ofNullable(clazz.cast(assessmentRunArn()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assessmentRunArn", ASSESSMENT_RUN_ARN_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentRunAgentsRequest, T> g) {
        return obj -> g.apply((ListAssessmentRunAgentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAssessmentRunAgentsRequest> {
        /**
         * <p>
         * The ARN that specifies the assessment run whose agents you want to list.
         * </p>
         * 
         * @param assessmentRunArn
         *        The ARN that specifies the assessment run whose agents you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArn(String assessmentRunArn);

        /**
         * <p>
         * You can use this parameter to specify a subset of data to be included in the action's response.
         * </p>
         * <p>
         * For a record to match a filter, all specified filter attributes must match. When multiple values are
         * specified for a filter attribute, any of the values can match.
         * </p>
         * 
         * @param filter
         *        You can use this parameter to specify a subset of data to be included in the action's response.</p>
         *        <p>
         *        For a record to match a filter, all specified filter attributes must match. When multiple values are
         *        specified for a filter attribute, any of the values can match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(AgentFilter filter);

        /**
         * <p>
         * You can use this parameter to specify a subset of data to be included in the action's response.
         * </p>
         * <p>
         * For a record to match a filter, all specified filter attributes must match. When multiple values are
         * specified for a filter attribute, any of the values can match.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentFilter.Builder} avoiding the need to
         * create one manually via {@link AgentFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(AgentFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link AgentFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(AgentFilter)
         */
        default Builder filter(Consumer<AgentFilter.Builder> filter) {
            return filter(AgentFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * You can use this parameter when paginating results. Set the value of this parameter to null on your first
         * call to the <b>ListAssessmentRunAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in
         * the request with the value of <b>NextToken</b> from the previous response to continue listing data.
         * </p>
         * 
         * @param nextToken
         *        You can use this parameter when paginating results. Set the value of this parameter to null on your
         *        first call to the <b>ListAssessmentRunAgents</b> action. Subsequent calls to the action fill
         *        <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to
         *        continue listing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * You can use this parameter to indicate the maximum number of items that you want in the response. The default
         * value is 10. The maximum value is 500.
         * </p>
         * 
         * @param maxResults
         *        You can use this parameter to indicate the maximum number of items that you want in the response. The
         *        default value is 10. The maximum value is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private String assessmentRunArn;

        private AgentFilter filter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentRunAgentsRequest model) {
            super(model);
            assessmentRunArn(model.assessmentRunArn);
            filter(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getAssessmentRunArn() {
            return assessmentRunArn;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        @Override
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        public final AgentFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(AgentFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(AgentFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssessmentRunAgentsRequest build() {
            return new ListAssessmentRunAgentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
