/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssessmentRunsRequest extends InspectorRequest implements
        ToCopyableBuilder<DescribeAssessmentRunsRequest.Builder, DescribeAssessmentRunsRequest> {
    private static final SdkField<List<String>> ASSESSMENT_RUN_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("assessmentRunArns")
            .getter(getter(DescribeAssessmentRunsRequest::assessmentRunArns))
            .setter(setter(Builder::assessmentRunArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> assessmentRunArns;

    private DescribeAssessmentRunsRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArns = builder.assessmentRunArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssessmentRunArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssessmentRunArns() {
        return assessmentRunArns != null && !(assessmentRunArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN that specifies the assessment run that you want to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessmentRunArns} method.
     * </p>
     * 
     * @return The ARN that specifies the assessment run that you want to describe.
     */
    public final List<String> assessmentRunArns() {
        return assessmentRunArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessmentRunArns() ? assessmentRunArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentRunsRequest)) {
            return false;
        }
        DescribeAssessmentRunsRequest other = (DescribeAssessmentRunsRequest) obj;
        return hasAssessmentRunArns() == other.hasAssessmentRunArns()
                && Objects.equals(assessmentRunArns(), other.assessmentRunArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAssessmentRunsRequest")
                .add("AssessmentRunArns", hasAssessmentRunArns() ? assessmentRunArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentRunArns":
            return Optional.ofNullable(clazz.cast(assessmentRunArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assessmentRunArns", ASSESSMENT_RUN_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssessmentRunsRequest, T> g) {
        return obj -> g.apply((DescribeAssessmentRunsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAssessmentRunsRequest> {
        /**
         * <p>
         * The ARN that specifies the assessment run that you want to describe.
         * </p>
         * 
         * @param assessmentRunArns
         *        The ARN that specifies the assessment run that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArns(Collection<String> assessmentRunArns);

        /**
         * <p>
         * The ARN that specifies the assessment run that you want to describe.
         * </p>
         * 
         * @param assessmentRunArns
         *        The ARN that specifies the assessment run that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArns(String... assessmentRunArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private List<String> assessmentRunArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssessmentRunsRequest model) {
            super(model);
            assessmentRunArns(model.assessmentRunArns);
        }

        public final Collection<String> getAssessmentRunArns() {
            if (assessmentRunArns instanceof SdkAutoConstructList) {
                return null;
            }
            return assessmentRunArns;
        }

        public final void setAssessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = BatchDescribeArnListCopier.copy(assessmentRunArns);
        }

        @Override
        public final Builder assessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = BatchDescribeArnListCopier.copy(assessmentRunArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRunArns(String... assessmentRunArns) {
            assessmentRunArns(Arrays.asList(assessmentRunArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssessmentRunsRequest build() {
            return new DescribeAssessmentRunsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
