/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a
 * href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountSummary.html">GetAccountSummary</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountSummaryResponse extends IamResponse implements
        ToCopyableBuilder<GetAccountSummaryResponse.Builder, GetAccountSummaryResponse> {
    private static final SdkField<Map<String, Integer>> SUMMARY_MAP_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("SummaryMap")
            .getter(getter(GetAccountSummaryResponse::summaryMapAsStrings))
            .setter(setter(Builder::summaryMapWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, Integer> summaryMap;

    private GetAccountSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.summaryMap = builder.summaryMap;
    }

    /**
     * <p>
     * A set of key–value pairs containing information about IAM entity usage and IAM quotas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSummaryMap} method.
     * </p>
     * 
     * @return A set of key–value pairs containing information about IAM entity usage and IAM quotas.
     */
    public final Map<SummaryKeyType, Integer> summaryMap() {
        return _summaryMapTypeCopier.copyStringToEnum(summaryMap);
    }

    /**
     * For responses, this returns true if the service returned a value for the SummaryMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSummaryMap() {
        return summaryMap != null && !(summaryMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key–value pairs containing information about IAM entity usage and IAM quotas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSummaryMap} method.
     * </p>
     * 
     * @return A set of key–value pairs containing information about IAM entity usage and IAM quotas.
     */
    public final Map<String, Integer> summaryMapAsStrings() {
        return summaryMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSummaryMap() ? summaryMapAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountSummaryResponse)) {
            return false;
        }
        GetAccountSummaryResponse other = (GetAccountSummaryResponse) obj;
        return hasSummaryMap() == other.hasSummaryMap() && Objects.equals(summaryMapAsStrings(), other.summaryMapAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountSummaryResponse").add("SummaryMap", hasSummaryMap() ? summaryMapAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SummaryMap":
            return Optional.ofNullable(clazz.cast(summaryMapAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SummaryMap", SUMMARY_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountSummaryResponse, T> g) {
        return obj -> g.apply((GetAccountSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountSummaryResponse> {
        /**
         * <p>
         * A set of key–value pairs containing information about IAM entity usage and IAM quotas.
         * </p>
         * 
         * @param summaryMap
         *        A set of key–value pairs containing information about IAM entity usage and IAM quotas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryMapWithStrings(Map<String, Integer> summaryMap);

        /**
         * <p>
         * A set of key–value pairs containing information about IAM entity usage and IAM quotas.
         * </p>
         * 
         * @param summaryMap
         *        A set of key–value pairs containing information about IAM entity usage and IAM quotas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryMap(Map<SummaryKeyType, Integer> summaryMap);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private Map<String, Integer> summaryMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountSummaryResponse model) {
            super(model);
            summaryMapWithStrings(model.summaryMap);
        }

        public final Map<String, Integer> getSummaryMap() {
            if (summaryMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return summaryMap;
        }

        public final void setSummaryMap(Map<String, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copy(summaryMap);
        }

        @Override
        public final Builder summaryMapWithStrings(Map<String, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copy(summaryMap);
            return this;
        }

        @Override
        public final Builder summaryMap(Map<SummaryKeyType, Integer> summaryMap) {
            this.summaryMap = _summaryMapTypeCopier.copyEnumToString(summaryMap);
            return this;
        }

        @Override
        public GetAccountSummaryResponse build() {
            return new GetAccountSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
