/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container volume mount.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeMount implements SdkPojo, Serializable, ToCopyableBuilder<VolumeMount.Builder, VolumeMount> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(VolumeMount::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> MOUNT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MountPath").getter(getter(VolumeMount::mountPath)).setter(setter(Builder::mountPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MOUNT_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String mountPath;

    private VolumeMount(BuilderImpl builder) {
        this.name = builder.name;
        this.mountPath = builder.mountPath;
    }

    /**
     * <p>
     * Volume mount name.
     * </p>
     * 
     * @return Volume mount name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Volume mount path.
     * </p>
     * 
     * @return Volume mount path.
     */
    public final String mountPath() {
        return mountPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(mountPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeMount)) {
            return false;
        }
        VolumeMount other = (VolumeMount) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(mountPath(), other.mountPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeMount").add("Name", name()).add("MountPath", mountPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MountPath":
            return Optional.ofNullable(clazz.cast(mountPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("mountPath", MOUNT_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VolumeMount, T> g) {
        return obj -> g.apply((VolumeMount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeMount> {
        /**
         * <p>
         * Volume mount name.
         * </p>
         * 
         * @param name
         *        Volume mount name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Volume mount path.
         * </p>
         * 
         * @param mountPath
         *        Volume mount path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPath(String mountPath);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String mountPath;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeMount model) {
            name(model.name);
            mountPath(model.mountPath);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMountPath() {
            return mountPath;
        }

        public final void setMountPath(String mountPath) {
            this.mountPath = mountPath;
        }

        @Override
        public final Builder mountPath(String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        @Override
        public VolumeMount build() {
            return new VolumeMount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
