/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrustedEntitySetRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateTrustedEntitySetRequest.Builder, UpdateTrustedEntitySetRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(UpdateTrustedEntitySetRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<String> TRUSTED_ENTITY_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedEntitySetId").getter(getter(UpdateTrustedEntitySetRequest::trustedEntitySetId))
            .setter(setter(Builder::trustedEntitySetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("trustedEntitySetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateTrustedEntitySetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(UpdateTrustedEntitySetRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpectedBucketOwner").getter(getter(UpdateTrustedEntitySetRequest::expectedBucketOwner))
            .setter(setter(Builder::expectedBucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedBucketOwner").build())
            .build();

    private static final SdkField<Boolean> ACTIVATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Activate").getter(getter(UpdateTrustedEntitySetRequest::activate)).setter(setter(Builder::activate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            TRUSTED_ENTITY_SET_ID_FIELD, NAME_FIELD, LOCATION_FIELD, EXPECTED_BUCKET_OWNER_FIELD, ACTIVATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String detectorId;

    private final String trustedEntitySetId;

    private final String name;

    private final String location;

    private final String expectedBucketOwner;

    private final Boolean activate;

    private UpdateTrustedEntitySetRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.trustedEntitySetId = builder.trustedEntitySetId;
        this.name = builder.name;
        this.location = builder.location;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.activate = builder.activate;
    }

    /**
     * <p>
     * The unique ID of the GuardDuty detector associated with the threat entity set that you want to update.
     * </p>
     * <p>
     * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or run
     * the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     * API.
     * </p>
     * 
     * @return The unique ID of the GuardDuty detector associated with the threat entity set that you want to
     *         update.</p>
     *         <p>
     *         To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
     *         console, or run the <a
     *         href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     *         API.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The ID returned by GuardDuty after updating the trusted entity set resource.
     * </p>
     * 
     * @return The ID returned by GuardDuty after updating the trusted entity set resource.
     */
    public final String trustedEntitySetId() {
        return trustedEntitySetId;
    }

    /**
     * <p>
     * A user-friendly name to identify the trusted entity set.
     * </p>
     * <p>
     * The name of your list can include lowercase letters, uppercase letters, numbers, dash (-), and underscore (_).
     * </p>
     * 
     * @return A user-friendly name to identify the trusted entity set.</p>
     *         <p>
     *         The name of your list can include lowercase letters, uppercase letters, numbers, dash (-), and underscore
     *         (_).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The URI of the file that contains the trusted entity set.
     * </p>
     * 
     * @return The URI of the file that contains the trusted entity set.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b> parameter.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b>
     *         parameter.
     */
    public final String expectedBucketOwner() {
        return expectedBucketOwner;
    }

    /**
     * <p>
     * A boolean value that indicates whether GuardDuty is to start using this updated trusted entity set. After you
     * update an entity set, you will need to activate it again. It might take up to 15 minutes for the updated entity
     * set to be effective.
     * </p>
     * 
     * @return A boolean value that indicates whether GuardDuty is to start using this updated trusted entity set. After
     *         you update an entity set, you will need to activate it again. It might take up to 15 minutes for the
     *         updated entity set to be effective.
     */
    public final Boolean activate() {
        return activate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(trustedEntitySetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(expectedBucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(activate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustedEntitySetRequest)) {
            return false;
        }
        UpdateTrustedEntitySetRequest other = (UpdateTrustedEntitySetRequest) obj;
        return Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(trustedEntitySetId(), other.trustedEntitySetId()) && Objects.equals(name(), other.name())
                && Objects.equals(location(), other.location())
                && Objects.equals(expectedBucketOwner(), other.expectedBucketOwner())
                && Objects.equals(activate(), other.activate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrustedEntitySetRequest").add("DetectorId", detectorId())
                .add("TrustedEntitySetId", trustedEntitySetId()).add("Name", name()).add("Location", location())
                .add("ExpectedBucketOwner", expectedBucketOwner()).add("Activate", activate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "TrustedEntitySetId":
            return Optional.ofNullable(clazz.cast(trustedEntitySetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "ExpectedBucketOwner":
            return Optional.ofNullable(clazz.cast(expectedBucketOwner()));
        case "Activate":
            return Optional.ofNullable(clazz.cast(activate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("trustedEntitySetId", TRUSTED_ENTITY_SET_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("expectedBucketOwner", EXPECTED_BUCKET_OWNER_FIELD);
        map.put("activate", ACTIVATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustedEntitySetRequest, T> g) {
        return obj -> g.apply((UpdateTrustedEntitySetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrustedEntitySetRequest> {
        /**
         * <p>
         * The unique ID of the GuardDuty detector associated with the threat entity set that you want to update.
         * </p>
         * <p>
         * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or
         * run the <a
         * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
         * API.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the GuardDuty detector associated with the threat entity set that you want to
         *        update.</p>
         *        <p>
         *        To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
         *        console, or run the <a
         *        href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html"
         *        >ListDetectors</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The ID returned by GuardDuty after updating the trusted entity set resource.
         * </p>
         * 
         * @param trustedEntitySetId
         *        The ID returned by GuardDuty after updating the trusted entity set resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedEntitySetId(String trustedEntitySetId);

        /**
         * <p>
         * A user-friendly name to identify the trusted entity set.
         * </p>
         * <p>
         * The name of your list can include lowercase letters, uppercase letters, numbers, dash (-), and underscore
         * (_).
         * </p>
         * 
         * @param name
         *        A user-friendly name to identify the trusted entity set.</p>
         *        <p>
         *        The name of your list can include lowercase letters, uppercase letters, numbers, dash (-), and
         *        underscore (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The URI of the file that contains the trusted entity set.
         * </p>
         * 
         * @param location
         *        The URI of the file that contains the trusted entity set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b> parameter.
         * </p>
         * 
         * @param expectedBucketOwner
         *        The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedBucketOwner(String expectedBucketOwner);

        /**
         * <p>
         * A boolean value that indicates whether GuardDuty is to start using this updated trusted entity set. After you
         * update an entity set, you will need to activate it again. It might take up to 15 minutes for the updated
         * entity set to be effective.
         * </p>
         * 
         * @param activate
         *        A boolean value that indicates whether GuardDuty is to start using this updated trusted entity set.
         *        After you update an entity set, you will need to activate it again. It might take up to 15 minutes for
         *        the updated entity set to be effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activate(Boolean activate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String trustedEntitySetId;

        private String name;

        private String location;

        private String expectedBucketOwner;

        private Boolean activate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustedEntitySetRequest model) {
            super(model);
            detectorId(model.detectorId);
            trustedEntitySetId(model.trustedEntitySetId);
            name(model.name);
            location(model.location);
            expectedBucketOwner(model.expectedBucketOwner);
            activate(model.activate);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getTrustedEntitySetId() {
            return trustedEntitySetId;
        }

        public final void setTrustedEntitySetId(String trustedEntitySetId) {
            this.trustedEntitySetId = trustedEntitySetId;
        }

        @Override
        public final Builder trustedEntitySetId(String trustedEntitySetId) {
            this.trustedEntitySetId = trustedEntitySetId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getExpectedBucketOwner() {
            return expectedBucketOwner;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public final Boolean getActivate() {
            return activate;
        }

        public final void setActivate(Boolean activate) {
            this.activate = activate;
        }

        @Override
        public final Builder activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrustedEntitySetRequest build() {
            return new UpdateTrustedEntitySetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
