/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIpSetRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateIpSetRequest.Builder, UpdateIpSetRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(UpdateIpSetRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<String> IP_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpSetId").getter(getter(UpdateIpSetRequest::ipSetId)).setter(setter(Builder::ipSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ipSetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateIpSetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(UpdateIpSetRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<Boolean> ACTIVATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Activate").getter(getter(UpdateIpSetRequest::activate)).setter(setter(Builder::activate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activate").build()).build();

    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpectedBucketOwner").getter(getter(UpdateIpSetRequest::expectedBucketOwner))
            .setter(setter(Builder::expectedBucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedBucketOwner").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            IP_SET_ID_FIELD, NAME_FIELD, LOCATION_FIELD, ACTIVATE_FIELD, EXPECTED_BUCKET_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String detectorId;

    private final String ipSetId;

    private final String name;

    private final String location;

    private final Boolean activate;

    private final String expectedBucketOwner;

    private UpdateIpSetRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.ipSetId = builder.ipSetId;
        this.name = builder.name;
        this.location = builder.location;
        this.activate = builder.activate;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    /**
     * <p>
     * The detectorID that specifies the GuardDuty service whose IPSet you want to update.
     * </p>
     * <p>
     * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or run
     * the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     * API.
     * </p>
     * 
     * @return The detectorID that specifies the GuardDuty service whose IPSet you want to update.</p>
     *         <p>
     *         To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
     *         console, or run the <a
     *         href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     *         API.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The unique ID that specifies the IPSet that you want to update.
     * </p>
     * 
     * @return The unique ID that specifies the IPSet that you want to update.
     */
    public final String ipSetId() {
        return ipSetId;
    }

    /**
     * <p>
     * The unique ID that specifies the IPSet that you want to update.
     * </p>
     * 
     * @return The unique ID that specifies the IPSet that you want to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated URI of the file that contains the IPSet.
     * </p>
     * 
     * @return The updated URI of the file that contains the IPSet.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The updated Boolean value that specifies whether the IPSet is active or not.
     * </p>
     * 
     * @return The updated Boolean value that specifies whether the IPSet is active or not.
     */
    public final Boolean activate() {
        return activate;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b> parameter.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b>
     *         parameter.
     */
    public final String expectedBucketOwner() {
        return expectedBucketOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(ipSetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(activate());
        hashCode = 31 * hashCode + Objects.hashCode(expectedBucketOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIpSetRequest)) {
            return false;
        }
        UpdateIpSetRequest other = (UpdateIpSetRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(ipSetId(), other.ipSetId())
                && Objects.equals(name(), other.name()) && Objects.equals(location(), other.location())
                && Objects.equals(activate(), other.activate())
                && Objects.equals(expectedBucketOwner(), other.expectedBucketOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIpSetRequest").add("DetectorId", detectorId()).add("IpSetId", ipSetId())
                .add("Name", name()).add("Location", location()).add("Activate", activate())
                .add("ExpectedBucketOwner", expectedBucketOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "IpSetId":
            return Optional.ofNullable(clazz.cast(ipSetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Activate":
            return Optional.ofNullable(clazz.cast(activate()));
        case "ExpectedBucketOwner":
            return Optional.ofNullable(clazz.cast(expectedBucketOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("ipSetId", IP_SET_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("activate", ACTIVATE_FIELD);
        map.put("expectedBucketOwner", EXPECTED_BUCKET_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIpSetRequest, T> g) {
        return obj -> g.apply((UpdateIpSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateIpSetRequest> {
        /**
         * <p>
         * The detectorID that specifies the GuardDuty service whose IPSet you want to update.
         * </p>
         * <p>
         * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or
         * run the <a
         * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
         * API.
         * </p>
         * 
         * @param detectorId
         *        The detectorID that specifies the GuardDuty service whose IPSet you want to update.</p>
         *        <p>
         *        To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
         *        console, or run the <a
         *        href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html"
         *        >ListDetectors</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The unique ID that specifies the IPSet that you want to update.
         * </p>
         * 
         * @param ipSetId
         *        The unique ID that specifies the IPSet that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipSetId(String ipSetId);

        /**
         * <p>
         * The unique ID that specifies the IPSet that you want to update.
         * </p>
         * 
         * @param name
         *        The unique ID that specifies the IPSet that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated URI of the file that contains the IPSet.
         * </p>
         * 
         * @param location
         *        The updated URI of the file that contains the IPSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The updated Boolean value that specifies whether the IPSet is active or not.
         * </p>
         * 
         * @param activate
         *        The updated Boolean value that specifies whether the IPSet is active or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activate(Boolean activate);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b> parameter.
         * </p>
         * 
         * @param expectedBucketOwner
         *        The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedBucketOwner(String expectedBucketOwner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String ipSetId;

        private String name;

        private String location;

        private Boolean activate;

        private String expectedBucketOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIpSetRequest model) {
            super(model);
            detectorId(model.detectorId);
            ipSetId(model.ipSetId);
            name(model.name);
            location(model.location);
            activate(model.activate);
            expectedBucketOwner(model.expectedBucketOwner);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getIpSetId() {
            return ipSetId;
        }

        public final void setIpSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final Boolean getActivate() {
            return activate;
        }

        public final void setActivate(Boolean activate) {
            this.activate = activate;
        }

        @Override
        public final Builder activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        public final String getExpectedBucketOwner() {
            return expectedBucketOwner;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIpSetRequest build() {
            return new UpdateIpSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
