/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the detected threats associated with the generated finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Threat implements SdkPojo, Serializable, ToCopyableBuilder<Threat.Builder, Threat> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Threat::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(Threat::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<List<ItemPath>> ITEM_PATHS_FIELD = SdkField
            .<List<ItemPath>> builder(MarshallingType.LIST)
            .memberName("ItemPaths")
            .getter(getter(Threat::itemPaths))
            .setter(setter(Builder::itemPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ItemPath> builder(MarshallingType.SDK_POJO)
                                            .constructor(ItemPath::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOURCE_FIELD,
            ITEM_PATHS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String source;

    private final List<ItemPath> itemPaths;

    private Threat(BuilderImpl builder) {
        this.name = builder.name;
        this.source = builder.source;
        this.itemPaths = builder.itemPaths;
    }

    /**
     * <p>
     * Name of the detected threat that caused GuardDuty to generate this finding.
     * </p>
     * 
     * @return Name of the detected threat that caused GuardDuty to generate this finding.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Source of the threat that generated this finding.
     * </p>
     * 
     * @return Source of the threat that generated this finding.
     */
    public final String source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the ItemPaths property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasItemPaths() {
        return itemPaths != null && !(itemPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the nested item path and hash of the protected resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItemPaths} method.
     * </p>
     * 
     * @return Information about the nested item path and hash of the protected resource.
     */
    public final List<ItemPath> itemPaths() {
        return itemPaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasItemPaths() ? itemPaths() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Threat)) {
            return false;
        }
        Threat other = (Threat) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(source(), other.source())
                && hasItemPaths() == other.hasItemPaths() && Objects.equals(itemPaths(), other.itemPaths());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Threat").add("Name", name()).add("Source", source())
                .add("ItemPaths", hasItemPaths() ? itemPaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ItemPaths":
            return Optional.ofNullable(clazz.cast(itemPaths()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("itemPaths", ITEM_PATHS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Threat, T> g) {
        return obj -> g.apply((Threat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Threat> {
        /**
         * <p>
         * Name of the detected threat that caused GuardDuty to generate this finding.
         * </p>
         * 
         * @param name
         *        Name of the detected threat that caused GuardDuty to generate this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Source of the threat that generated this finding.
         * </p>
         * 
         * @param source
         *        Source of the threat that generated this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * Information about the nested item path and hash of the protected resource.
         * </p>
         * 
         * @param itemPaths
         *        Information about the nested item path and hash of the protected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemPaths(Collection<ItemPath> itemPaths);

        /**
         * <p>
         * Information about the nested item path and hash of the protected resource.
         * </p>
         * 
         * @param itemPaths
         *        Information about the nested item path and hash of the protected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemPaths(ItemPath... itemPaths);

        /**
         * <p>
         * Information about the nested item path and hash of the protected resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.ItemPath.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.ItemPath#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.ItemPath.Builder#build()} is called immediately and
         * its result is passed to {@link #itemPaths(List<ItemPath>)}.
         * 
         * @param itemPaths
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.ItemPath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemPaths(java.util.Collection<ItemPath>)
         */
        Builder itemPaths(Consumer<ItemPath.Builder>... itemPaths);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String source;

        private List<ItemPath> itemPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Threat model) {
            name(model.name);
            source(model.source);
            itemPaths(model.itemPaths);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final List<ItemPath.Builder> getItemPaths() {
            List<ItemPath.Builder> result = ItemPathsCopier.copyToBuilder(this.itemPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItemPaths(Collection<ItemPath.BuilderImpl> itemPaths) {
            this.itemPaths = ItemPathsCopier.copyFromBuilder(itemPaths);
        }

        @Override
        public final Builder itemPaths(Collection<ItemPath> itemPaths) {
            this.itemPaths = ItemPathsCopier.copy(itemPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemPaths(ItemPath... itemPaths) {
            itemPaths(Arrays.asList(itemPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemPaths(Consumer<ItemPath.Builder>... itemPaths) {
            itemPaths(Stream.of(itemPaths).map(c -> ItemPath.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Threat build() {
            return new Threat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
