/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the GuardDuty attack sequence finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Sequence implements SdkPojo, Serializable, ToCopyableBuilder<Sequence.Builder, Sequence> {
    private static final SdkField<String> UID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uid")
            .getter(getter(Sequence::uid)).setter(setter(Builder::uid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Sequence::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Actor>> ACTORS_FIELD = SdkField
            .<List<Actor>> builder(MarshallingType.LIST)
            .memberName("Actors")
            .getter(getter(Sequence::actors))
            .setter(setter(Builder::actors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Actor> builder(MarshallingType.SDK_POJO)
                                            .constructor(Actor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourceV2>> RESOURCES_FIELD = SdkField
            .<List<ResourceV2>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(Sequence::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NetworkEndpoint>> ENDPOINTS_FIELD = SdkField
            .<List<NetworkEndpoint>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(Sequence::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Signal>> SIGNALS_FIELD = SdkField
            .<List<Signal>> builder(MarshallingType.LIST)
            .memberName("Signals")
            .getter(getter(Sequence::signals))
            .setter(setter(Builder::signals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Signal> builder(MarshallingType.SDK_POJO)
                                            .constructor(Signal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Indicator>> SEQUENCE_INDICATORS_FIELD = SdkField
            .<List<Indicator>> builder(MarshallingType.LIST)
            .memberName("SequenceIndicators")
            .getter(getter(Sequence::sequenceIndicators))
            .setter(setter(Builder::sequenceIndicators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceIndicators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Indicator> builder(MarshallingType.SDK_POJO)
                                            .constructor(Indicator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ADDITIONAL_SEQUENCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalSequenceTypes")
            .getter(getter(Sequence::additionalSequenceTypes))
            .setter(setter(Builder::additionalSequenceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalSequenceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, DESCRIPTION_FIELD,
            ACTORS_FIELD, RESOURCES_FIELD, ENDPOINTS_FIELD, SIGNALS_FIELD, SEQUENCE_INDICATORS_FIELD,
            ADDITIONAL_SEQUENCE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String uid;

    private final String description;

    private final List<Actor> actors;

    private final List<ResourceV2> resources;

    private final List<NetworkEndpoint> endpoints;

    private final List<Signal> signals;

    private final List<Indicator> sequenceIndicators;

    private final List<String> additionalSequenceTypes;

    private Sequence(BuilderImpl builder) {
        this.uid = builder.uid;
        this.description = builder.description;
        this.actors = builder.actors;
        this.resources = builder.resources;
        this.endpoints = builder.endpoints;
        this.signals = builder.signals;
        this.sequenceIndicators = builder.sequenceIndicators;
        this.additionalSequenceTypes = builder.additionalSequenceTypes;
    }

    /**
     * <p>
     * Unique identifier of the attack sequence.
     * </p>
     * 
     * @return Unique identifier of the attack sequence.
     */
    public final String uid() {
        return uid;
    }

    /**
     * <p>
     * Description of the attack sequence.
     * </p>
     * 
     * @return Description of the attack sequence.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActors() {
        return actors != null && !(actors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the actors involved in the attack sequence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActors} method.
     * </p>
     * 
     * @return Contains information about the actors involved in the attack sequence.
     */
    public final List<Actor> actors() {
        return actors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the resources involved in the attack sequence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return Contains information about the resources involved in the attack sequence.
     */
    public final List<ResourceV2> resources() {
        return resources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the network endpoints that were used in the attack sequence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return Contains information about the network endpoints that were used in the attack sequence.
     */
    public final List<NetworkEndpoint> endpoints() {
        return endpoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the Signals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSignals() {
        return signals != null && !(signals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the signals involved in the attack sequence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignals} method.
     * </p>
     * 
     * @return Contains information about the signals involved in the attack sequence.
     */
    public final List<Signal> signals() {
        return signals;
    }

    /**
     * For responses, this returns true if the service returned a value for the SequenceIndicators property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSequenceIndicators() {
        return sequenceIndicators != null && !(sequenceIndicators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the indicators observed in the attack sequence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSequenceIndicators} method.
     * </p>
     * 
     * @return Contains information about the indicators observed in the attack sequence.
     */
    public final List<Indicator> sequenceIndicators() {
        return sequenceIndicators;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalSequenceTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalSequenceTypes() {
        return additionalSequenceTypes != null && !(additionalSequenceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional types of sequences that may be associated with the attack sequence finding, providing further context
     * about the nature of the detected threat.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalSequenceTypes} method.
     * </p>
     * 
     * @return Additional types of sequences that may be associated with the attack sequence finding, providing further
     *         context about the nature of the detected threat.
     */
    public final List<String> additionalSequenceTypes() {
        return additionalSequenceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uid());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasActors() ? actors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSignals() ? signals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSequenceIndicators() ? sequenceIndicators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalSequenceTypes() ? additionalSequenceTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence) obj;
        return Objects.equals(uid(), other.uid()) && Objects.equals(description(), other.description())
                && hasActors() == other.hasActors() && Objects.equals(actors(), other.actors())
                && hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints())
                && hasSignals() == other.hasSignals() && Objects.equals(signals(), other.signals())
                && hasSequenceIndicators() == other.hasSequenceIndicators()
                && Objects.equals(sequenceIndicators(), other.sequenceIndicators())
                && hasAdditionalSequenceTypes() == other.hasAdditionalSequenceTypes()
                && Objects.equals(additionalSequenceTypes(), other.additionalSequenceTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Sequence").add("Uid", uid()).add("Description", description())
                .add("Actors", hasActors() ? actors() : null).add("Resources", hasResources() ? resources() : null)
                .add("Endpoints", hasEndpoints() ? endpoints() : null).add("Signals", hasSignals() ? signals() : null)
                .add("SequenceIndicators", hasSequenceIndicators() ? sequenceIndicators() : null)
                .add("AdditionalSequenceTypes", hasAdditionalSequenceTypes() ? additionalSequenceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uid":
            return Optional.ofNullable(clazz.cast(uid()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Actors":
            return Optional.ofNullable(clazz.cast(actors()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "Signals":
            return Optional.ofNullable(clazz.cast(signals()));
        case "SequenceIndicators":
            return Optional.ofNullable(clazz.cast(sequenceIndicators()));
        case "AdditionalSequenceTypes":
            return Optional.ofNullable(clazz.cast(additionalSequenceTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("uid", UID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("actors", ACTORS_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        map.put("signals", SIGNALS_FIELD);
        map.put("sequenceIndicators", SEQUENCE_INDICATORS_FIELD);
        map.put("additionalSequenceTypes", ADDITIONAL_SEQUENCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sequence, T> g) {
        return obj -> g.apply((Sequence) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Sequence> {
        /**
         * <p>
         * Unique identifier of the attack sequence.
         * </p>
         * 
         * @param uid
         *        Unique identifier of the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uid(String uid);

        /**
         * <p>
         * Description of the attack sequence.
         * </p>
         * 
         * @param description
         *        Description of the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Contains information about the actors involved in the attack sequence.
         * </p>
         * 
         * @param actors
         *        Contains information about the actors involved in the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actors(Collection<Actor> actors);

        /**
         * <p>
         * Contains information about the actors involved in the attack sequence.
         * </p>
         * 
         * @param actors
         *        Contains information about the actors involved in the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actors(Actor... actors);

        /**
         * <p>
         * Contains information about the actors involved in the attack sequence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Actor.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.Actor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Actor.Builder#build()} is called immediately and its
         * result is passed to {@link #actors(List<Actor>)}.
         * 
         * @param actors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Actor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actors(java.util.Collection<Actor>)
         */
        Builder actors(Consumer<Actor.Builder>... actors);

        /**
         * <p>
         * Contains information about the resources involved in the attack sequence.
         * </p>
         * 
         * @param resources
         *        Contains information about the resources involved in the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<ResourceV2> resources);

        /**
         * <p>
         * Contains information about the resources involved in the attack sequence.
         * </p>
         * 
         * @param resources
         *        Contains information about the resources involved in the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(ResourceV2... resources);

        /**
         * <p>
         * Contains information about the resources involved in the attack sequence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.ResourceV2.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.ResourceV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.ResourceV2.Builder#build()} is called immediately and
         * its result is passed to {@link #resources(List<ResourceV2>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.ResourceV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<ResourceV2>)
         */
        Builder resources(Consumer<ResourceV2.Builder>... resources);

        /**
         * <p>
         * Contains information about the network endpoints that were used in the attack sequence.
         * </p>
         * 
         * @param endpoints
         *        Contains information about the network endpoints that were used in the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<NetworkEndpoint> endpoints);

        /**
         * <p>
         * Contains information about the network endpoints that were used in the attack sequence.
         * </p>
         * 
         * @param endpoints
         *        Contains information about the network endpoints that were used in the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(NetworkEndpoint... endpoints);

        /**
         * <p>
         * Contains information about the network endpoints that were used in the attack sequence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.NetworkEndpoint.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.guardduty.model.NetworkEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.NetworkEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #endpoints(List<NetworkEndpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.NetworkEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(java.util.Collection<NetworkEndpoint>)
         */
        Builder endpoints(Consumer<NetworkEndpoint.Builder>... endpoints);

        /**
         * <p>
         * Contains information about the signals involved in the attack sequence.
         * </p>
         * 
         * @param signals
         *        Contains information about the signals involved in the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signals(Collection<Signal> signals);

        /**
         * <p>
         * Contains information about the signals involved in the attack sequence.
         * </p>
         * 
         * @param signals
         *        Contains information about the signals involved in the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signals(Signal... signals);

        /**
         * <p>
         * Contains information about the signals involved in the attack sequence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Signal.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.Signal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Signal.Builder#build()} is called immediately and its
         * result is passed to {@link #signals(List<Signal>)}.
         * 
         * @param signals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Signal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signals(java.util.Collection<Signal>)
         */
        Builder signals(Consumer<Signal.Builder>... signals);

        /**
         * <p>
         * Contains information about the indicators observed in the attack sequence.
         * </p>
         * 
         * @param sequenceIndicators
         *        Contains information about the indicators observed in the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceIndicators(Collection<Indicator> sequenceIndicators);

        /**
         * <p>
         * Contains information about the indicators observed in the attack sequence.
         * </p>
         * 
         * @param sequenceIndicators
         *        Contains information about the indicators observed in the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceIndicators(Indicator... sequenceIndicators);

        /**
         * <p>
         * Contains information about the indicators observed in the attack sequence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Indicator.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.Indicator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Indicator.Builder#build()} is called immediately and
         * its result is passed to {@link #sequenceIndicators(List<Indicator>)}.
         * 
         * @param sequenceIndicators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Indicator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sequenceIndicators(java.util.Collection<Indicator>)
         */
        Builder sequenceIndicators(Consumer<Indicator.Builder>... sequenceIndicators);

        /**
         * <p>
         * Additional types of sequences that may be associated with the attack sequence finding, providing further
         * context about the nature of the detected threat.
         * </p>
         * 
         * @param additionalSequenceTypes
         *        Additional types of sequences that may be associated with the attack sequence finding, providing
         *        further context about the nature of the detected threat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalSequenceTypes(Collection<String> additionalSequenceTypes);

        /**
         * <p>
         * Additional types of sequences that may be associated with the attack sequence finding, providing further
         * context about the nature of the detected threat.
         * </p>
         * 
         * @param additionalSequenceTypes
         *        Additional types of sequences that may be associated with the attack sequence finding, providing
         *        further context about the nature of the detected threat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalSequenceTypes(String... additionalSequenceTypes);
    }

    static final class BuilderImpl implements Builder {
        private String uid;

        private String description;

        private List<Actor> actors = DefaultSdkAutoConstructList.getInstance();

        private List<ResourceV2> resources = DefaultSdkAutoConstructList.getInstance();

        private List<NetworkEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private List<Signal> signals = DefaultSdkAutoConstructList.getInstance();

        private List<Indicator> sequenceIndicators = DefaultSdkAutoConstructList.getInstance();

        private List<String> additionalSequenceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Sequence model) {
            uid(model.uid);
            description(model.description);
            actors(model.actors);
            resources(model.resources);
            endpoints(model.endpoints);
            signals(model.signals);
            sequenceIndicators(model.sequenceIndicators);
            additionalSequenceTypes(model.additionalSequenceTypes);
        }

        public final String getUid() {
            return uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Actor.Builder> getActors() {
            List<Actor.Builder> result = ActorsCopier.copyToBuilder(this.actors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActors(Collection<Actor.BuilderImpl> actors) {
            this.actors = ActorsCopier.copyFromBuilder(actors);
        }

        @Override
        public final Builder actors(Collection<Actor> actors) {
            this.actors = ActorsCopier.copy(actors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actors(Actor... actors) {
            actors(Arrays.asList(actors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actors(Consumer<Actor.Builder>... actors) {
            actors(Stream.of(actors).map(c -> Actor.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceV2.Builder> getResources() {
            List<ResourceV2.Builder> result = ResourcesCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourceV2.BuilderImpl> resources) {
            this.resources = ResourcesCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<ResourceV2> resources) {
            this.resources = ResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(ResourceV2... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<ResourceV2.Builder>... resources) {
            resources(Stream.of(resources).map(c -> ResourceV2.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NetworkEndpoint.Builder> getEndpoints() {
            List<NetworkEndpoint.Builder> result = NetworkEndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<NetworkEndpoint.BuilderImpl> endpoints) {
            this.endpoints = NetworkEndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<NetworkEndpoint> endpoints) {
            this.endpoints = NetworkEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(NetworkEndpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<NetworkEndpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> NetworkEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Signal.Builder> getSignals() {
            List<Signal.Builder> result = SignalsCopier.copyToBuilder(this.signals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignals(Collection<Signal.BuilderImpl> signals) {
            this.signals = SignalsCopier.copyFromBuilder(signals);
        }

        @Override
        public final Builder signals(Collection<Signal> signals) {
            this.signals = SignalsCopier.copy(signals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signals(Signal... signals) {
            signals(Arrays.asList(signals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signals(Consumer<Signal.Builder>... signals) {
            signals(Stream.of(signals).map(c -> Signal.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Indicator.Builder> getSequenceIndicators() {
            List<Indicator.Builder> result = IndicatorsCopier.copyToBuilder(this.sequenceIndicators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSequenceIndicators(Collection<Indicator.BuilderImpl> sequenceIndicators) {
            this.sequenceIndicators = IndicatorsCopier.copyFromBuilder(sequenceIndicators);
        }

        @Override
        public final Builder sequenceIndicators(Collection<Indicator> sequenceIndicators) {
            this.sequenceIndicators = IndicatorsCopier.copy(sequenceIndicators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sequenceIndicators(Indicator... sequenceIndicators) {
            sequenceIndicators(Arrays.asList(sequenceIndicators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sequenceIndicators(Consumer<Indicator.Builder>... sequenceIndicators) {
            sequenceIndicators(Stream.of(sequenceIndicators).map(c -> Indicator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAdditionalSequenceTypes() {
            if (additionalSequenceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalSequenceTypes;
        }

        public final void setAdditionalSequenceTypes(Collection<String> additionalSequenceTypes) {
            this.additionalSequenceTypes = AdditionalSequenceTypesCopier.copy(additionalSequenceTypes);
        }

        @Override
        public final Builder additionalSequenceTypes(Collection<String> additionalSequenceTypes) {
            this.additionalSequenceTypes = AdditionalSequenceTypesCopier.copy(additionalSequenceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSequenceTypes(String... additionalSequenceTypes) {
            additionalSequenceTypes(Arrays.asList(additionalSequenceTypes));
            return this;
        }

        @Override
        public Sequence build() {
            return new Sequence(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
