/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of infected file including name, file path and hash.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanFilePath implements SdkPojo, Serializable, ToCopyableBuilder<ScanFilePath.Builder, ScanFilePath> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilePath").getter(getter(ScanFilePath::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeArn").getter(getter(ScanFilePath::volumeArn)).setter(setter(Builder::volumeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeArn").build()).build();

    private static final SdkField<String> HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Hash")
            .getter(getter(ScanFilePath::hash)).setter(setter(Builder::hash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hash").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(ScanFilePath::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD,
            VOLUME_ARN_FIELD, HASH_FIELD, FILE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filePath;

    private final String volumeArn;

    private final String hash;

    private final String fileName;

    private ScanFilePath(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.volumeArn = builder.volumeArn;
        this.hash = builder.hash;
        this.fileName = builder.fileName;
    }

    /**
     * <p>
     * The file path of the infected file.
     * </p>
     * 
     * @return The file path of the infected file.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * EBS volume ARN details of the infected file.
     * </p>
     * 
     * @return EBS volume ARN details of the infected file.
     */
    public final String volumeArn() {
        return volumeArn;
    }

    /**
     * <p>
     * The hash value of the infected file.
     * </p>
     * 
     * @return The hash value of the infected file.
     */
    public final String hash() {
        return hash;
    }

    /**
     * <p>
     * File name of the infected file.
     * </p>
     * 
     * @return File name of the infected file.
     */
    public final String fileName() {
        return fileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(volumeArn());
        hashCode = 31 * hashCode + Objects.hashCode(hash());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanFilePath)) {
            return false;
        }
        ScanFilePath other = (ScanFilePath) obj;
        return Objects.equals(filePath(), other.filePath()) && Objects.equals(volumeArn(), other.volumeArn())
                && Objects.equals(hash(), other.hash()) && Objects.equals(fileName(), other.fileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanFilePath").add("FilePath", filePath()).add("VolumeArn", volumeArn()).add("Hash", hash())
                .add("FileName", fileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "VolumeArn":
            return Optional.ofNullable(clazz.cast(volumeArn()));
        case "Hash":
            return Optional.ofNullable(clazz.cast(hash()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filePath", FILE_PATH_FIELD);
        map.put("volumeArn", VOLUME_ARN_FIELD);
        map.put("hash", HASH_FIELD);
        map.put("fileName", FILE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanFilePath, T> g) {
        return obj -> g.apply((ScanFilePath) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanFilePath> {
        /**
         * <p>
         * The file path of the infected file.
         * </p>
         * 
         * @param filePath
         *        The file path of the infected file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * EBS volume ARN details of the infected file.
         * </p>
         * 
         * @param volumeArn
         *        EBS volume ARN details of the infected file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeArn(String volumeArn);

        /**
         * <p>
         * The hash value of the infected file.
         * </p>
         * 
         * @param hash
         *        The hash value of the infected file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hash(String hash);

        /**
         * <p>
         * File name of the infected file.
         * </p>
         * 
         * @param fileName
         *        File name of the infected file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);
    }

    static final class BuilderImpl implements Builder {
        private String filePath;

        private String volumeArn;

        private String hash;

        private String fileName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanFilePath model) {
            filePath(model.filePath);
            volumeArn(model.volumeArn);
            hash(model.hash);
            fileName(model.fileName);
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getVolumeArn() {
            return volumeArn;
        }

        public final void setVolumeArn(String volumeArn) {
            this.volumeArn = volumeArn;
        }

        @Override
        public final Builder volumeArn(String volumeArn) {
            this.volumeArn = volumeArn;
            return this;
        }

        public final String getHash() {
            return hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Override
        public ScanFilePath build() {
            return new ScanFilePath(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
