/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the S3 object that was scanned
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ObjectDetail implements SdkPojo, Serializable, ToCopyableBuilder<S3ObjectDetail.Builder, S3ObjectDetail> {
    private static final SdkField<String> OBJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectArn").getter(getter(S3ObjectDetail::objectArn)).setter(setter(Builder::objectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectArn").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(S3ObjectDetail::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(S3ObjectDetail::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eTag").build()).build();

    private static final SdkField<String> HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Hash")
            .getter(getter(S3ObjectDetail::hash)).setter(setter(Builder::hash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hash").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(S3ObjectDetail::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_ARN_FIELD, KEY_FIELD,
            E_TAG_FIELD, HASH_FIELD, VERSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String objectArn;

    private final String key;

    private final String eTag;

    private final String hash;

    private final String versionId;

    private S3ObjectDetail(BuilderImpl builder) {
        this.objectArn = builder.objectArn;
        this.key = builder.key;
        this.eTag = builder.eTag;
        this.hash = builder.hash;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the S3 object.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the S3 object.
     */
    public final String objectArn() {
        return objectArn;
    }

    /**
     * <p>
     * Key of the S3 object.
     * </p>
     * 
     * @return Key of the S3 object.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The entity tag is a hash of the S3 object. The ETag reflects changes only to the contents of an object, and not
     * its metadata.
     * </p>
     * 
     * @return The entity tag is a hash of the S3 object. The ETag reflects changes only to the contents of an object,
     *         and not its metadata.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * <p>
     * Hash of the threat detected in this finding.
     * </p>
     * 
     * @return Hash of the threat detected in this finding.
     */
    public final String hash() {
        return hash;
    }

    /**
     * <p>
     * Version ID of the object.
     * </p>
     * 
     * @return Version ID of the object.
     */
    public final String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectArn());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(hash());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ObjectDetail)) {
            return false;
        }
        S3ObjectDetail other = (S3ObjectDetail) obj;
        return Objects.equals(objectArn(), other.objectArn()) && Objects.equals(key(), other.key())
                && Objects.equals(eTag(), other.eTag()) && Objects.equals(hash(), other.hash())
                && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ObjectDetail").add("ObjectArn", objectArn()).add("Key", key()).add("ETag", eTag())
                .add("Hash", hash()).add("VersionId", versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectArn":
            return Optional.ofNullable(clazz.cast(objectArn()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "Hash":
            return Optional.ofNullable(clazz.cast(hash()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("objectArn", OBJECT_ARN_FIELD);
        map.put("key", KEY_FIELD);
        map.put("eTag", E_TAG_FIELD);
        map.put("hash", HASH_FIELD);
        map.put("versionId", VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ObjectDetail, T> g) {
        return obj -> g.apply((S3ObjectDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ObjectDetail> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the S3 object.
         * </p>
         * 
         * @param objectArn
         *        Amazon Resource Name (ARN) of the S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectArn(String objectArn);

        /**
         * <p>
         * Key of the S3 object.
         * </p>
         * 
         * @param key
         *        Key of the S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The entity tag is a hash of the S3 object. The ETag reflects changes only to the contents of an object, and
         * not its metadata.
         * </p>
         * 
         * @param eTag
         *        The entity tag is a hash of the S3 object. The ETag reflects changes only to the contents of an
         *        object, and not its metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * Hash of the threat detected in this finding.
         * </p>
         * 
         * @param hash
         *        Hash of the threat detected in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hash(String hash);

        /**
         * <p>
         * Version ID of the object.
         * </p>
         * 
         * @param versionId
         *        Version ID of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    static final class BuilderImpl implements Builder {
        private String objectArn;

        private String key;

        private String eTag;

        private String hash;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ObjectDetail model) {
            objectArn(model.objectArn);
            key(model.key);
            eTag(model.eTag);
            hash(model.hash);
            versionId(model.versionId);
        }

        public final String getObjectArn() {
            return objectArn;
        }

        public final void setObjectArn(String objectArn) {
            this.objectArn = objectArn;
        }

        @Override
        public final Builder objectArn(String objectArn) {
            this.objectArn = objectArn;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getHash() {
            return hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public S3ObjectDetail build() {
            return new S3ObjectDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
