/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes public access policies that apply to the Amazon S3 bucket.
 * </p>
 * <p>
 * For information about each of the following settings, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html">Blocking public
 * access to your Amazon S3 storage</a> in the <i>Amazon S3 User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicAccessConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PublicAccessConfiguration.Builder, PublicAccessConfiguration> {
    private static final SdkField<String> PUBLIC_ACL_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicAclAccess").getter(getter(PublicAccessConfiguration::publicAclAccessAsString))
            .setter(setter(Builder::publicAclAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAclAccess").build()).build();

    private static final SdkField<String> PUBLIC_POLICY_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicPolicyAccess").getter(getter(PublicAccessConfiguration::publicPolicyAccessAsString))
            .setter(setter(Builder::publicPolicyAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicPolicyAccess").build())
            .build();

    private static final SdkField<String> PUBLIC_ACL_IGNORE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicAclIgnoreBehavior").getter(getter(PublicAccessConfiguration::publicAclIgnoreBehaviorAsString))
            .setter(setter(Builder::publicAclIgnoreBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAclIgnoreBehavior").build())
            .build();

    private static final SdkField<String> PUBLIC_BUCKET_RESTRICT_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicBucketRestrictBehavior")
            .getter(getter(PublicAccessConfiguration::publicBucketRestrictBehaviorAsString))
            .setter(setter(Builder::publicBucketRestrictBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicBucketRestrictBehavior")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_ACL_ACCESS_FIELD,
            PUBLIC_POLICY_ACCESS_FIELD, PUBLIC_ACL_IGNORE_BEHAVIOR_FIELD, PUBLIC_BUCKET_RESTRICT_BEHAVIOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String publicAclAccess;

    private final String publicPolicyAccess;

    private final String publicAclIgnoreBehavior;

    private final String publicBucketRestrictBehavior;

    private PublicAccessConfiguration(BuilderImpl builder) {
        this.publicAclAccess = builder.publicAclAccess;
        this.publicPolicyAccess = builder.publicPolicyAccess;
        this.publicAclIgnoreBehavior = builder.publicAclIgnoreBehavior;
        this.publicBucketRestrictBehavior = builder.publicBucketRestrictBehavior;
    }

    /**
     * <p>
     * Indicates whether or not there is a setting that allows public access to the Amazon S3 buckets through access
     * control lists (ACLs).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publicAclAccess}
     * will return {@link PublicAccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publicAclAccessAsString}.
     * </p>
     * 
     * @return Indicates whether or not there is a setting that allows public access to the Amazon S3 buckets through
     *         access control lists (ACLs).
     * @see PublicAccessStatus
     */
    public final PublicAccessStatus publicAclAccess() {
        return PublicAccessStatus.fromValue(publicAclAccess);
    }

    /**
     * <p>
     * Indicates whether or not there is a setting that allows public access to the Amazon S3 buckets through access
     * control lists (ACLs).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publicAclAccess}
     * will return {@link PublicAccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publicAclAccessAsString}.
     * </p>
     * 
     * @return Indicates whether or not there is a setting that allows public access to the Amazon S3 buckets through
     *         access control lists (ACLs).
     * @see PublicAccessStatus
     */
    public final String publicAclAccessAsString() {
        return publicAclAccess;
    }

    /**
     * <p>
     * Indicates whether or not there is a setting that allows public access to the Amazon S3 bucket policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publicPolicyAccess} will return {@link PublicAccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #publicPolicyAccessAsString}.
     * </p>
     * 
     * @return Indicates whether or not there is a setting that allows public access to the Amazon S3 bucket policy.
     * @see PublicAccessStatus
     */
    public final PublicAccessStatus publicPolicyAccess() {
        return PublicAccessStatus.fromValue(publicPolicyAccess);
    }

    /**
     * <p>
     * Indicates whether or not there is a setting that allows public access to the Amazon S3 bucket policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publicPolicyAccess} will return {@link PublicAccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #publicPolicyAccessAsString}.
     * </p>
     * 
     * @return Indicates whether or not there is a setting that allows public access to the Amazon S3 bucket policy.
     * @see PublicAccessStatus
     */
    public final String publicPolicyAccessAsString() {
        return publicPolicyAccess;
    }

    /**
     * <p>
     * Indicates whether or not there is a setting that ignores all public access control lists (ACLs) on the Amazon S3
     * bucket and the objects that it contains.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publicAclIgnoreBehavior} will return {@link PublicAclIgnoreBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #publicAclIgnoreBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether or not there is a setting that ignores all public access control lists (ACLs) on the
     *         Amazon S3 bucket and the objects that it contains.
     * @see PublicAclIgnoreBehavior
     */
    public final PublicAclIgnoreBehavior publicAclIgnoreBehavior() {
        return PublicAclIgnoreBehavior.fromValue(publicAclIgnoreBehavior);
    }

    /**
     * <p>
     * Indicates whether or not there is a setting that ignores all public access control lists (ACLs) on the Amazon S3
     * bucket and the objects that it contains.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publicAclIgnoreBehavior} will return {@link PublicAclIgnoreBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #publicAclIgnoreBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether or not there is a setting that ignores all public access control lists (ACLs) on the
     *         Amazon S3 bucket and the objects that it contains.
     * @see PublicAclIgnoreBehavior
     */
    public final String publicAclIgnoreBehaviorAsString() {
        return publicAclIgnoreBehavior;
    }

    /**
     * <p>
     * Indicates whether or not there is a setting that restricts access to the bucket with specified policies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publicBucketRestrictBehavior} will return {@link PublicBucketRestrictBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #publicBucketRestrictBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether or not there is a setting that restricts access to the bucket with specified policies.
     * @see PublicBucketRestrictBehavior
     */
    public final PublicBucketRestrictBehavior publicBucketRestrictBehavior() {
        return PublicBucketRestrictBehavior.fromValue(publicBucketRestrictBehavior);
    }

    /**
     * <p>
     * Indicates whether or not there is a setting that restricts access to the bucket with specified policies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publicBucketRestrictBehavior} will return {@link PublicBucketRestrictBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #publicBucketRestrictBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether or not there is a setting that restricts access to the bucket with specified policies.
     * @see PublicBucketRestrictBehavior
     */
    public final String publicBucketRestrictBehaviorAsString() {
        return publicBucketRestrictBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicAclAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publicPolicyAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publicAclIgnoreBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publicBucketRestrictBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicAccessConfiguration)) {
            return false;
        }
        PublicAccessConfiguration other = (PublicAccessConfiguration) obj;
        return Objects.equals(publicAclAccessAsString(), other.publicAclAccessAsString())
                && Objects.equals(publicPolicyAccessAsString(), other.publicPolicyAccessAsString())
                && Objects.equals(publicAclIgnoreBehaviorAsString(), other.publicAclIgnoreBehaviorAsString())
                && Objects.equals(publicBucketRestrictBehaviorAsString(), other.publicBucketRestrictBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicAccessConfiguration").add("PublicAclAccess", publicAclAccessAsString())
                .add("PublicPolicyAccess", publicPolicyAccessAsString())
                .add("PublicAclIgnoreBehavior", publicAclIgnoreBehaviorAsString())
                .add("PublicBucketRestrictBehavior", publicBucketRestrictBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicAclAccess":
            return Optional.ofNullable(clazz.cast(publicAclAccessAsString()));
        case "PublicPolicyAccess":
            return Optional.ofNullable(clazz.cast(publicPolicyAccessAsString()));
        case "PublicAclIgnoreBehavior":
            return Optional.ofNullable(clazz.cast(publicAclIgnoreBehaviorAsString()));
        case "PublicBucketRestrictBehavior":
            return Optional.ofNullable(clazz.cast(publicBucketRestrictBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("publicAclAccess", PUBLIC_ACL_ACCESS_FIELD);
        map.put("publicPolicyAccess", PUBLIC_POLICY_ACCESS_FIELD);
        map.put("publicAclIgnoreBehavior", PUBLIC_ACL_IGNORE_BEHAVIOR_FIELD);
        map.put("publicBucketRestrictBehavior", PUBLIC_BUCKET_RESTRICT_BEHAVIOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublicAccessConfiguration, T> g) {
        return obj -> g.apply((PublicAccessConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicAccessConfiguration> {
        /**
         * <p>
         * Indicates whether or not there is a setting that allows public access to the Amazon S3 buckets through access
         * control lists (ACLs).
         * </p>
         * 
         * @param publicAclAccess
         *        Indicates whether or not there is a setting that allows public access to the Amazon S3 buckets through
         *        access control lists (ACLs).
         * @see PublicAccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublicAccessStatus
         */
        Builder publicAclAccess(String publicAclAccess);

        /**
         * <p>
         * Indicates whether or not there is a setting that allows public access to the Amazon S3 buckets through access
         * control lists (ACLs).
         * </p>
         * 
         * @param publicAclAccess
         *        Indicates whether or not there is a setting that allows public access to the Amazon S3 buckets through
         *        access control lists (ACLs).
         * @see PublicAccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublicAccessStatus
         */
        Builder publicAclAccess(PublicAccessStatus publicAclAccess);

        /**
         * <p>
         * Indicates whether or not there is a setting that allows public access to the Amazon S3 bucket policy.
         * </p>
         * 
         * @param publicPolicyAccess
         *        Indicates whether or not there is a setting that allows public access to the Amazon S3 bucket policy.
         * @see PublicAccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublicAccessStatus
         */
        Builder publicPolicyAccess(String publicPolicyAccess);

        /**
         * <p>
         * Indicates whether or not there is a setting that allows public access to the Amazon S3 bucket policy.
         * </p>
         * 
         * @param publicPolicyAccess
         *        Indicates whether or not there is a setting that allows public access to the Amazon S3 bucket policy.
         * @see PublicAccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublicAccessStatus
         */
        Builder publicPolicyAccess(PublicAccessStatus publicPolicyAccess);

        /**
         * <p>
         * Indicates whether or not there is a setting that ignores all public access control lists (ACLs) on the Amazon
         * S3 bucket and the objects that it contains.
         * </p>
         * 
         * @param publicAclIgnoreBehavior
         *        Indicates whether or not there is a setting that ignores all public access control lists (ACLs) on the
         *        Amazon S3 bucket and the objects that it contains.
         * @see PublicAclIgnoreBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublicAclIgnoreBehavior
         */
        Builder publicAclIgnoreBehavior(String publicAclIgnoreBehavior);

        /**
         * <p>
         * Indicates whether or not there is a setting that ignores all public access control lists (ACLs) on the Amazon
         * S3 bucket and the objects that it contains.
         * </p>
         * 
         * @param publicAclIgnoreBehavior
         *        Indicates whether or not there is a setting that ignores all public access control lists (ACLs) on the
         *        Amazon S3 bucket and the objects that it contains.
         * @see PublicAclIgnoreBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublicAclIgnoreBehavior
         */
        Builder publicAclIgnoreBehavior(PublicAclIgnoreBehavior publicAclIgnoreBehavior);

        /**
         * <p>
         * Indicates whether or not there is a setting that restricts access to the bucket with specified policies.
         * </p>
         * 
         * @param publicBucketRestrictBehavior
         *        Indicates whether or not there is a setting that restricts access to the bucket with specified
         *        policies.
         * @see PublicBucketRestrictBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublicBucketRestrictBehavior
         */
        Builder publicBucketRestrictBehavior(String publicBucketRestrictBehavior);

        /**
         * <p>
         * Indicates whether or not there is a setting that restricts access to the bucket with specified policies.
         * </p>
         * 
         * @param publicBucketRestrictBehavior
         *        Indicates whether or not there is a setting that restricts access to the bucket with specified
         *        policies.
         * @see PublicBucketRestrictBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublicBucketRestrictBehavior
         */
        Builder publicBucketRestrictBehavior(PublicBucketRestrictBehavior publicBucketRestrictBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String publicAclAccess;

        private String publicPolicyAccess;

        private String publicAclIgnoreBehavior;

        private String publicBucketRestrictBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicAccessConfiguration model) {
            publicAclAccess(model.publicAclAccess);
            publicPolicyAccess(model.publicPolicyAccess);
            publicAclIgnoreBehavior(model.publicAclIgnoreBehavior);
            publicBucketRestrictBehavior(model.publicBucketRestrictBehavior);
        }

        public final String getPublicAclAccess() {
            return publicAclAccess;
        }

        public final void setPublicAclAccess(String publicAclAccess) {
            this.publicAclAccess = publicAclAccess;
        }

        @Override
        public final Builder publicAclAccess(String publicAclAccess) {
            this.publicAclAccess = publicAclAccess;
            return this;
        }

        @Override
        public final Builder publicAclAccess(PublicAccessStatus publicAclAccess) {
            this.publicAclAccess(publicAclAccess == null ? null : publicAclAccess.toString());
            return this;
        }

        public final String getPublicPolicyAccess() {
            return publicPolicyAccess;
        }

        public final void setPublicPolicyAccess(String publicPolicyAccess) {
            this.publicPolicyAccess = publicPolicyAccess;
        }

        @Override
        public final Builder publicPolicyAccess(String publicPolicyAccess) {
            this.publicPolicyAccess = publicPolicyAccess;
            return this;
        }

        @Override
        public final Builder publicPolicyAccess(PublicAccessStatus publicPolicyAccess) {
            this.publicPolicyAccess(publicPolicyAccess == null ? null : publicPolicyAccess.toString());
            return this;
        }

        public final String getPublicAclIgnoreBehavior() {
            return publicAclIgnoreBehavior;
        }

        public final void setPublicAclIgnoreBehavior(String publicAclIgnoreBehavior) {
            this.publicAclIgnoreBehavior = publicAclIgnoreBehavior;
        }

        @Override
        public final Builder publicAclIgnoreBehavior(String publicAclIgnoreBehavior) {
            this.publicAclIgnoreBehavior = publicAclIgnoreBehavior;
            return this;
        }

        @Override
        public final Builder publicAclIgnoreBehavior(PublicAclIgnoreBehavior publicAclIgnoreBehavior) {
            this.publicAclIgnoreBehavior(publicAclIgnoreBehavior == null ? null : publicAclIgnoreBehavior.toString());
            return this;
        }

        public final String getPublicBucketRestrictBehavior() {
            return publicBucketRestrictBehavior;
        }

        public final void setPublicBucketRestrictBehavior(String publicBucketRestrictBehavior) {
            this.publicBucketRestrictBehavior = publicBucketRestrictBehavior;
        }

        @Override
        public final Builder publicBucketRestrictBehavior(String publicBucketRestrictBehavior) {
            this.publicBucketRestrictBehavior = publicBucketRestrictBehavior;
            return this;
        }

        @Override
        public final Builder publicBucketRestrictBehavior(PublicBucketRestrictBehavior publicBucketRestrictBehavior) {
            this.publicBucketRestrictBehavior(publicBucketRestrictBehavior == null ? null : publicBucketRestrictBehavior
                    .toString());
            return this;
        }

        @Override
        public PublicAccessConfiguration build() {
            return new PublicAccessConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
