/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the PORT_PROBE action described in the finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortProbeAction implements SdkPojo, Serializable, ToCopyableBuilder<PortProbeAction.Builder, PortProbeAction> {
    private static final SdkField<Boolean> BLOCKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Blocked").getter(getter(PortProbeAction::blocked)).setter(setter(Builder::blocked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocked").build()).build();

    private static final SdkField<List<PortProbeDetail>> PORT_PROBE_DETAILS_FIELD = SdkField
            .<List<PortProbeDetail>> builder(MarshallingType.LIST)
            .memberName("PortProbeDetails")
            .getter(getter(PortProbeAction::portProbeDetails))
            .setter(setter(Builder::portProbeDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portProbeDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortProbeDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortProbeDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_FIELD,
            PORT_PROBE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean blocked;

    private final List<PortProbeDetail> portProbeDetails;

    private PortProbeAction(BuilderImpl builder) {
        this.blocked = builder.blocked;
        this.portProbeDetails = builder.portProbeDetails;
    }

    /**
     * <p>
     * Indicates whether EC2 blocked the port probe to the instance, such as with an ACL.
     * </p>
     * 
     * @return Indicates whether EC2 blocked the port probe to the instance, such as with an ACL.
     */
    public final Boolean blocked() {
        return blocked;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortProbeDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPortProbeDetails() {
        return portProbeDetails != null && !(portProbeDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects related to port probe details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortProbeDetails} method.
     * </p>
     * 
     * @return A list of objects related to port probe details.
     */
    public final List<PortProbeDetail> portProbeDetails() {
        return portProbeDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blocked());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortProbeDetails() ? portProbeDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortProbeAction)) {
            return false;
        }
        PortProbeAction other = (PortProbeAction) obj;
        return Objects.equals(blocked(), other.blocked()) && hasPortProbeDetails() == other.hasPortProbeDetails()
                && Objects.equals(portProbeDetails(), other.portProbeDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortProbeAction").add("Blocked", blocked())
                .add("PortProbeDetails", hasPortProbeDetails() ? portProbeDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Blocked":
            return Optional.ofNullable(clazz.cast(blocked()));
        case "PortProbeDetails":
            return Optional.ofNullable(clazz.cast(portProbeDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blocked", BLOCKED_FIELD);
        map.put("portProbeDetails", PORT_PROBE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PortProbeAction, T> g) {
        return obj -> g.apply((PortProbeAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortProbeAction> {
        /**
         * <p>
         * Indicates whether EC2 blocked the port probe to the instance, such as with an ACL.
         * </p>
         * 
         * @param blocked
         *        Indicates whether EC2 blocked the port probe to the instance, such as with an ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocked(Boolean blocked);

        /**
         * <p>
         * A list of objects related to port probe details.
         * </p>
         * 
         * @param portProbeDetails
         *        A list of objects related to port probe details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portProbeDetails(Collection<PortProbeDetail> portProbeDetails);

        /**
         * <p>
         * A list of objects related to port probe details.
         * </p>
         * 
         * @param portProbeDetails
         *        A list of objects related to port probe details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portProbeDetails(PortProbeDetail... portProbeDetails);

        /**
         * <p>
         * A list of objects related to port probe details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.PortProbeDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.guardduty.model.PortProbeDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.PortProbeDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #portProbeDetails(List<PortProbeDetail>)}.
         * 
         * @param portProbeDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.PortProbeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portProbeDetails(java.util.Collection<PortProbeDetail>)
         */
        Builder portProbeDetails(Consumer<PortProbeDetail.Builder>... portProbeDetails);
    }

    static final class BuilderImpl implements Builder {
        private Boolean blocked;

        private List<PortProbeDetail> portProbeDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PortProbeAction model) {
            blocked(model.blocked);
            portProbeDetails(model.portProbeDetails);
        }

        public final Boolean getBlocked() {
            return blocked;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public final List<PortProbeDetail.Builder> getPortProbeDetails() {
            List<PortProbeDetail.Builder> result = PortProbeDetailsCopier.copyToBuilder(this.portProbeDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortProbeDetails(Collection<PortProbeDetail.BuilderImpl> portProbeDetails) {
            this.portProbeDetails = PortProbeDetailsCopier.copyFromBuilder(portProbeDetails);
        }

        @Override
        public final Builder portProbeDetails(Collection<PortProbeDetail> portProbeDetails) {
            this.portProbeDetails = PortProbeDetailsCopier.copy(portProbeDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portProbeDetails(PortProbeDetail... portProbeDetails) {
            portProbeDetails(Arrays.asList(portProbeDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portProbeDetails(Consumer<PortProbeDetail.Builder>... portProbeDetails) {
            portProbeDetails(Stream.of(portProbeDetails).map(c -> PortProbeDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PortProbeAction build() {
            return new PortProbeAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
