/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about how permissions are configured for the S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PermissionConfiguration.Builder, PermissionConfiguration> {
    private static final SdkField<BucketLevelPermissions> BUCKET_LEVEL_PERMISSIONS_FIELD = SdkField
            .<BucketLevelPermissions> builder(MarshallingType.SDK_POJO).memberName("BucketLevelPermissions")
            .getter(getter(PermissionConfiguration::bucketLevelPermissions)).setter(setter(Builder::bucketLevelPermissions))
            .constructor(BucketLevelPermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketLevelPermissions").build())
            .build();

    private static final SdkField<AccountLevelPermissions> ACCOUNT_LEVEL_PERMISSIONS_FIELD = SdkField
            .<AccountLevelPermissions> builder(MarshallingType.SDK_POJO).memberName("AccountLevelPermissions")
            .getter(getter(PermissionConfiguration::accountLevelPermissions)).setter(setter(Builder::accountLevelPermissions))
            .constructor(AccountLevelPermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountLevelPermissions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BUCKET_LEVEL_PERMISSIONS_FIELD, ACCOUNT_LEVEL_PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BucketLevelPermissions bucketLevelPermissions;

    private final AccountLevelPermissions accountLevelPermissions;

    private PermissionConfiguration(BuilderImpl builder) {
        this.bucketLevelPermissions = builder.bucketLevelPermissions;
        this.accountLevelPermissions = builder.accountLevelPermissions;
    }

    /**
     * <p>
     * Contains information about the bucket level permissions for the S3 bucket.
     * </p>
     * 
     * @return Contains information about the bucket level permissions for the S3 bucket.
     */
    public final BucketLevelPermissions bucketLevelPermissions() {
        return bucketLevelPermissions;
    }

    /**
     * <p>
     * Contains information about the account level permissions on the S3 bucket.
     * </p>
     * 
     * @return Contains information about the account level permissions on the S3 bucket.
     */
    public final AccountLevelPermissions accountLevelPermissions() {
        return accountLevelPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketLevelPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(accountLevelPermissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionConfiguration)) {
            return false;
        }
        PermissionConfiguration other = (PermissionConfiguration) obj;
        return Objects.equals(bucketLevelPermissions(), other.bucketLevelPermissions())
                && Objects.equals(accountLevelPermissions(), other.accountLevelPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PermissionConfiguration").add("BucketLevelPermissions", bucketLevelPermissions())
                .add("AccountLevelPermissions", accountLevelPermissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketLevelPermissions":
            return Optional.ofNullable(clazz.cast(bucketLevelPermissions()));
        case "AccountLevelPermissions":
            return Optional.ofNullable(clazz.cast(accountLevelPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bucketLevelPermissions", BUCKET_LEVEL_PERMISSIONS_FIELD);
        map.put("accountLevelPermissions", ACCOUNT_LEVEL_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PermissionConfiguration, T> g) {
        return obj -> g.apply((PermissionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionConfiguration> {
        /**
         * <p>
         * Contains information about the bucket level permissions for the S3 bucket.
         * </p>
         * 
         * @param bucketLevelPermissions
         *        Contains information about the bucket level permissions for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketLevelPermissions(BucketLevelPermissions bucketLevelPermissions);

        /**
         * <p>
         * Contains information about the bucket level permissions for the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketLevelPermissions.Builder} avoiding
         * the need to create one manually via {@link BucketLevelPermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BucketLevelPermissions.Builder#build()} is called immediately and
         * its result is passed to {@link #bucketLevelPermissions(BucketLevelPermissions)}.
         * 
         * @param bucketLevelPermissions
         *        a consumer that will call methods on {@link BucketLevelPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketLevelPermissions(BucketLevelPermissions)
         */
        default Builder bucketLevelPermissions(Consumer<BucketLevelPermissions.Builder> bucketLevelPermissions) {
            return bucketLevelPermissions(BucketLevelPermissions.builder().applyMutation(bucketLevelPermissions).build());
        }

        /**
         * <p>
         * Contains information about the account level permissions on the S3 bucket.
         * </p>
         * 
         * @param accountLevelPermissions
         *        Contains information about the account level permissions on the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLevelPermissions(AccountLevelPermissions accountLevelPermissions);

        /**
         * <p>
         * Contains information about the account level permissions on the S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountLevelPermissions.Builder} avoiding
         * the need to create one manually via {@link AccountLevelPermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountLevelPermissions.Builder#build()} is called immediately
         * and its result is passed to {@link #accountLevelPermissions(AccountLevelPermissions)}.
         * 
         * @param accountLevelPermissions
         *        a consumer that will call methods on {@link AccountLevelPermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountLevelPermissions(AccountLevelPermissions)
         */
        default Builder accountLevelPermissions(Consumer<AccountLevelPermissions.Builder> accountLevelPermissions) {
            return accountLevelPermissions(AccountLevelPermissions.builder().applyMutation(accountLevelPermissions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BucketLevelPermissions bucketLevelPermissions;

        private AccountLevelPermissions accountLevelPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionConfiguration model) {
            bucketLevelPermissions(model.bucketLevelPermissions);
            accountLevelPermissions(model.accountLevelPermissions);
        }

        public final BucketLevelPermissions.Builder getBucketLevelPermissions() {
            return bucketLevelPermissions != null ? bucketLevelPermissions.toBuilder() : null;
        }

        public final void setBucketLevelPermissions(BucketLevelPermissions.BuilderImpl bucketLevelPermissions) {
            this.bucketLevelPermissions = bucketLevelPermissions != null ? bucketLevelPermissions.build() : null;
        }

        @Override
        public final Builder bucketLevelPermissions(BucketLevelPermissions bucketLevelPermissions) {
            this.bucketLevelPermissions = bucketLevelPermissions;
            return this;
        }

        public final AccountLevelPermissions.Builder getAccountLevelPermissions() {
            return accountLevelPermissions != null ? accountLevelPermissions.toBuilder() : null;
        }

        public final void setAccountLevelPermissions(AccountLevelPermissions.BuilderImpl accountLevelPermissions) {
            this.accountLevelPermissions = accountLevelPermissions != null ? accountLevelPermissions.build() : null;
        }

        @Override
        public final Builder accountLevelPermissions(AccountLevelPermissions accountLevelPermissions) {
            this.accountLevelPermissions = accountLevelPermissions;
            return this;
        }

        @Override
        public PermissionConfiguration build() {
            return new PermissionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
