/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about GuardDuty coverage statistics for members in your Amazon Web Services organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationDetails.Builder, OrganizationDetails> {
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(OrganizationDetails::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<OrganizationStatistics> ORGANIZATION_STATISTICS_FIELD = SdkField
            .<OrganizationStatistics> builder(MarshallingType.SDK_POJO).memberName("OrganizationStatistics")
            .getter(getter(OrganizationDetails::organizationStatistics)).setter(setter(Builder::organizationStatistics))
            .constructor(OrganizationStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationStatistics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATED_AT_FIELD,
            ORGANIZATION_STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant updatedAt;

    private final OrganizationStatistics organizationStatistics;

    private OrganizationDetails(BuilderImpl builder) {
        this.updatedAt = builder.updatedAt;
        this.organizationStatistics = builder.organizationStatistics;
    }

    /**
     * <p>
     * The timestamp at which the organization statistics was last updated. This is in UTC format.
     * </p>
     * 
     * @return The timestamp at which the organization statistics was last updated. This is in UTC format.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Information about the GuardDuty coverage statistics for members in your Amazon Web Services organization.
     * </p>
     * 
     * @return Information about the GuardDuty coverage statistics for members in your Amazon Web Services organization.
     */
    public final OrganizationStatistics organizationStatistics() {
        return organizationStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(organizationStatistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationDetails)) {
            return false;
        }
        OrganizationDetails other = (OrganizationDetails) obj;
        return Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(organizationStatistics(), other.organizationStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationDetails").add("UpdatedAt", updatedAt())
                .add("OrganizationStatistics", organizationStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "OrganizationStatistics":
            return Optional.ofNullable(clazz.cast(organizationStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("organizationStatistics", ORGANIZATION_STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationDetails, T> g) {
        return obj -> g.apply((OrganizationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationDetails> {
        /**
         * <p>
         * The timestamp at which the organization statistics was last updated. This is in UTC format.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp at which the organization statistics was last updated. This is in UTC format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Information about the GuardDuty coverage statistics for members in your Amazon Web Services organization.
         * </p>
         * 
         * @param organizationStatistics
         *        Information about the GuardDuty coverage statistics for members in your Amazon Web Services
         *        organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationStatistics(OrganizationStatistics organizationStatistics);

        /**
         * <p>
         * Information about the GuardDuty coverage statistics for members in your Amazon Web Services organization.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationStatistics.Builder} avoiding
         * the need to create one manually via {@link OrganizationStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #organizationStatistics(OrganizationStatistics)}.
         * 
         * @param organizationStatistics
         *        a consumer that will call methods on {@link OrganizationStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationStatistics(OrganizationStatistics)
         */
        default Builder organizationStatistics(Consumer<OrganizationStatistics.Builder> organizationStatistics) {
            return organizationStatistics(OrganizationStatistics.builder().applyMutation(organizationStatistics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant updatedAt;

        private OrganizationStatistics organizationStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationDetails model) {
            updatedAt(model.updatedAt);
            organizationStatistics(model.organizationStatistics);
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final OrganizationStatistics.Builder getOrganizationStatistics() {
            return organizationStatistics != null ? organizationStatistics.toBuilder() : null;
        }

        public final void setOrganizationStatistics(OrganizationStatistics.BuilderImpl organizationStatistics) {
            this.organizationStatistics = organizationStatistics != null ? organizationStatistics.build() : null;
        }

        @Override
        public final Builder organizationStatistics(OrganizationStatistics organizationStatistics) {
            this.organizationStatistics = organizationStatistics;
            return this;
        }

        @Override
        public OrganizationDetails build() {
            return new OrganizationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
