/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of additional configurations which will be configured for the organization.
 * </p>
 * <p>
 * Additional configuration applies to only GuardDuty Runtime Monitoring protection plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrganizationAdditionalConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OrganizationAdditionalConfiguration.Builder, OrganizationAdditionalConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OrganizationAdditionalConfiguration::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> AUTO_ENABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoEnable").getter(getter(OrganizationAdditionalConfiguration::autoEnableAsString))
            .setter(setter(Builder::autoEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NAME_FIELD, AUTO_ENABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String autoEnable;

    private OrganizationAdditionalConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.autoEnable = builder.autoEnable;
    }

    /**
     * <p>
     * The name of the additional configuration that will be configured for the organization. These values are
     * applicable to only Runtime Monitoring protection plan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OrgFeatureAdditionalConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the additional configuration that will be configured for the organization. These values are
     *         applicable to only Runtime Monitoring protection plan.
     * @see OrgFeatureAdditionalConfiguration
     */
    public final OrgFeatureAdditionalConfiguration name() {
        return OrgFeatureAdditionalConfiguration.fromValue(name);
    }

    /**
     * <p>
     * The name of the additional configuration that will be configured for the organization. These values are
     * applicable to only Runtime Monitoring protection plan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OrgFeatureAdditionalConfiguration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the additional configuration that will be configured for the organization. These values are
     *         applicable to only Runtime Monitoring protection plan.
     * @see OrgFeatureAdditionalConfiguration
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The status of the additional configuration that will be configured for the organization. Use one of the following
     * values to configure the feature status for the entire organization:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW</code>: Indicates that when a new account joins the organization, they will have the additional
     * configuration enabled automatically.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>: Indicates that all accounts in the organization have the additional configuration enabled
     * automatically. This includes <code>NEW</code> accounts that join the organization and accounts that may have been
     * suspended or removed from the organization in GuardDuty.
     * </p>
     * <p>
     * It may take up to 24 hours to update the configuration for all the member accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: Indicates that the additional configuration will not be automatically enabled for any account
     * in the organization. The administrator must manage the additional configuration for each account individually.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoEnable} will
     * return {@link OrgFeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoEnableAsString}.
     * </p>
     * 
     * @return The status of the additional configuration that will be configured for the organization. Use one of the
     *         following values to configure the feature status for the entire organization:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW</code>: Indicates that when a new account joins the organization, they will have the additional
     *         configuration enabled automatically.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>: Indicates that all accounts in the organization have the additional configuration
     *         enabled automatically. This includes <code>NEW</code> accounts that join the organization and accounts
     *         that may have been suspended or removed from the organization in GuardDuty.
     *         </p>
     *         <p>
     *         It may take up to 24 hours to update the configuration for all the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Indicates that the additional configuration will not be automatically enabled for any
     *         account in the organization. The administrator must manage the additional configuration for each account
     *         individually.
     *         </p>
     *         </li>
     * @see OrgFeatureStatus
     */
    public final OrgFeatureStatus autoEnable() {
        return OrgFeatureStatus.fromValue(autoEnable);
    }

    /**
     * <p>
     * The status of the additional configuration that will be configured for the organization. Use one of the following
     * values to configure the feature status for the entire organization:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NEW</code>: Indicates that when a new account joins the organization, they will have the additional
     * configuration enabled automatically.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>: Indicates that all accounts in the organization have the additional configuration enabled
     * automatically. This includes <code>NEW</code> accounts that join the organization and accounts that may have been
     * suspended or removed from the organization in GuardDuty.
     * </p>
     * <p>
     * It may take up to 24 hours to update the configuration for all the member accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code>: Indicates that the additional configuration will not be automatically enabled for any account
     * in the organization. The administrator must manage the additional configuration for each account individually.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoEnable} will
     * return {@link OrgFeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoEnableAsString}.
     * </p>
     * 
     * @return The status of the additional configuration that will be configured for the organization. Use one of the
     *         following values to configure the feature status for the entire organization:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NEW</code>: Indicates that when a new account joins the organization, they will have the additional
     *         configuration enabled automatically.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>: Indicates that all accounts in the organization have the additional configuration
     *         enabled automatically. This includes <code>NEW</code> accounts that join the organization and accounts
     *         that may have been suspended or removed from the organization in GuardDuty.
     *         </p>
     *         <p>
     *         It may take up to 24 hours to update the configuration for all the member accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Indicates that the additional configuration will not be automatically enabled for any
     *         account in the organization. The administrator must manage the additional configuration for each account
     *         individually.
     *         </p>
     *         </li>
     * @see OrgFeatureStatus
     */
    public final String autoEnableAsString() {
        return autoEnable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationAdditionalConfiguration)) {
            return false;
        }
        OrganizationAdditionalConfiguration other = (OrganizationAdditionalConfiguration) obj;
        return Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(autoEnableAsString(), other.autoEnableAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrganizationAdditionalConfiguration").add("Name", nameAsString())
                .add("AutoEnable", autoEnableAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "AutoEnable":
            return Optional.ofNullable(clazz.cast(autoEnableAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("autoEnable", AUTO_ENABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrganizationAdditionalConfiguration, T> g) {
        return obj -> g.apply((OrganizationAdditionalConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrganizationAdditionalConfiguration> {
        /**
         * <p>
         * The name of the additional configuration that will be configured for the organization. These values are
         * applicable to only Runtime Monitoring protection plan.
         * </p>
         * 
         * @param name
         *        The name of the additional configuration that will be configured for the organization. These values
         *        are applicable to only Runtime Monitoring protection plan.
         * @see OrgFeatureAdditionalConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeatureAdditionalConfiguration
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the additional configuration that will be configured for the organization. These values are
         * applicable to only Runtime Monitoring protection plan.
         * </p>
         * 
         * @param name
         *        The name of the additional configuration that will be configured for the organization. These values
         *        are applicable to only Runtime Monitoring protection plan.
         * @see OrgFeatureAdditionalConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeatureAdditionalConfiguration
         */
        Builder name(OrgFeatureAdditionalConfiguration name);

        /**
         * <p>
         * The status of the additional configuration that will be configured for the organization. Use one of the
         * following values to configure the feature status for the entire organization:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code>: Indicates that when a new account joins the organization, they will have the additional
         * configuration enabled automatically.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>: Indicates that all accounts in the organization have the additional configuration enabled
         * automatically. This includes <code>NEW</code> accounts that join the organization and accounts that may have
         * been suspended or removed from the organization in GuardDuty.
         * </p>
         * <p>
         * It may take up to 24 hours to update the configuration for all the member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: Indicates that the additional configuration will not be automatically enabled for any
         * account in the organization. The administrator must manage the additional configuration for each account
         * individually.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoEnable
         *        The status of the additional configuration that will be configured for the organization. Use one of
         *        the following values to configure the feature status for the entire organization:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code>: Indicates that when a new account joins the organization, they will have the
         *        additional configuration enabled automatically.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>: Indicates that all accounts in the organization have the additional configuration
         *        enabled automatically. This includes <code>NEW</code> accounts that join the organization and accounts
         *        that may have been suspended or removed from the organization in GuardDuty.
         *        </p>
         *        <p>
         *        It may take up to 24 hours to update the configuration for all the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Indicates that the additional configuration will not be automatically enabled for
         *        any account in the organization. The administrator must manage the additional configuration for each
         *        account individually.
         *        </p>
         *        </li>
         * @see OrgFeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeatureStatus
         */
        Builder autoEnable(String autoEnable);

        /**
         * <p>
         * The status of the additional configuration that will be configured for the organization. Use one of the
         * following values to configure the feature status for the entire organization:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NEW</code>: Indicates that when a new account joins the organization, they will have the additional
         * configuration enabled automatically.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>: Indicates that all accounts in the organization have the additional configuration enabled
         * automatically. This includes <code>NEW</code> accounts that join the organization and accounts that may have
         * been suspended or removed from the organization in GuardDuty.
         * </p>
         * <p>
         * It may take up to 24 hours to update the configuration for all the member accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code>: Indicates that the additional configuration will not be automatically enabled for any
         * account in the organization. The administrator must manage the additional configuration for each account
         * individually.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoEnable
         *        The status of the additional configuration that will be configured for the organization. Use one of
         *        the following values to configure the feature status for the entire organization:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NEW</code>: Indicates that when a new account joins the organization, they will have the
         *        additional configuration enabled automatically.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>: Indicates that all accounts in the organization have the additional configuration
         *        enabled automatically. This includes <code>NEW</code> accounts that join the organization and accounts
         *        that may have been suspended or removed from the organization in GuardDuty.
         *        </p>
         *        <p>
         *        It may take up to 24 hours to update the configuration for all the member accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Indicates that the additional configuration will not be automatically enabled for
         *        any account in the organization. The administrator must manage the additional configuration for each
         *        account individually.
         *        </p>
         *        </li>
         * @see OrgFeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrgFeatureStatus
         */
        Builder autoEnable(OrgFeatureStatus autoEnable);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String autoEnable;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationAdditionalConfiguration model) {
            name(model.name);
            autoEnable(model.autoEnable);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(OrgFeatureAdditionalConfiguration name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getAutoEnable() {
            return autoEnable;
        }

        public final void setAutoEnable(String autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        public final Builder autoEnable(String autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        @Override
        public final Builder autoEnable(OrgFeatureStatus autoEnable) {
            this.autoEnable(autoEnable == null ? null : autoEnable.toString());
            return this;
        }

        @Override
        public OrganizationAdditionalConfiguration build() {
            return new OrganizationAdditionalConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
