/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about network endpoints that were observed in the attack sequence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<NetworkEndpoint.Builder, NetworkEndpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(NetworkEndpoint::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ip")
            .getter(getter(NetworkEndpoint::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ip").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(NetworkEndpoint::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(NetworkEndpoint::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<NetworkGeoLocation> LOCATION_FIELD = SdkField
            .<NetworkGeoLocation> builder(MarshallingType.SDK_POJO).memberName("Location")
            .getter(getter(NetworkEndpoint::location)).setter(setter(Builder::location)).constructor(NetworkGeoLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<AutonomousSystem> AUTONOMOUS_SYSTEM_FIELD = SdkField
            .<AutonomousSystem> builder(MarshallingType.SDK_POJO).memberName("AutonomousSystem")
            .getter(getter(NetworkEndpoint::autonomousSystem)).setter(setter(Builder::autonomousSystem))
            .constructor(AutonomousSystem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousSystem").build()).build();

    private static final SdkField<NetworkConnection> CONNECTION_FIELD = SdkField
            .<NetworkConnection> builder(MarshallingType.SDK_POJO).memberName("Connection")
            .getter(getter(NetworkEndpoint::connection)).setter(setter(Builder::connection))
            .constructor(NetworkConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IP_FIELD,
            DOMAIN_FIELD, PORT_FIELD, LOCATION_FIELD, AUTONOMOUS_SYSTEM_FIELD, CONNECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String ip;

    private final String domain;

    private final Integer port;

    private final NetworkGeoLocation location;

    private final AutonomousSystem autonomousSystem;

    private final NetworkConnection connection;

    private NetworkEndpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.ip = builder.ip;
        this.domain = builder.domain;
        this.port = builder.port;
        this.location = builder.location;
        this.autonomousSystem = builder.autonomousSystem;
        this.connection = builder.connection;
    }

    /**
     * <p>
     * The ID of the network endpoint.
     * </p>
     * 
     * @return The ID of the network endpoint.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The IP address associated with the network endpoint.
     * </p>
     * 
     * @return The IP address associated with the network endpoint.
     */
    public final String ip() {
        return ip;
    }

    /**
     * <p>
     * The domain information for the network endpoint.
     * </p>
     * 
     * @return The domain information for the network endpoint.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The port number associated with the network endpoint.
     * </p>
     * 
     * @return The port number associated with the network endpoint.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Information about the location of the network endpoint.
     * </p>
     * 
     * @return Information about the location of the network endpoint.
     */
    public final NetworkGeoLocation location() {
        return location;
    }

    /**
     * <p>
     * The Autonomous System (AS) of the network endpoint.
     * </p>
     * 
     * @return The Autonomous System (AS) of the network endpoint.
     */
    public final AutonomousSystem autonomousSystem() {
        return autonomousSystem;
    }

    /**
     * <p>
     * Information about the network connection.
     * </p>
     * 
     * @return Information about the network connection.
     */
    public final NetworkConnection connection() {
        return connection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(autonomousSystem());
        hashCode = 31 * hashCode + Objects.hashCode(connection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkEndpoint)) {
            return false;
        }
        NetworkEndpoint other = (NetworkEndpoint) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(ip(), other.ip()) && Objects.equals(domain(), other.domain())
                && Objects.equals(port(), other.port()) && Objects.equals(location(), other.location())
                && Objects.equals(autonomousSystem(), other.autonomousSystem())
                && Objects.equals(connection(), other.connection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkEndpoint").add("Id", id()).add("Ip", ip()).add("Domain", domain()).add("Port", port())
                .add("Location", location()).add("AutonomousSystem", autonomousSystem()).add("Connection", connection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "AutonomousSystem":
            return Optional.ofNullable(clazz.cast(autonomousSystem()));
        case "Connection":
            return Optional.ofNullable(clazz.cast(connection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("ip", IP_FIELD);
        map.put("domain", DOMAIN_FIELD);
        map.put("port", PORT_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("autonomousSystem", AUTONOMOUS_SYSTEM_FIELD);
        map.put("connection", CONNECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkEndpoint, T> g) {
        return obj -> g.apply((NetworkEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkEndpoint> {
        /**
         * <p>
         * The ID of the network endpoint.
         * </p>
         * 
         * @param id
         *        The ID of the network endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The IP address associated with the network endpoint.
         * </p>
         * 
         * @param ip
         *        The IP address associated with the network endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * <p>
         * The domain information for the network endpoint.
         * </p>
         * 
         * @param domain
         *        The domain information for the network endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The port number associated with the network endpoint.
         * </p>
         * 
         * @param port
         *        The port number associated with the network endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Information about the location of the network endpoint.
         * </p>
         * 
         * @param location
         *        Information about the location of the network endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(NetworkGeoLocation location);

        /**
         * <p>
         * Information about the location of the network endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkGeoLocation.Builder} avoiding the
         * need to create one manually via {@link NetworkGeoLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkGeoLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(NetworkGeoLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link NetworkGeoLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(NetworkGeoLocation)
         */
        default Builder location(Consumer<NetworkGeoLocation.Builder> location) {
            return location(NetworkGeoLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The Autonomous System (AS) of the network endpoint.
         * </p>
         * 
         * @param autonomousSystem
         *        The Autonomous System (AS) of the network endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autonomousSystem(AutonomousSystem autonomousSystem);

        /**
         * <p>
         * The Autonomous System (AS) of the network endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutonomousSystem.Builder} avoiding the
         * need to create one manually via {@link AutonomousSystem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutonomousSystem.Builder#build()} is called immediately and its
         * result is passed to {@link #autonomousSystem(AutonomousSystem)}.
         * 
         * @param autonomousSystem
         *        a consumer that will call methods on {@link AutonomousSystem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autonomousSystem(AutonomousSystem)
         */
        default Builder autonomousSystem(Consumer<AutonomousSystem.Builder> autonomousSystem) {
            return autonomousSystem(AutonomousSystem.builder().applyMutation(autonomousSystem).build());
        }

        /**
         * <p>
         * Information about the network connection.
         * </p>
         * 
         * @param connection
         *        Information about the network connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connection(NetworkConnection connection);

        /**
         * <p>
         * Information about the network connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConnection.Builder} avoiding the
         * need to create one manually via {@link NetworkConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConnection.Builder#build()} is called immediately and its
         * result is passed to {@link #connection(NetworkConnection)}.
         * 
         * @param connection
         *        a consumer that will call methods on {@link NetworkConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connection(NetworkConnection)
         */
        default Builder connection(Consumer<NetworkConnection.Builder> connection) {
            return connection(NetworkConnection.builder().applyMutation(connection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String ip;

        private String domain;

        private Integer port;

        private NetworkGeoLocation location;

        private AutonomousSystem autonomousSystem;

        private NetworkConnection connection;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkEndpoint model) {
            id(model.id);
            ip(model.ip);
            domain(model.domain);
            port(model.port);
            location(model.location);
            autonomousSystem(model.autonomousSystem);
            connection(model.connection);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIp() {
            return ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final NetworkGeoLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(NetworkGeoLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(NetworkGeoLocation location) {
            this.location = location;
            return this;
        }

        public final AutonomousSystem.Builder getAutonomousSystem() {
            return autonomousSystem != null ? autonomousSystem.toBuilder() : null;
        }

        public final void setAutonomousSystem(AutonomousSystem.BuilderImpl autonomousSystem) {
            this.autonomousSystem = autonomousSystem != null ? autonomousSystem.build() : null;
        }

        @Override
        public final Builder autonomousSystem(AutonomousSystem autonomousSystem) {
            this.autonomousSystem = autonomousSystem;
            return this;
        }

        public final NetworkConnection.Builder getConnection() {
            return connection != null ? connection.toBuilder() : null;
        }

        public final void setConnection(NetworkConnection.BuilderImpl connection) {
            this.connection = connection != null ? connection.build() : null;
        }

        @Override
        public final Builder connection(NetworkConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public NetworkEndpoint build() {
            return new NetworkEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
