/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on which data sources are enabled for a member account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberDataSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberDataSourceConfiguration.Builder, MemberDataSourceConfiguration> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(MemberDataSourceConfiguration::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<DataSourceConfigurationsResult> DATA_SOURCES_FIELD = SdkField
            .<DataSourceConfigurationsResult> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(MemberDataSourceConfiguration::dataSources)).setter(setter(Builder::dataSources))
            .constructor(DataSourceConfigurationsResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final SdkField<List<MemberFeaturesConfigurationResult>> FEATURES_FIELD = SdkField
            .<List<MemberFeaturesConfigurationResult>> builder(MarshallingType.LIST)
            .memberName("Features")
            .getter(getter(MemberDataSourceConfiguration::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberFeaturesConfigurationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberFeaturesConfigurationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            DATA_SOURCES_FIELD, FEATURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final DataSourceConfigurationsResult dataSources;

    private final List<MemberFeaturesConfigurationResult> features;

    private MemberDataSourceConfiguration(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.dataSources = builder.dataSources;
        this.features = builder.features;
    }

    /**
     * <p>
     * The account ID for the member account.
     * </p>
     * 
     * @return The account ID for the member account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Contains information on the status of data sources for the account.
     * </p>
     * 
     * @return Contains information on the status of data sources for the account.
     * @deprecated This parameter is deprecated, use Features instead
     */
    @Deprecated
    public final DataSourceConfigurationsResult dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the status of the features for the member account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return Contains information about the status of the features for the member account.
     */
    public final List<MemberFeaturesConfigurationResult> features() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberDataSourceConfiguration)) {
            return false;
        }
        MemberDataSourceConfiguration other = (MemberDataSourceConfiguration) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(dataSources(), other.dataSources())
                && hasFeatures() == other.hasFeatures() && Objects.equals(features(), other.features());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberDataSourceConfiguration").add("AccountId", accountId()).add("DataSources", dataSources())
                .add("Features", hasFeatures() ? features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Features":
            return Optional.ofNullable(clazz.cast(features()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("features", FEATURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemberDataSourceConfiguration, T> g) {
        return obj -> g.apply((MemberDataSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberDataSourceConfiguration> {
        /**
         * <p>
         * The account ID for the member account.
         * </p>
         * 
         * @param accountId
         *        The account ID for the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Contains information on the status of data sources for the account.
         * </p>
         * 
         * @param dataSources
         *        Contains information on the status of data sources for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSources(DataSourceConfigurationsResult dataSources);

        /**
         * <p>
         * Contains information on the status of data sources for the account.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfigurationsResult.Builder}
         * avoiding the need to create one manually via {@link DataSourceConfigurationsResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfigurationsResult.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSources(DataSourceConfigurationsResult)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link DataSourceConfigurationsResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(DataSourceConfigurationsResult)
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        default Builder dataSources(Consumer<DataSourceConfigurationsResult.Builder> dataSources) {
            return dataSources(DataSourceConfigurationsResult.builder().applyMutation(dataSources).build());
        }

        /**
         * <p>
         * Contains information about the status of the features for the member account.
         * </p>
         * 
         * @param features
         *        Contains information about the status of the features for the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<MemberFeaturesConfigurationResult> features);

        /**
         * <p>
         * Contains information about the status of the features for the member account.
         * </p>
         * 
         * @param features
         *        Contains information about the status of the features for the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(MemberFeaturesConfigurationResult... features);

        /**
         * <p>
         * Contains information about the status of the features for the member account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.MemberFeaturesConfigurationResult.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.MemberFeaturesConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.MemberFeaturesConfigurationResult.Builder#build()} is
         * called immediately and its result is passed to {@link #features(List<MemberFeaturesConfigurationResult>)}.
         * 
         * @param features
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.MemberFeaturesConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(java.util.Collection<MemberFeaturesConfigurationResult>)
         */
        Builder features(Consumer<MemberFeaturesConfigurationResult.Builder>... features);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private DataSourceConfigurationsResult dataSources;

        private List<MemberFeaturesConfigurationResult> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MemberDataSourceConfiguration model) {
            accountId(model.accountId);
            dataSources(model.dataSources);
            features(model.features);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Deprecated
        public final DataSourceConfigurationsResult.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(DataSourceConfigurationsResult.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(DataSourceConfigurationsResult dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<MemberFeaturesConfigurationResult.Builder> getFeatures() {
            List<MemberFeaturesConfigurationResult.Builder> result = MemberFeaturesConfigurationsResultsCopier
                    .copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<MemberFeaturesConfigurationResult.BuilderImpl> features) {
            this.features = MemberFeaturesConfigurationsResultsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<MemberFeaturesConfigurationResult> features) {
            this.features = MemberFeaturesConfigurationsResultsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(MemberFeaturesConfigurationResult... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<MemberFeaturesConfigurationResult.Builder>... features) {
            features(Stream.of(features).map(c -> MemberFeaturesConfigurationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public MemberDataSourceConfiguration build() {
            return new MemberDataSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
