/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the malware scan that generated a GuardDuty finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MalwareScanDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<MalwareScanDetails.Builder, MalwareScanDetails> {
    private static final SdkField<List<Threat>> THREATS_FIELD = SdkField
            .<List<Threat>> builder(MarshallingType.LIST)
            .memberName("Threats")
            .getter(getter(MalwareScanDetails::threats))
            .setter(setter(Builder::threats))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threats").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Threat> builder(MarshallingType.SDK_POJO)
                                            .constructor(Threat::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THREATS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Threat> threats;

    private MalwareScanDetails(BuilderImpl builder) {
        this.threats = builder.threats;
    }

    /**
     * For responses, this returns true if the service returned a value for the Threats property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasThreats() {
        return threats != null && !(threats instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the detected threats associated with the generated GuardDuty finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThreats} method.
     * </p>
     * 
     * @return Information about the detected threats associated with the generated GuardDuty finding.
     */
    public final List<Threat> threats() {
        return threats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasThreats() ? threats() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalwareScanDetails)) {
            return false;
        }
        MalwareScanDetails other = (MalwareScanDetails) obj;
        return hasThreats() == other.hasThreats() && Objects.equals(threats(), other.threats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MalwareScanDetails").add("Threats", hasThreats() ? threats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Threats":
            return Optional.ofNullable(clazz.cast(threats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("threats", THREATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MalwareScanDetails, T> g) {
        return obj -> g.apply((MalwareScanDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MalwareScanDetails> {
        /**
         * <p>
         * Information about the detected threats associated with the generated GuardDuty finding.
         * </p>
         * 
         * @param threats
         *        Information about the detected threats associated with the generated GuardDuty finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threats(Collection<Threat> threats);

        /**
         * <p>
         * Information about the detected threats associated with the generated GuardDuty finding.
         * </p>
         * 
         * @param threats
         *        Information about the detected threats associated with the generated GuardDuty finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threats(Threat... threats);

        /**
         * <p>
         * Information about the detected threats associated with the generated GuardDuty finding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.Threat.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.Threat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.Threat.Builder#build()} is called immediately and its
         * result is passed to {@link #threats(List<Threat>)}.
         * 
         * @param threats
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.Threat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threats(java.util.Collection<Threat>)
         */
        Builder threats(Consumer<Threat.Builder>... threats);
    }

    static final class BuilderImpl implements Builder {
        private List<Threat> threats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MalwareScanDetails model) {
            threats(model.threats);
        }

        public final List<Threat.Builder> getThreats() {
            List<Threat.Builder> result = ThreatsCopier.copyToBuilder(this.threats);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreats(Collection<Threat.BuilderImpl> threats) {
            this.threats = ThreatsCopier.copyFromBuilder(threats);
        }

        @Override
        public final Builder threats(Collection<Threat> threats) {
            this.threats = ThreatsCopier.copy(threats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threats(Threat... threats) {
            threats(Arrays.asList(threats));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threats(Consumer<Threat.Builder>... threats) {
            threats(Stream.of(threats).map(c -> Threat.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MalwareScanDetails build() {
            return new MalwareScanDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
