/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the runtime process details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineageObject implements SdkPojo, Serializable, ToCopyableBuilder<LineageObject.Builder, LineageObject> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(LineageObject::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Integer> NAMESPACE_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NamespacePid").getter(getter(LineageObject::namespacePid)).setter(setter(Builder::namespacePid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespacePid").build()).build();

    private static final SdkField<Integer> USER_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UserId").getter(getter(LineageObject::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(LineageObject::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Pid")
            .getter(getter(LineageObject::pid)).setter(setter(Builder::pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pid").build()).build();

    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uuid")
            .getter(getter(LineageObject::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuid").build()).build();

    private static final SdkField<String> EXECUTABLE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutablePath").getter(getter(LineageObject::executablePath)).setter(setter(Builder::executablePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executablePath").build()).build();

    private static final SdkField<Integer> EUID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Euid")
            .getter(getter(LineageObject::euid)).setter(setter(Builder::euid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("euid").build()).build();

    private static final SdkField<String> PARENT_UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentUuid").getter(getter(LineageObject::parentUuid)).setter(setter(Builder::parentUuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentUuid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            NAMESPACE_PID_FIELD, USER_ID_FIELD, NAME_FIELD, PID_FIELD, UUID_FIELD, EXECUTABLE_PATH_FIELD, EUID_FIELD,
            PARENT_UUID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startTime;

    private final Integer namespacePid;

    private final Integer userId;

    private final String name;

    private final Integer pid;

    private final String uuid;

    private final String executablePath;

    private final Integer euid;

    private final String parentUuid;

    private LineageObject(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.namespacePid = builder.namespacePid;
        this.userId = builder.userId;
        this.name = builder.name;
        this.pid = builder.pid;
        this.uuid = builder.uuid;
        this.executablePath = builder.executablePath;
        this.euid = builder.euid;
        this.parentUuid = builder.parentUuid;
    }

    /**
     * <p>
     * The time when the process started. This is in UTC format.
     * </p>
     * 
     * @return The time when the process started. This is in UTC format.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The process ID of the child process.
     * </p>
     * 
     * @return The process ID of the child process.
     */
    public final Integer namespacePid() {
        return namespacePid;
    }

    /**
     * <p>
     * The user ID of the user that executed the process.
     * </p>
     * 
     * @return The user ID of the user that executed the process.
     */
    public final Integer userId() {
        return userId;
    }

    /**
     * <p>
     * The name of the process.
     * </p>
     * 
     * @return The name of the process.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the process.
     * </p>
     * 
     * @return The ID of the process.
     */
    public final Integer pid() {
        return pid;
    }

    /**
     * <p>
     * The unique ID assigned to the process by GuardDuty.
     * </p>
     * 
     * @return The unique ID assigned to the process by GuardDuty.
     */
    public final String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The absolute path of the process executable file.
     * </p>
     * 
     * @return The absolute path of the process executable file.
     */
    public final String executablePath() {
        return executablePath;
    }

    /**
     * <p>
     * The effective user ID that was used to execute the process.
     * </p>
     * 
     * @return The effective user ID that was used to execute the process.
     */
    public final Integer euid() {
        return euid;
    }

    /**
     * <p>
     * The unique ID of the parent process. This ID is assigned to the parent process by GuardDuty.
     * </p>
     * 
     * @return The unique ID of the parent process. This ID is assigned to the parent process by GuardDuty.
     */
    public final String parentUuid() {
        return parentUuid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(namespacePid());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pid());
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(executablePath());
        hashCode = 31 * hashCode + Objects.hashCode(euid());
        hashCode = 31 * hashCode + Objects.hashCode(parentUuid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageObject)) {
            return false;
        }
        LineageObject other = (LineageObject) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(namespacePid(), other.namespacePid())
                && Objects.equals(userId(), other.userId()) && Objects.equals(name(), other.name())
                && Objects.equals(pid(), other.pid()) && Objects.equals(uuid(), other.uuid())
                && Objects.equals(executablePath(), other.executablePath()) && Objects.equals(euid(), other.euid())
                && Objects.equals(parentUuid(), other.parentUuid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineageObject").add("StartTime", startTime()).add("NamespacePid", namespacePid())
                .add("UserId", userId()).add("Name", name()).add("Pid", pid()).add("Uuid", uuid())
                .add("ExecutablePath", executablePath()).add("Euid", euid()).add("ParentUuid", parentUuid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "NamespacePid":
            return Optional.ofNullable(clazz.cast(namespacePid()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Pid":
            return Optional.ofNullable(clazz.cast(pid()));
        case "Uuid":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "ExecutablePath":
            return Optional.ofNullable(clazz.cast(executablePath()));
        case "Euid":
            return Optional.ofNullable(clazz.cast(euid()));
        case "ParentUuid":
            return Optional.ofNullable(clazz.cast(parentUuid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startTime", START_TIME_FIELD);
        map.put("namespacePid", NAMESPACE_PID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("pid", PID_FIELD);
        map.put("uuid", UUID_FIELD);
        map.put("executablePath", EXECUTABLE_PATH_FIELD);
        map.put("euid", EUID_FIELD);
        map.put("parentUuid", PARENT_UUID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineageObject, T> g) {
        return obj -> g.apply((LineageObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineageObject> {
        /**
         * <p>
         * The time when the process started. This is in UTC format.
         * </p>
         * 
         * @param startTime
         *        The time when the process started. This is in UTC format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The process ID of the child process.
         * </p>
         * 
         * @param namespacePid
         *        The process ID of the child process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespacePid(Integer namespacePid);

        /**
         * <p>
         * The user ID of the user that executed the process.
         * </p>
         * 
         * @param userId
         *        The user ID of the user that executed the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(Integer userId);

        /**
         * <p>
         * The name of the process.
         * </p>
         * 
         * @param name
         *        The name of the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the process.
         * </p>
         * 
         * @param pid
         *        The ID of the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pid(Integer pid);

        /**
         * <p>
         * The unique ID assigned to the process by GuardDuty.
         * </p>
         * 
         * @param uuid
         *        The unique ID assigned to the process by GuardDuty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The absolute path of the process executable file.
         * </p>
         * 
         * @param executablePath
         *        The absolute path of the process executable file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executablePath(String executablePath);

        /**
         * <p>
         * The effective user ID that was used to execute the process.
         * </p>
         * 
         * @param euid
         *        The effective user ID that was used to execute the process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder euid(Integer euid);

        /**
         * <p>
         * The unique ID of the parent process. This ID is assigned to the parent process by GuardDuty.
         * </p>
         * 
         * @param parentUuid
         *        The unique ID of the parent process. This ID is assigned to the parent process by GuardDuty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentUuid(String parentUuid);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTime;

        private Integer namespacePid;

        private Integer userId;

        private String name;

        private Integer pid;

        private String uuid;

        private String executablePath;

        private Integer euid;

        private String parentUuid;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageObject model) {
            startTime(model.startTime);
            namespacePid(model.namespacePid);
            userId(model.userId);
            name(model.name);
            pid(model.pid);
            uuid(model.uuid);
            executablePath(model.executablePath);
            euid(model.euid);
            parentUuid(model.parentUuid);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Integer getNamespacePid() {
            return namespacePid;
        }

        public final void setNamespacePid(Integer namespacePid) {
            this.namespacePid = namespacePid;
        }

        @Override
        public final Builder namespacePid(Integer namespacePid) {
            this.namespacePid = namespacePid;
            return this;
        }

        public final Integer getUserId() {
            return userId;
        }

        public final void setUserId(Integer userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(Integer userId) {
            this.userId = userId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPid() {
            return pid;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public final String getUuid() {
            return uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getExecutablePath() {
            return executablePath;
        }

        public final void setExecutablePath(String executablePath) {
            this.executablePath = executablePath;
        }

        @Override
        public final Builder executablePath(String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public final Integer getEuid() {
            return euid;
        }

        public final void setEuid(Integer euid) {
            this.euid = euid;
        }

        @Override
        public final Builder euid(Integer euid) {
            this.euid = euid;
            return this;
        }

        public final String getParentUuid() {
            return parentUuid;
        }

        public final void setParentUuid(String parentUuid) {
            this.parentUuid = parentUuid;
        }

        @Override
        public final Builder parentUuid(String parentUuid) {
            this.parentUuid = parentUuid;
            return this;
        }

        @Override
        public LineageObject build() {
            return new LineageObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
