/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about Kubernetes workloads involved in a GuardDuty finding, including pods, deployments, and
 * other Kubernetes resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesWorkload implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesWorkload.Builder, KubernetesWorkload> {
    private static final SdkField<List<String>> CONTAINER_UIDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContainerUids")
            .getter(getter(KubernetesWorkload::containerUids))
            .setter(setter(Builder::containerUids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerUids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(KubernetesWorkload::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> KUBERNETES_RESOURCES_TYPES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KubernetesResourcesTypes").getter(getter(KubernetesWorkload::kubernetesResourcesTypesAsString))
            .setter(setter(Builder::kubernetesResourcesTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_UIDS_FIELD,
            NAMESPACE_FIELD, KUBERNETES_RESOURCES_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> containerUids;

    private final String namespace;

    private final String kubernetesResourcesTypes;

    private KubernetesWorkload(BuilderImpl builder) {
        this.containerUids = builder.containerUids;
        this.namespace = builder.namespace;
        this.kubernetesResourcesTypes = builder.kubernetesResourcesTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerUids property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerUids() {
        return containerUids != null && !(containerUids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unique identifiers for the containers that are part of the Kubernetes workload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerUids} method.
     * </p>
     * 
     * @return A list of unique identifiers for the containers that are part of the Kubernetes workload.
     */
    public final List<String> containerUids() {
        return containerUids;
    }

    /**
     * <p>
     * The Kubernetes namespace in which the workload is running, providing logical isolation within the cluster.
     * </p>
     * 
     * @return The Kubernetes namespace in which the workload is running, providing logical isolation within the
     *         cluster.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The types of Kubernetes resources involved in the workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #kubernetesResourcesTypes} will return {@link KubernetesResourcesTypes#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #kubernetesResourcesTypesAsString}.
     * </p>
     * 
     * @return The types of Kubernetes resources involved in the workload.
     * @see KubernetesResourcesTypes
     */
    public final KubernetesResourcesTypes kubernetesResourcesTypes() {
        return KubernetesResourcesTypes.fromValue(kubernetesResourcesTypes);
    }

    /**
     * <p>
     * The types of Kubernetes resources involved in the workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #kubernetesResourcesTypes} will return {@link KubernetesResourcesTypes#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #kubernetesResourcesTypesAsString}.
     * </p>
     * 
     * @return The types of Kubernetes resources involved in the workload.
     * @see KubernetesResourcesTypes
     */
    public final String kubernetesResourcesTypesAsString() {
        return kubernetesResourcesTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerUids() ? containerUids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesResourcesTypesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesWorkload)) {
            return false;
        }
        KubernetesWorkload other = (KubernetesWorkload) obj;
        return hasContainerUids() == other.hasContainerUids() && Objects.equals(containerUids(), other.containerUids())
                && Objects.equals(namespace(), other.namespace())
                && Objects.equals(kubernetesResourcesTypesAsString(), other.kubernetesResourcesTypesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesWorkload").add("ContainerUids", hasContainerUids() ? containerUids() : null)
                .add("Namespace", namespace()).add("KubernetesResourcesTypes", kubernetesResourcesTypesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerUids":
            return Optional.ofNullable(clazz.cast(containerUids()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "KubernetesResourcesTypes":
            return Optional.ofNullable(clazz.cast(kubernetesResourcesTypesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("containerUids", CONTAINER_UIDS_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("type", KUBERNETES_RESOURCES_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesWorkload, T> g) {
        return obj -> g.apply((KubernetesWorkload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesWorkload> {
        /**
         * <p>
         * A list of unique identifiers for the containers that are part of the Kubernetes workload.
         * </p>
         * 
         * @param containerUids
         *        A list of unique identifiers for the containers that are part of the Kubernetes workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerUids(Collection<String> containerUids);

        /**
         * <p>
         * A list of unique identifiers for the containers that are part of the Kubernetes workload.
         * </p>
         * 
         * @param containerUids
         *        A list of unique identifiers for the containers that are part of the Kubernetes workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerUids(String... containerUids);

        /**
         * <p>
         * The Kubernetes namespace in which the workload is running, providing logical isolation within the cluster.
         * </p>
         * 
         * @param namespace
         *        The Kubernetes namespace in which the workload is running, providing logical isolation within the
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The types of Kubernetes resources involved in the workload.
         * </p>
         * 
         * @param kubernetesResourcesTypes
         *        The types of Kubernetes resources involved in the workload.
         * @see KubernetesResourcesTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KubernetesResourcesTypes
         */
        Builder kubernetesResourcesTypes(String kubernetesResourcesTypes);

        /**
         * <p>
         * The types of Kubernetes resources involved in the workload.
         * </p>
         * 
         * @param kubernetesResourcesTypes
         *        The types of Kubernetes resources involved in the workload.
         * @see KubernetesResourcesTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KubernetesResourcesTypes
         */
        Builder kubernetesResourcesTypes(KubernetesResourcesTypes kubernetesResourcesTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> containerUids = DefaultSdkAutoConstructList.getInstance();

        private String namespace;

        private String kubernetesResourcesTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesWorkload model) {
            containerUids(model.containerUids);
            namespace(model.namespace);
            kubernetesResourcesTypes(model.kubernetesResourcesTypes);
        }

        public final Collection<String> getContainerUids() {
            if (containerUids instanceof SdkAutoConstructList) {
                return null;
            }
            return containerUids;
        }

        public final void setContainerUids(Collection<String> containerUids) {
            this.containerUids = ContainerUidsCopier.copy(containerUids);
        }

        @Override
        public final Builder containerUids(Collection<String> containerUids) {
            this.containerUids = ContainerUidsCopier.copy(containerUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerUids(String... containerUids) {
            containerUids(Arrays.asList(containerUids));
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getKubernetesResourcesTypes() {
            return kubernetesResourcesTypes;
        }

        public final void setKubernetesResourcesTypes(String kubernetesResourcesTypes) {
            this.kubernetesResourcesTypes = kubernetesResourcesTypes;
        }

        @Override
        public final Builder kubernetesResourcesTypes(String kubernetesResourcesTypes) {
            this.kubernetesResourcesTypes = kubernetesResourcesTypes;
            return this;
        }

        @Override
        public final Builder kubernetesResourcesTypes(KubernetesResourcesTypes kubernetesResourcesTypes) {
            this.kubernetesResourcesTypes(kubernetesResourcesTypes == null ? null : kubernetesResourcesTypes.toString());
            return this;
        }

        @Override
        public KubernetesWorkload build() {
            return new KubernetesWorkload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
