/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about Kubernetes resources such as a Kubernetes user or workload resource involved in a Kubernetes finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesDetails.Builder, KubernetesDetails> {
    private static final SdkField<KubernetesUserDetails> KUBERNETES_USER_DETAILS_FIELD = SdkField
            .<KubernetesUserDetails> builder(MarshallingType.SDK_POJO).memberName("KubernetesUserDetails")
            .getter(getter(KubernetesDetails::kubernetesUserDetails)).setter(setter(Builder::kubernetesUserDetails))
            .constructor(KubernetesUserDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesUserDetails").build())
            .build();

    private static final SdkField<KubernetesWorkloadDetails> KUBERNETES_WORKLOAD_DETAILS_FIELD = SdkField
            .<KubernetesWorkloadDetails> builder(MarshallingType.SDK_POJO).memberName("KubernetesWorkloadDetails")
            .getter(getter(KubernetesDetails::kubernetesWorkloadDetails)).setter(setter(Builder::kubernetesWorkloadDetails))
            .constructor(KubernetesWorkloadDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesWorkloadDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KUBERNETES_USER_DETAILS_FIELD,
            KUBERNETES_WORKLOAD_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KubernetesUserDetails kubernetesUserDetails;

    private final KubernetesWorkloadDetails kubernetesWorkloadDetails;

    private KubernetesDetails(BuilderImpl builder) {
        this.kubernetesUserDetails = builder.kubernetesUserDetails;
        this.kubernetesWorkloadDetails = builder.kubernetesWorkloadDetails;
    }

    /**
     * <p>
     * Details about the Kubernetes user involved in a Kubernetes finding.
     * </p>
     * 
     * @return Details about the Kubernetes user involved in a Kubernetes finding.
     */
    public final KubernetesUserDetails kubernetesUserDetails() {
        return kubernetesUserDetails;
    }

    /**
     * <p>
     * Details about the Kubernetes workload involved in a Kubernetes finding.
     * </p>
     * 
     * @return Details about the Kubernetes workload involved in a Kubernetes finding.
     */
    public final KubernetesWorkloadDetails kubernetesWorkloadDetails() {
        return kubernetesWorkloadDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesUserDetails());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesWorkloadDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesDetails)) {
            return false;
        }
        KubernetesDetails other = (KubernetesDetails) obj;
        return Objects.equals(kubernetesUserDetails(), other.kubernetesUserDetails())
                && Objects.equals(kubernetesWorkloadDetails(), other.kubernetesWorkloadDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesDetails").add("KubernetesUserDetails", kubernetesUserDetails())
                .add("KubernetesWorkloadDetails", kubernetesWorkloadDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KubernetesUserDetails":
            return Optional.ofNullable(clazz.cast(kubernetesUserDetails()));
        case "KubernetesWorkloadDetails":
            return Optional.ofNullable(clazz.cast(kubernetesWorkloadDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("kubernetesUserDetails", KUBERNETES_USER_DETAILS_FIELD);
        map.put("kubernetesWorkloadDetails", KUBERNETES_WORKLOAD_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesDetails, T> g) {
        return obj -> g.apply((KubernetesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesDetails> {
        /**
         * <p>
         * Details about the Kubernetes user involved in a Kubernetes finding.
         * </p>
         * 
         * @param kubernetesUserDetails
         *        Details about the Kubernetes user involved in a Kubernetes finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesUserDetails(KubernetesUserDetails kubernetesUserDetails);

        /**
         * <p>
         * Details about the Kubernetes user involved in a Kubernetes finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesUserDetails.Builder} avoiding
         * the need to create one manually via {@link KubernetesUserDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesUserDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #kubernetesUserDetails(KubernetesUserDetails)}.
         * 
         * @param kubernetesUserDetails
         *        a consumer that will call methods on {@link KubernetesUserDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesUserDetails(KubernetesUserDetails)
         */
        default Builder kubernetesUserDetails(Consumer<KubernetesUserDetails.Builder> kubernetesUserDetails) {
            return kubernetesUserDetails(KubernetesUserDetails.builder().applyMutation(kubernetesUserDetails).build());
        }

        /**
         * <p>
         * Details about the Kubernetes workload involved in a Kubernetes finding.
         * </p>
         * 
         * @param kubernetesWorkloadDetails
         *        Details about the Kubernetes workload involved in a Kubernetes finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesWorkloadDetails(KubernetesWorkloadDetails kubernetesWorkloadDetails);

        /**
         * <p>
         * Details about the Kubernetes workload involved in a Kubernetes finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesWorkloadDetails.Builder}
         * avoiding the need to create one manually via {@link KubernetesWorkloadDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesWorkloadDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #kubernetesWorkloadDetails(KubernetesWorkloadDetails)}.
         * 
         * @param kubernetesWorkloadDetails
         *        a consumer that will call methods on {@link KubernetesWorkloadDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetesWorkloadDetails(KubernetesWorkloadDetails)
         */
        default Builder kubernetesWorkloadDetails(Consumer<KubernetesWorkloadDetails.Builder> kubernetesWorkloadDetails) {
            return kubernetesWorkloadDetails(KubernetesWorkloadDetails.builder().applyMutation(kubernetesWorkloadDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KubernetesUserDetails kubernetesUserDetails;

        private KubernetesWorkloadDetails kubernetesWorkloadDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesDetails model) {
            kubernetesUserDetails(model.kubernetesUserDetails);
            kubernetesWorkloadDetails(model.kubernetesWorkloadDetails);
        }

        public final KubernetesUserDetails.Builder getKubernetesUserDetails() {
            return kubernetesUserDetails != null ? kubernetesUserDetails.toBuilder() : null;
        }

        public final void setKubernetesUserDetails(KubernetesUserDetails.BuilderImpl kubernetesUserDetails) {
            this.kubernetesUserDetails = kubernetesUserDetails != null ? kubernetesUserDetails.build() : null;
        }

        @Override
        public final Builder kubernetesUserDetails(KubernetesUserDetails kubernetesUserDetails) {
            this.kubernetesUserDetails = kubernetesUserDetails;
            return this;
        }

        public final KubernetesWorkloadDetails.Builder getKubernetesWorkloadDetails() {
            return kubernetesWorkloadDetails != null ? kubernetesWorkloadDetails.toBuilder() : null;
        }

        public final void setKubernetesWorkloadDetails(KubernetesWorkloadDetails.BuilderImpl kubernetesWorkloadDetails) {
            this.kubernetesWorkloadDetails = kubernetesWorkloadDetails != null ? kubernetesWorkloadDetails.build() : null;
        }

        @Override
        public final Builder kubernetesWorkloadDetails(KubernetesWorkloadDetails kubernetesWorkloadDetails) {
            this.kubernetesWorkloadDetails = kubernetesWorkloadDetails;
            return this;
        }

        @Override
        public KubernetesDetails build() {
            return new KubernetesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
