/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the nested item path and hash of the protected resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItemPath implements SdkPojo, Serializable, ToCopyableBuilder<ItemPath.Builder, ItemPath> {
    private static final SdkField<String> NESTED_ITEM_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NestedItemPath").getter(getter(ItemPath::nestedItemPath)).setter(setter(Builder::nestedItemPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nestedItemPath").build()).build();

    private static final SdkField<String> HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Hash")
            .getter(getter(ItemPath::hash)).setter(setter(Builder::hash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hash").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NESTED_ITEM_PATH_FIELD,
            HASH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nestedItemPath;

    private final String hash;

    private ItemPath(BuilderImpl builder) {
        this.nestedItemPath = builder.nestedItemPath;
        this.hash = builder.hash;
    }

    /**
     * <p>
     * The nested item path where the infected file was found.
     * </p>
     * 
     * @return The nested item path where the infected file was found.
     */
    public final String nestedItemPath() {
        return nestedItemPath;
    }

    /**
     * <p>
     * The hash value of the infected resource.
     * </p>
     * 
     * @return The hash value of the infected resource.
     */
    public final String hash() {
        return hash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nestedItemPath());
        hashCode = 31 * hashCode + Objects.hashCode(hash());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemPath)) {
            return false;
        }
        ItemPath other = (ItemPath) obj;
        return Objects.equals(nestedItemPath(), other.nestedItemPath()) && Objects.equals(hash(), other.hash());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ItemPath").add("NestedItemPath", nestedItemPath()).add("Hash", hash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NestedItemPath":
            return Optional.ofNullable(clazz.cast(nestedItemPath()));
        case "Hash":
            return Optional.ofNullable(clazz.cast(hash()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nestedItemPath", NESTED_ITEM_PATH_FIELD);
        map.put("hash", HASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemPath, T> g) {
        return obj -> g.apply((ItemPath) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ItemPath> {
        /**
         * <p>
         * The nested item path where the infected file was found.
         * </p>
         * 
         * @param nestedItemPath
         *        The nested item path where the infected file was found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nestedItemPath(String nestedItemPath);

        /**
         * <p>
         * The hash value of the infected resource.
         * </p>
         * 
         * @param hash
         *        The hash value of the infected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hash(String hash);
    }

    static final class BuilderImpl implements Builder {
        private String nestedItemPath;

        private String hash;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemPath model) {
            nestedItemPath(model.nestedItemPath);
            hash(model.hash);
        }

        public final String getNestedItemPath() {
            return nestedItemPath;
        }

        public final void setNestedItemPath(String nestedItemPath) {
            this.nestedItemPath = nestedItemPath;
        }

        @Override
        public final Builder nestedItemPath(String nestedItemPath) {
            this.nestedItemPath = nestedItemPath;
            return this;
        }

        public final String getHash() {
            return hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        @Override
        public ItemPath build() {
            return new ItemPath(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
