/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsageStatisticsRequest extends GuardDutyRequest implements
        ToCopyableBuilder<GetUsageStatisticsRequest.Builder, GetUsageStatisticsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(GetUsageStatisticsRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<String> USAGE_STATISTIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageStatisticType").getter(getter(GetUsageStatisticsRequest::usageStatisticTypeAsString))
            .setter(setter(Builder::usageStatisticType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageStatisticsType").build())
            .build();

    private static final SdkField<UsageCriteria> USAGE_CRITERIA_FIELD = SdkField
            .<UsageCriteria> builder(MarshallingType.SDK_POJO).memberName("UsageCriteria")
            .getter(getter(GetUsageStatisticsRequest::usageCriteria)).setter(setter(Builder::usageCriteria))
            .constructor(UsageCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageCriteria").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(GetUsageStatisticsRequest::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetUsageStatisticsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetUsageStatisticsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            USAGE_STATISTIC_TYPE_FIELD, USAGE_CRITERIA_FIELD, UNIT_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String detectorId;

    private final String usageStatisticType;

    private final UsageCriteria usageCriteria;

    private final String unit;

    private final Integer maxResults;

    private final String nextToken;

    private GetUsageStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.usageStatisticType = builder.usageStatisticType;
        this.usageCriteria = builder.usageCriteria;
        this.unit = builder.unit;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the detector that specifies the GuardDuty service whose usage statistics you want to retrieve.
     * </p>
     * <p>
     * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or run
     * the <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     * API.
     * </p>
     * 
     * @return The ID of the detector that specifies the GuardDuty service whose usage statistics you want to
     *         retrieve.</p>
     *         <p>
     *         To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
     *         console, or run the <a
     *         href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
     *         API.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The type of usage statistics to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #usageStatisticType} will return {@link UsageStatisticType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #usageStatisticTypeAsString}.
     * </p>
     * 
     * @return The type of usage statistics to retrieve.
     * @see UsageStatisticType
     */
    public final UsageStatisticType usageStatisticType() {
        return UsageStatisticType.fromValue(usageStatisticType);
    }

    /**
     * <p>
     * The type of usage statistics to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #usageStatisticType} will return {@link UsageStatisticType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #usageStatisticTypeAsString}.
     * </p>
     * 
     * @return The type of usage statistics to retrieve.
     * @see UsageStatisticType
     */
    public final String usageStatisticTypeAsString() {
        return usageStatisticType;
    }

    /**
     * <p>
     * Represents the criteria used for querying usage.
     * </p>
     * 
     * @return Represents the criteria used for querying usage.
     */
    public final UsageCriteria usageCriteria() {
        return usageCriteria;
    }

    /**
     * <p>
     * The currency unit you would like to view your usage statistics in. Current valid values are USD.
     * </p>
     * 
     * @return The currency unit you would like to view your usage statistics in. Current valid values are USD.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * The maximum number of results to return in the response.
     * </p>
     * 
     * @return The maximum number of results to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. For subsequent calls, use the NextToken value returned from the previous
     * request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. For subsequent calls, use the NextToken value returned
     *         from the previous request to continue listing results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(usageStatisticTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usageCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageStatisticsRequest)) {
            return false;
        }
        GetUsageStatisticsRequest other = (GetUsageStatisticsRequest) obj;
        return Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(usageStatisticTypeAsString(), other.usageStatisticTypeAsString())
                && Objects.equals(usageCriteria(), other.usageCriteria()) && Objects.equals(unit(), other.unit())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUsageStatisticsRequest").add("DetectorId", detectorId())
                .add("UsageStatisticType", usageStatisticTypeAsString()).add("UsageCriteria", usageCriteria())
                .add("Unit", unit()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "UsageStatisticType":
            return Optional.ofNullable(clazz.cast(usageStatisticTypeAsString()));
        case "UsageCriteria":
            return Optional.ofNullable(clazz.cast(usageCriteria()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("usageStatisticsType", USAGE_STATISTIC_TYPE_FIELD);
        map.put("usageCriteria", USAGE_CRITERIA_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUsageStatisticsRequest, T> g) {
        return obj -> g.apply((GetUsageStatisticsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetUsageStatisticsRequest> {
        /**
         * <p>
         * The ID of the detector that specifies the GuardDuty service whose usage statistics you want to retrieve.
         * </p>
         * <p>
         * To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty console, or
         * run the <a
         * href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html">ListDetectors</a>
         * API.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector that specifies the GuardDuty service whose usage statistics you want to
         *        retrieve.</p>
         *        <p>
         *        To find the <code>detectorId</code> in the current Region, see the Settings page in the GuardDuty
         *        console, or run the <a
         *        href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html"
         *        >ListDetectors</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The type of usage statistics to retrieve.
         * </p>
         * 
         * @param usageStatisticType
         *        The type of usage statistics to retrieve.
         * @see UsageStatisticType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageStatisticType
         */
        Builder usageStatisticType(String usageStatisticType);

        /**
         * <p>
         * The type of usage statistics to retrieve.
         * </p>
         * 
         * @param usageStatisticType
         *        The type of usage statistics to retrieve.
         * @see UsageStatisticType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageStatisticType
         */
        Builder usageStatisticType(UsageStatisticType usageStatisticType);

        /**
         * <p>
         * Represents the criteria used for querying usage.
         * </p>
         * 
         * @param usageCriteria
         *        Represents the criteria used for querying usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageCriteria(UsageCriteria usageCriteria);

        /**
         * <p>
         * Represents the criteria used for querying usage.
         * </p>
         * This is a convenience method that creates an instance of the {@link UsageCriteria.Builder} avoiding the need
         * to create one manually via {@link UsageCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UsageCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #usageCriteria(UsageCriteria)}.
         * 
         * @param usageCriteria
         *        a consumer that will call methods on {@link UsageCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageCriteria(UsageCriteria)
         */
        default Builder usageCriteria(Consumer<UsageCriteria.Builder> usageCriteria) {
            return usageCriteria(UsageCriteria.builder().applyMutation(usageCriteria).build());
        }

        /**
         * <p>
         * The currency unit you would like to view your usage statistics in. Current valid values are USD.
         * </p>
         * 
         * @param unit
         *        The currency unit you would like to view your usage statistics in. Current valid values are USD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request to a list action. For subsequent calls, use the NextToken value returned from the
         * previous request to continue listing results after the first page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request to a list action. For subsequent calls, use the NextToken
         *        value returned from the previous request to continue listing results after the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String usageStatisticType;

        private UsageCriteria usageCriteria;

        private String unit;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageStatisticsRequest model) {
            super(model);
            detectorId(model.detectorId);
            usageStatisticType(model.usageStatisticType);
            usageCriteria(model.usageCriteria);
            unit(model.unit);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getUsageStatisticType() {
            return usageStatisticType;
        }

        public final void setUsageStatisticType(String usageStatisticType) {
            this.usageStatisticType = usageStatisticType;
        }

        @Override
        public final Builder usageStatisticType(String usageStatisticType) {
            this.usageStatisticType = usageStatisticType;
            return this;
        }

        @Override
        public final Builder usageStatisticType(UsageStatisticType usageStatisticType) {
            this.usageStatisticType(usageStatisticType == null ? null : usageStatisticType.toString());
            return this;
        }

        public final UsageCriteria.Builder getUsageCriteria() {
            return usageCriteria != null ? usageCriteria.toBuilder() : null;
        }

        public final void setUsageCriteria(UsageCriteria.BuilderImpl usageCriteria) {
            this.usageCriteria = usageCriteria != null ? usageCriteria.build() : null;
        }

        @Override
        public final Builder usageCriteria(UsageCriteria usageCriteria) {
            this.usageCriteria = usageCriteria;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsageStatisticsRequest build() {
            return new GetUsageStatisticsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
