/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetThreatIntelSetResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetThreatIntelSetResponse.Builder, GetThreatIntelSetResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetThreatIntelSetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(GetThreatIntelSetResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(GetThreatIntelSetResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetThreatIntelSetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetThreatIntelSetResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpectedBucketOwner").getter(getter(GetThreatIntelSetResponse::expectedBucketOwner))
            .setter(setter(Builder::expectedBucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedBucketOwner").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORMAT_FIELD,
            LOCATION_FIELD, STATUS_FIELD, TAGS_FIELD, EXPECTED_BUCKET_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String format;

    private final String location;

    private final String status;

    private final Map<String, String> tags;

    private final String expectedBucketOwner;

    private GetThreatIntelSetResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.format = builder.format;
        this.location = builder.location;
        this.status = builder.status;
        this.tags = builder.tags;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    /**
     * <p>
     * A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that involves IP
     * addresses included in this ThreatIntelSet.
     * </p>
     * 
     * @return A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that
     *         involves IP addresses included in this ThreatIntelSet.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The format of the threatIntelSet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ThreatIntelSetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the threatIntelSet.
     * @see ThreatIntelSetFormat
     */
    public final ThreatIntelSetFormat format() {
        return ThreatIntelSetFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the threatIntelSet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ThreatIntelSetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the threatIntelSet.
     * @see ThreatIntelSetFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The URI of the file that contains the ThreatIntelSet.
     * </p>
     * 
     * @return The URI of the file that contains the ThreatIntelSet.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The status of threatIntelSet file uploaded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ThreatIntelSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of threatIntelSet file uploaded.
     * @see ThreatIntelSetStatus
     */
    public final ThreatIntelSetStatus status() {
        return ThreatIntelSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of threatIntelSet file uploaded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ThreatIntelSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of threatIntelSet file uploaded.
     * @see ThreatIntelSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the threat list resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the threat list resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b> parameter.
     * This field appears in the response only if it was provided during ThreatIntelSet creation or update.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b>
     *         parameter. This field appears in the response only if it was provided during ThreatIntelSet creation or
     *         update.
     */
    public final String expectedBucketOwner() {
        return expectedBucketOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expectedBucketOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetThreatIntelSetResponse)) {
            return false;
        }
        GetThreatIntelSetResponse other = (GetThreatIntelSetResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(location(), other.location()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(expectedBucketOwner(), other.expectedBucketOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetThreatIntelSetResponse").add("Name", name()).add("Format", formatAsString())
                .add("Location", location()).add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null)
                .add("ExpectedBucketOwner", expectedBucketOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ExpectedBucketOwner":
            return Optional.ofNullable(clazz.cast(expectedBucketOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("expectedBucketOwner", EXPECTED_BUCKET_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetThreatIntelSetResponse, T> g) {
        return obj -> g.apply((GetThreatIntelSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetThreatIntelSetResponse> {
        /**
         * <p>
         * A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that involves IP
         * addresses included in this ThreatIntelSet.
         * </p>
         * 
         * @param name
         *        A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that
         *        involves IP addresses included in this ThreatIntelSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The format of the threatIntelSet.
         * </p>
         * 
         * @param format
         *        The format of the threatIntelSet.
         * @see ThreatIntelSetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatIntelSetFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the threatIntelSet.
         * </p>
         * 
         * @param format
         *        The format of the threatIntelSet.
         * @see ThreatIntelSetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatIntelSetFormat
         */
        Builder format(ThreatIntelSetFormat format);

        /**
         * <p>
         * The URI of the file that contains the ThreatIntelSet.
         * </p>
         * 
         * @param location
         *        The URI of the file that contains the ThreatIntelSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The status of threatIntelSet file uploaded.
         * </p>
         * 
         * @param status
         *        The status of threatIntelSet file uploaded.
         * @see ThreatIntelSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatIntelSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of threatIntelSet file uploaded.
         * </p>
         * 
         * @param status
         *        The status of threatIntelSet file uploaded.
         * @see ThreatIntelSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatIntelSetStatus
         */
        Builder status(ThreatIntelSetStatus status);

        /**
         * <p>
         * The tags of the threat list resource.
         * </p>
         * 
         * @param tags
         *        The tags of the threat list resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b> parameter.
         * This field appears in the response only if it was provided during ThreatIntelSet creation or update.
         * </p>
         * 
         * @param expectedBucketOwner
         *        The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b>
         *        parameter. This field appears in the response only if it was provided during ThreatIntelSet creation
         *        or update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedBucketOwner(String expectedBucketOwner);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String name;

        private String format;

        private String location;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String expectedBucketOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(GetThreatIntelSetResponse model) {
            super(model);
            name(model.name);
            format(model.format);
            location(model.location);
            status(model.status);
            tags(model.tags);
            expectedBucketOwner(model.expectedBucketOwner);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ThreatIntelSetFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ThreatIntelSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getExpectedBucketOwner() {
            return expectedBucketOwner;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public GetThreatIntelSetResponse build() {
            return new GetThreatIntelSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
