/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetThreatEntitySetResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetThreatEntitySetResponse.Builder, GetThreatEntitySetResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetThreatEntitySetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(GetThreatEntitySetResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(GetThreatEntitySetResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpectedBucketOwner").getter(getter(GetThreatEntitySetResponse::expectedBucketOwner))
            .setter(setter(Builder::expectedBucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedBucketOwner").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetThreatEntitySetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetThreatEntitySetResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetThreatEntitySetResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(GetThreatEntitySetResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> ERROR_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorDetails").getter(getter(GetThreatEntitySetResponse::errorDetails))
            .setter(setter(Builder::errorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORMAT_FIELD,
            LOCATION_FIELD, EXPECTED_BUCKET_OWNER_FIELD, STATUS_FIELD, TAGS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String format;

    private final String location;

    private final String expectedBucketOwner;

    private final String status;

    private final Map<String, String> tags;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String errorDetails;

    private GetThreatEntitySetResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.format = builder.format;
        this.location = builder.location;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.status = builder.status;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * The name of the threat entity set associated with the specified <code>threatEntitySetId</code>.
     * </p>
     * 
     * @return The name of the threat entity set associated with the specified <code>threatEntitySetId</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The format of the file that contains the threat entity set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ThreatEntitySetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the file that contains the threat entity set.
     * @see ThreatEntitySetFormat
     */
    public final ThreatEntitySetFormat format() {
        return ThreatEntitySetFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the file that contains the threat entity set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ThreatEntitySetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the file that contains the threat entity set.
     * @see ThreatEntitySetFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The URI of the file that contains the threat entity set.
     * </p>
     * 
     * @return The URI of the file that contains the threat entity set.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b> parameter.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b>
     *         parameter.
     */
    public final String expectedBucketOwner() {
        return expectedBucketOwner;
    }

    /**
     * <p>
     * The status of the associated threat entity set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ThreatEntitySetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the associated threat entity set.
     * @see ThreatEntitySetStatus
     */
    public final ThreatEntitySetStatus status() {
        return ThreatEntitySetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the associated threat entity set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ThreatEntitySetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the associated threat entity set.
     * @see ThreatEntitySetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the threat entity set resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the threat entity set resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The timestamp when the associated threat entity set was created.
     * </p>
     * 
     * @return The timestamp when the associated threat entity set was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the associated threat entity set was updated.
     * </p>
     * 
     * @return The timestamp when the associated threat entity set was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The error details when the status is shown as <code>ERROR</code>.
     * </p>
     * 
     * @return The error details when the status is shown as <code>ERROR</code>.
     */
    public final String errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(expectedBucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetThreatEntitySetResponse)) {
            return false;
        }
        GetThreatEntitySetResponse other = (GetThreatEntitySetResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(location(), other.location())
                && Objects.equals(expectedBucketOwner(), other.expectedBucketOwner())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(errorDetails(), other.errorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetThreatEntitySetResponse").add("Name", name()).add("Format", formatAsString())
                .add("Location", location()).add("ExpectedBucketOwner", expectedBucketOwner()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("ErrorDetails", errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "ExpectedBucketOwner":
            return Optional.ofNullable(clazz.cast(expectedBucketOwner()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("expectedBucketOwner", EXPECTED_BUCKET_OWNER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("errorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetThreatEntitySetResponse, T> g) {
        return obj -> g.apply((GetThreatEntitySetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetThreatEntitySetResponse> {
        /**
         * <p>
         * The name of the threat entity set associated with the specified <code>threatEntitySetId</code>.
         * </p>
         * 
         * @param name
         *        The name of the threat entity set associated with the specified <code>threatEntitySetId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The format of the file that contains the threat entity set.
         * </p>
         * 
         * @param format
         *        The format of the file that contains the threat entity set.
         * @see ThreatEntitySetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatEntitySetFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the file that contains the threat entity set.
         * </p>
         * 
         * @param format
         *        The format of the file that contains the threat entity set.
         * @see ThreatEntitySetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatEntitySetFormat
         */
        Builder format(ThreatEntitySetFormat format);

        /**
         * <p>
         * The URI of the file that contains the threat entity set.
         * </p>
         * 
         * @param location
         *        The URI of the file that contains the threat entity set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b> parameter.
         * </p>
         * 
         * @param expectedBucketOwner
         *        The Amazon Web Services account ID that owns the Amazon S3 bucket specified in the <b>location</b>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedBucketOwner(String expectedBucketOwner);

        /**
         * <p>
         * The status of the associated threat entity set.
         * </p>
         * 
         * @param status
         *        The status of the associated threat entity set.
         * @see ThreatEntitySetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatEntitySetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the associated threat entity set.
         * </p>
         * 
         * @param status
         *        The status of the associated threat entity set.
         * @see ThreatEntitySetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatEntitySetStatus
         */
        Builder status(ThreatEntitySetStatus status);

        /**
         * <p>
         * The tags associated with the threat entity set resource.
         * </p>
         * 
         * @param tags
         *        The tags associated with the threat entity set resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The timestamp when the associated threat entity set was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the associated threat entity set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the associated threat entity set was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the associated threat entity set was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The error details when the status is shown as <code>ERROR</code>.
         * </p>
         * 
         * @param errorDetails
         *        The error details when the status is shown as <code>ERROR</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(String errorDetails);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String name;

        private String format;

        private String location;

        private String expectedBucketOwner;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdAt;

        private Instant updatedAt;

        private String errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetThreatEntitySetResponse model) {
            super(model);
            name(model.name);
            format(model.format);
            location(model.location);
            expectedBucketOwner(model.expectedBucketOwner);
            status(model.status);
            tags(model.tags);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            errorDetails(model.errorDetails);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ThreatEntitySetFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getExpectedBucketOwner() {
            return expectedBucketOwner;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ThreatEntitySetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getErrorDetails() {
            return errorDetails;
        }

        public final void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        @Override
        public final Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @Override
        public GetThreatEntitySetResponse build() {
            return new GetThreatEntitySetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
