/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCoverageStatisticsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetCoverageStatisticsResponse.Builder, GetCoverageStatisticsResponse> {
    private static final SdkField<CoverageStatistics> COVERAGE_STATISTICS_FIELD = SdkField
            .<CoverageStatistics> builder(MarshallingType.SDK_POJO).memberName("CoverageStatistics")
            .getter(getter(GetCoverageStatisticsResponse::coverageStatistics)).setter(setter(Builder::coverageStatistics))
            .constructor(CoverageStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coverageStatistics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COVERAGE_STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CoverageStatistics coverageStatistics;

    private GetCoverageStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.coverageStatistics = builder.coverageStatistics;
    }

    /**
     * <p>
     * Represents the count aggregated by the <code>statusCode</code> and <code>resourceType</code>.
     * </p>
     * 
     * @return Represents the count aggregated by the <code>statusCode</code> and <code>resourceType</code>.
     */
    public final CoverageStatistics coverageStatistics() {
        return coverageStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coverageStatistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoverageStatisticsResponse)) {
            return false;
        }
        GetCoverageStatisticsResponse other = (GetCoverageStatisticsResponse) obj;
        return Objects.equals(coverageStatistics(), other.coverageStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCoverageStatisticsResponse").add("CoverageStatistics", coverageStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoverageStatistics":
            return Optional.ofNullable(clazz.cast(coverageStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("coverageStatistics", COVERAGE_STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCoverageStatisticsResponse, T> g) {
        return obj -> g.apply((GetCoverageStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCoverageStatisticsResponse> {
        /**
         * <p>
         * Represents the count aggregated by the <code>statusCode</code> and <code>resourceType</code>.
         * </p>
         * 
         * @param coverageStatistics
         *        Represents the count aggregated by the <code>statusCode</code> and <code>resourceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coverageStatistics(CoverageStatistics coverageStatistics);

        /**
         * <p>
         * Represents the count aggregated by the <code>statusCode</code> and <code>resourceType</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoverageStatistics.Builder} avoiding the
         * need to create one manually via {@link CoverageStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoverageStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #coverageStatistics(CoverageStatistics)}.
         * 
         * @param coverageStatistics
         *        a consumer that will call methods on {@link CoverageStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coverageStatistics(CoverageStatistics)
         */
        default Builder coverageStatistics(Consumer<CoverageStatistics.Builder> coverageStatistics) {
            return coverageStatistics(CoverageStatistics.builder().applyMutation(coverageStatistics).build());
        }
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private CoverageStatistics coverageStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoverageStatisticsResponse model) {
            super(model);
            coverageStatistics(model.coverageStatistics);
        }

        public final CoverageStatistics.Builder getCoverageStatistics() {
            return coverageStatistics != null ? coverageStatistics.toBuilder() : null;
        }

        public final void setCoverageStatistics(CoverageStatistics.BuilderImpl coverageStatistics) {
            this.coverageStatistics = coverageStatistics != null ? coverageStatistics.build() : null;
        }

        @Override
        public final Builder coverageStatistics(CoverageStatistics coverageStatistics) {
            this.coverageStatistics = coverageStatistics;
            return this;
        }

        @Override
        public GetCoverageStatisticsResponse build() {
            return new GetCoverageStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
