/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the potentially impacted Amazon EC2 instance resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2Instance implements SdkPojo, Serializable, ToCopyableBuilder<Ec2Instance.Builder, Ec2Instance> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(Ec2Instance::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> IMAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageDescription").getter(getter(Ec2Instance::imageDescription))
            .setter(setter(Builder::imageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDescription").build()).build();

    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceState").getter(getter(Ec2Instance::instanceState)).setter(setter(Builder::instanceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceState").build()).build();

    private static final SdkField<IamInstanceProfile> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<IamInstanceProfile> builder(MarshallingType.SDK_POJO).memberName("IamInstanceProfile")
            .getter(getter(Ec2Instance::iamInstanceProfile)).setter(setter(Builder::iamInstanceProfile))
            .constructor(IamInstanceProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(Ec2Instance::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn").getter(getter(Ec2Instance::outpostArn)).setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outpostArn").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(Ec2Instance::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .memberName("ProductCodes")
            .getter(getter(Ec2Instance::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EC2_NETWORK_INTERFACE_UIDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Ec2NetworkInterfaceUids")
            .getter(getter(Ec2Instance::ec2NetworkInterfaceUids))
            .setter(setter(Builder::ec2NetworkInterfaceUids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2NetworkInterfaceUids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            IMAGE_DESCRIPTION_FIELD, INSTANCE_STATE_FIELD, IAM_INSTANCE_PROFILE_FIELD, INSTANCE_TYPE_FIELD, OUTPOST_ARN_FIELD,
            PLATFORM_FIELD, PRODUCT_CODES_FIELD, EC2_NETWORK_INTERFACE_UIDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String imageDescription;

    private final String instanceState;

    private final IamInstanceProfile iamInstanceProfile;

    private final String instanceType;

    private final String outpostArn;

    private final String platform;

    private final List<ProductCode> productCodes;

    private final List<String> ec2NetworkInterfaceUids;

    private Ec2Instance(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.imageDescription = builder.imageDescription;
        this.instanceState = builder.instanceState;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceType = builder.instanceType;
        this.outpostArn = builder.outpostArn;
        this.platform = builder.platform;
        this.productCodes = builder.productCodes;
        this.ec2NetworkInterfaceUids = builder.ec2NetworkInterfaceUids;
    }

    /**
     * <p>
     * The availability zone of the Amazon EC2 instance. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones"
     * >Availability zones</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The availability zone of the Amazon EC2 instance. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones"
     *         >Availability zones</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The image description of the Amazon EC2 instance.
     * </p>
     * 
     * @return The image description of the Amazon EC2 instance.
     */
    public final String imageDescription() {
        return imageDescription;
    }

    /**
     * <p>
     * The state of the Amazon EC2 instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Amazon EC2 instance state
     * changes</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The state of the Amazon EC2 instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Amazon EC2
     *         instance state changes</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String instanceState() {
        return instanceState;
    }

    /**
     * Returns the value of the IamInstanceProfile property for this object.
     * 
     * @return The value of the IamInstanceProfile property for this object.
     */
    public final IamInstanceProfile iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Type of the Amazon EC2 instance.
     * </p>
     * 
     * @return Type of the Amazon EC2 instance.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. This shows applicable Amazon Web Services
     * Outposts instances.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. This shows applicable Amazon Web
     *         Services Outposts instances.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The platform of the Amazon EC2 instance.
     * </p>
     * 
     * @return The platform of the Amazon EC2 instance.
     */
    public final String platform() {
        return platform;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductCodes() {
        return productCodes != null && !(productCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product code of the Amazon EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductCodes} method.
     * </p>
     * 
     * @return The product code of the Amazon EC2 instance.
     */
    public final List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2NetworkInterfaceUids property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEc2NetworkInterfaceUids() {
        return ec2NetworkInterfaceUids != null && !(ec2NetworkInterfaceUids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2NetworkInterfaceUids} method.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final List<String> ec2NetworkInterfaceUids() {
        return ec2NetworkInterfaceUids;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(imageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(instanceState());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductCodes() ? productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2NetworkInterfaceUids() ? ec2NetworkInterfaceUids() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2Instance)) {
            return false;
        }
        Ec2Instance other = (Ec2Instance) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(imageDescription(), other.imageDescription())
                && Objects.equals(instanceState(), other.instanceState())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(platform(), other.platform()) && hasProductCodes() == other.hasProductCodes()
                && Objects.equals(productCodes(), other.productCodes())
                && hasEc2NetworkInterfaceUids() == other.hasEc2NetworkInterfaceUids()
                && Objects.equals(ec2NetworkInterfaceUids(), other.ec2NetworkInterfaceUids());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2Instance").add("AvailabilityZone", availabilityZone())
                .add("ImageDescription", imageDescription()).add("InstanceState", instanceState())
                .add("IamInstanceProfile", iamInstanceProfile()).add("InstanceType", instanceType())
                .add("OutpostArn", outpostArn()).add("Platform", platform())
                .add("ProductCodes", hasProductCodes() ? productCodes() : null)
                .add("Ec2NetworkInterfaceUids", hasEc2NetworkInterfaceUids() ? ec2NetworkInterfaceUids() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ImageDescription":
            return Optional.ofNullable(clazz.cast(imageDescription()));
        case "InstanceState":
            return Optional.ofNullable(clazz.cast(instanceState()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "Ec2NetworkInterfaceUids":
            return Optional.ofNullable(clazz.cast(ec2NetworkInterfaceUids()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("imageDescription", IMAGE_DESCRIPTION_FIELD);
        map.put("instanceState", INSTANCE_STATE_FIELD);
        map.put("IamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("outpostArn", OUTPOST_ARN_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("productCodes", PRODUCT_CODES_FIELD);
        map.put("ec2NetworkInterfaceUids", EC2_NETWORK_INTERFACE_UIDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2Instance, T> g) {
        return obj -> g.apply((Ec2Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2Instance> {
        /**
         * <p>
         * The availability zone of the Amazon EC2 instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones"
         * >Availability zones</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param availabilityZone
         *        The availability zone of the Amazon EC2 instance. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones"
         *        >Availability zones</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The image description of the Amazon EC2 instance.
         * </p>
         * 
         * @param imageDescription
         *        The image description of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDescription(String imageDescription);

        /**
         * <p>
         * The state of the Amazon EC2 instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Amazon EC2 instance
         * state changes</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceState
         *        The state of the Amazon EC2 instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Amazon EC2
         *        instance state changes</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceState(String instanceState);

        /**
         * Sets the value of the IamInstanceProfile property for this object.
         *
         * @param iamInstanceProfile
         *        The new value for the IamInstanceProfile property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile);

        /**
         * Sets the value of the IamInstanceProfile property for this object.
         *
         * This is a convenience method that creates an instance of the {@link IamInstanceProfile.Builder} avoiding the
         * need to create one manually via {@link IamInstanceProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamInstanceProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #iamInstanceProfile(IamInstanceProfile)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfile)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfile.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfile.builder().applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * Type of the Amazon EC2 instance.
         * </p>
         * 
         * @param instanceType
         *        Type of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. This shows applicable Amazon Web Services
         * Outposts instances.
         * </p>
         * 
         * @param outpostArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. This shows applicable Amazon Web
         *        Services Outposts instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The platform of the Amazon EC2 instance.
         * </p>
         * 
         * @param platform
         *        The platform of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The product code of the Amazon EC2 instance.
         * </p>
         * 
         * @param productCodes
         *        The product code of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product code of the Amazon EC2 instance.
         * </p>
         * 
         * @param productCodes
         *        The product code of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The product code of the Amazon EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.ProductCode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.guardduty.model.ProductCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.ProductCode.Builder#build()} is called immediately and
         * its result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.ProductCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(java.util.Collection<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param ec2NetworkInterfaceUids
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2NetworkInterfaceUids(Collection<String> ec2NetworkInterfaceUids);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param ec2NetworkInterfaceUids
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2NetworkInterfaceUids(String... ec2NetworkInterfaceUids);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String imageDescription;

        private String instanceState;

        private IamInstanceProfile iamInstanceProfile;

        private String instanceType;

        private String outpostArn;

        private String platform;

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> ec2NetworkInterfaceUids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2Instance model) {
            availabilityZone(model.availabilityZone);
            imageDescription(model.imageDescription);
            instanceState(model.instanceState);
            iamInstanceProfile(model.iamInstanceProfile);
            instanceType(model.instanceType);
            outpostArn(model.outpostArn);
            platform(model.platform);
            productCodes(model.productCodes);
            ec2NetworkInterfaceUids(model.ec2NetworkInterfaceUids);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getImageDescription() {
            return imageDescription;
        }

        public final void setImageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
        }

        @Override
        public final Builder imageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
            return this;
        }

        public final String getInstanceState() {
            return instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public final IamInstanceProfile.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfile.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfile iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodesCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodesCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodesCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getEc2NetworkInterfaceUids() {
            if (ec2NetworkInterfaceUids instanceof SdkAutoConstructList) {
                return null;
            }
            return ec2NetworkInterfaceUids;
        }

        public final void setEc2NetworkInterfaceUids(Collection<String> ec2NetworkInterfaceUids) {
            this.ec2NetworkInterfaceUids = Ec2NetworkInterfaceUidsCopier.copy(ec2NetworkInterfaceUids);
        }

        @Override
        public final Builder ec2NetworkInterfaceUids(Collection<String> ec2NetworkInterfaceUids) {
            this.ec2NetworkInterfaceUids = Ec2NetworkInterfaceUidsCopier.copy(ec2NetworkInterfaceUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2NetworkInterfaceUids(String... ec2NetworkInterfaceUids) {
            ec2NetworkInterfaceUids(Arrays.asList(ec2NetworkInterfaceUids));
            return this;
        }

        @Override
        public Ec2Instance build() {
            return new Ec2Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
