/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a GuardDuty feature.
 * </p>
 * <p>
 * Specifying both EKS Runtime Monitoring (<code>EKS_RUNTIME_MONITORING</code>) and Runtime Monitoring (
 * <code>RUNTIME_MONITORING</code>) will cause an error. You can add only one of these two features because Runtime
 * Monitoring already includes the threat detection for Amazon EKS resources. For more information, see <a
 * href="https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html">Runtime Monitoring</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectorFeatureConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectorFeatureConfiguration.Builder, DetectorFeatureConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DetectorFeatureConfiguration::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DetectorFeatureConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<DetectorAdditionalConfiguration>> ADDITIONAL_CONFIGURATION_FIELD = SdkField
            .<List<DetectorAdditionalConfiguration>> builder(MarshallingType.LIST)
            .memberName("AdditionalConfiguration")
            .getter(getter(DetectorFeatureConfiguration::additionalConfiguration))
            .setter(setter(Builder::additionalConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectorAdditionalConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectorAdditionalConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            ADDITIONAL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final List<DetectorAdditionalConfiguration> additionalConfiguration;

    private DetectorFeatureConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.additionalConfiguration = builder.additionalConfiguration;
    }

    /**
     * <p>
     * The name of the feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link DetectorFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the feature.
     * @see DetectorFeature
     */
    public final DetectorFeature name() {
        return DetectorFeature.fromValue(name);
    }

    /**
     * <p>
     * The name of the feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link DetectorFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the feature.
     * @see DetectorFeature
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The status of the feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the feature.
     * @see FeatureStatus
     */
    public final FeatureStatus status() {
        return FeatureStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the feature.
     * @see FeatureStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalConfiguration() {
        return additionalConfiguration != null && !(additionalConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional configuration for a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalConfiguration} method.
     * </p>
     * 
     * @return Additional configuration for a resource.
     */
    public final List<DetectorAdditionalConfiguration> additionalConfiguration() {
        return additionalConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalConfiguration() ? additionalConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorFeatureConfiguration)) {
            return false;
        }
        DetectorFeatureConfiguration other = (DetectorFeatureConfiguration) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasAdditionalConfiguration() == other.hasAdditionalConfiguration()
                && Objects.equals(additionalConfiguration(), other.additionalConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectorFeatureConfiguration").add("Name", nameAsString()).add("Status", statusAsString())
                .add("AdditionalConfiguration", hasAdditionalConfiguration() ? additionalConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AdditionalConfiguration":
            return Optional.ofNullable(clazz.cast(additionalConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("additionalConfiguration", ADDITIONAL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectorFeatureConfiguration, T> g) {
        return obj -> g.apply((DetectorFeatureConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectorFeatureConfiguration> {
        /**
         * <p>
         * The name of the feature.
         * </p>
         * 
         * @param name
         *        The name of the feature.
         * @see DetectorFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorFeature
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the feature.
         * </p>
         * 
         * @param name
         *        The name of the feature.
         * @see DetectorFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorFeature
         */
        Builder name(DetectorFeature name);

        /**
         * <p>
         * The status of the feature.
         * </p>
         * 
         * @param status
         *        The status of the feature.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the feature.
         * </p>
         * 
         * @param status
         *        The status of the feature.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder status(FeatureStatus status);

        /**
         * <p>
         * Additional configuration for a resource.
         * </p>
         * 
         * @param additionalConfiguration
         *        Additional configuration for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConfiguration(Collection<DetectorAdditionalConfiguration> additionalConfiguration);

        /**
         * <p>
         * Additional configuration for a resource.
         * </p>
         * 
         * @param additionalConfiguration
         *        Additional configuration for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalConfiguration(DetectorAdditionalConfiguration... additionalConfiguration);

        /**
         * <p>
         * Additional configuration for a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorAdditionalConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorAdditionalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorAdditionalConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #additionalConfiguration(List<DetectorAdditionalConfiguration>)}.
         * 
         * @param additionalConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.DetectorAdditionalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalConfiguration(java.util.Collection<DetectorAdditionalConfiguration>)
         */
        Builder additionalConfiguration(Consumer<DetectorAdditionalConfiguration.Builder>... additionalConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private List<DetectorAdditionalConfiguration> additionalConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorFeatureConfiguration model) {
            name(model.name);
            status(model.status);
            additionalConfiguration(model.additionalConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(DetectorFeature name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeatureStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<DetectorAdditionalConfiguration.Builder> getAdditionalConfiguration() {
            List<DetectorAdditionalConfiguration.Builder> result = DetectorAdditionalConfigurationsCopier
                    .copyToBuilder(this.additionalConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalConfiguration(
                Collection<DetectorAdditionalConfiguration.BuilderImpl> additionalConfiguration) {
            this.additionalConfiguration = DetectorAdditionalConfigurationsCopier.copyFromBuilder(additionalConfiguration);
        }

        @Override
        public final Builder additionalConfiguration(Collection<DetectorAdditionalConfiguration> additionalConfiguration) {
            this.additionalConfiguration = DetectorAdditionalConfigurationsCopier.copy(additionalConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(DetectorAdditionalConfiguration... additionalConfiguration) {
            additionalConfiguration(Arrays.asList(additionalConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalConfiguration(Consumer<DetectorAdditionalConfiguration.Builder>... additionalConfiguration) {
            additionalConfiguration(Stream.of(additionalConfiguration)
                    .map(c -> DetectorAdditionalConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectorFeatureConfiguration build() {
            return new DetectorFeatureConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
