/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the detected behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Detection implements SdkPojo, Serializable, ToCopyableBuilder<Detection.Builder, Detection> {
    private static final SdkField<Anomaly> ANOMALY_FIELD = SdkField.<Anomaly> builder(MarshallingType.SDK_POJO)
            .memberName("Anomaly").getter(getter(Detection::anomaly)).setter(setter(Builder::anomaly))
            .constructor(Anomaly::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomaly").build()).build();

    private static final SdkField<Sequence> SEQUENCE_FIELD = SdkField.<Sequence> builder(MarshallingType.SDK_POJO)
            .memberName("Sequence").getter(getter(Detection::sequence)).setter(setter(Builder::sequence))
            .constructor(Sequence::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ANOMALY_FIELD, SEQUENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Anomaly anomaly;

    private final Sequence sequence;

    private Detection(BuilderImpl builder) {
        this.anomaly = builder.anomaly;
        this.sequence = builder.sequence;
    }

    /**
     * <p>
     * The details about the anomalous activity that caused GuardDuty to generate the finding.
     * </p>
     * 
     * @return The details about the anomalous activity that caused GuardDuty to generate the finding.
     */
    public final Anomaly anomaly() {
        return anomaly;
    }

    /**
     * <p>
     * The details about the attack sequence.
     * </p>
     * 
     * @return The details about the attack sequence.
     */
    public final Sequence sequence() {
        return sequence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(anomaly());
        hashCode = 31 * hashCode + Objects.hashCode(sequence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Detection)) {
            return false;
        }
        Detection other = (Detection) obj;
        return Objects.equals(anomaly(), other.anomaly()) && Objects.equals(sequence(), other.sequence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Detection").add("Anomaly", anomaly()).add("Sequence", sequence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Anomaly":
            return Optional.ofNullable(clazz.cast(anomaly()));
        case "Sequence":
            return Optional.ofNullable(clazz.cast(sequence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("anomaly", ANOMALY_FIELD);
        map.put("sequence", SEQUENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Detection, T> g) {
        return obj -> g.apply((Detection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Detection> {
        /**
         * <p>
         * The details about the anomalous activity that caused GuardDuty to generate the finding.
         * </p>
         * 
         * @param anomaly
         *        The details about the anomalous activity that caused GuardDuty to generate the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomaly(Anomaly anomaly);

        /**
         * <p>
         * The details about the anomalous activity that caused GuardDuty to generate the finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Anomaly.Builder} avoiding the need to
         * create one manually via {@link Anomaly#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Anomaly.Builder#build()} is called immediately and its result is
         * passed to {@link #anomaly(Anomaly)}.
         * 
         * @param anomaly
         *        a consumer that will call methods on {@link Anomaly.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomaly(Anomaly)
         */
        default Builder anomaly(Consumer<Anomaly.Builder> anomaly) {
            return anomaly(Anomaly.builder().applyMutation(anomaly).build());
        }

        /**
         * <p>
         * The details about the attack sequence.
         * </p>
         * 
         * @param sequence
         *        The details about the attack sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequence(Sequence sequence);

        /**
         * <p>
         * The details about the attack sequence.
         * </p>
         * This is a convenience method that creates an instance of the {@link Sequence.Builder} avoiding the need to
         * create one manually via {@link Sequence#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sequence.Builder#build()} is called immediately and its result is
         * passed to {@link #sequence(Sequence)}.
         * 
         * @param sequence
         *        a consumer that will call methods on {@link Sequence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sequence(Sequence)
         */
        default Builder sequence(Consumer<Sequence.Builder> sequence) {
            return sequence(Sequence.builder().applyMutation(sequence).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Anomaly anomaly;

        private Sequence sequence;

        private BuilderImpl() {
        }

        private BuilderImpl(Detection model) {
            anomaly(model.anomaly);
            sequence(model.sequence);
        }

        public final Anomaly.Builder getAnomaly() {
            return anomaly != null ? anomaly.toBuilder() : null;
        }

        public final void setAnomaly(Anomaly.BuilderImpl anomaly) {
            this.anomaly = anomaly != null ? anomaly.build() : null;
        }

        @Override
        public final Builder anomaly(Anomaly anomaly) {
            this.anomaly = anomaly;
            return this;
        }

        public final Sequence.Builder getSequence() {
            return sequence != null ? sequence.toBuilder() : null;
        }

        public final void setSequence(Sequence.BuilderImpl sequence) {
            this.sequence = sequence != null ? sequence.build() : null;
        }

        @Override
        public final Builder sequence(Sequence sequence) {
            this.sequence = sequence;
            return this;
        }

        @Override
        public Detection build() {
            return new Detection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
