/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the status of data sources for the detector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceConfigurationsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceConfigurationsResult.Builder, DataSourceConfigurationsResult> {
    private static final SdkField<CloudTrailConfigurationResult> CLOUD_TRAIL_FIELD = SdkField
            .<CloudTrailConfigurationResult> builder(MarshallingType.SDK_POJO).memberName("CloudTrail")
            .getter(getter(DataSourceConfigurationsResult::cloudTrail)).setter(setter(Builder::cloudTrail))
            .constructor(CloudTrailConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrail").build()).build();

    private static final SdkField<DNSLogsConfigurationResult> DNS_LOGS_FIELD = SdkField
            .<DNSLogsConfigurationResult> builder(MarshallingType.SDK_POJO).memberName("DNSLogs")
            .getter(getter(DataSourceConfigurationsResult::dnsLogs)).setter(setter(Builder::dnsLogs))
            .constructor(DNSLogsConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsLogs").build()).build();

    private static final SdkField<FlowLogsConfigurationResult> FLOW_LOGS_FIELD = SdkField
            .<FlowLogsConfigurationResult> builder(MarshallingType.SDK_POJO).memberName("FlowLogs")
            .getter(getter(DataSourceConfigurationsResult::flowLogs)).setter(setter(Builder::flowLogs))
            .constructor(FlowLogsConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowLogs").build()).build();

    private static final SdkField<S3LogsConfigurationResult> S3_LOGS_FIELD = SdkField
            .<S3LogsConfigurationResult> builder(MarshallingType.SDK_POJO).memberName("S3Logs")
            .getter(getter(DataSourceConfigurationsResult::s3Logs)).setter(setter(Builder::s3Logs))
            .constructor(S3LogsConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()).build();

    private static final SdkField<KubernetesConfigurationResult> KUBERNETES_FIELD = SdkField
            .<KubernetesConfigurationResult> builder(MarshallingType.SDK_POJO).memberName("Kubernetes")
            .getter(getter(DataSourceConfigurationsResult::kubernetes)).setter(setter(Builder::kubernetes))
            .constructor(KubernetesConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetes").build()).build();

    private static final SdkField<MalwareProtectionConfigurationResult> MALWARE_PROTECTION_FIELD = SdkField
            .<MalwareProtectionConfigurationResult> builder(MarshallingType.SDK_POJO).memberName("MalwareProtection")
            .getter(getter(DataSourceConfigurationsResult::malwareProtection)).setter(setter(Builder::malwareProtection))
            .constructor(MalwareProtectionConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malwareProtection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_TRAIL_FIELD,
            DNS_LOGS_FIELD, FLOW_LOGS_FIELD, S3_LOGS_FIELD, KUBERNETES_FIELD, MALWARE_PROTECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudTrailConfigurationResult cloudTrail;

    private final DNSLogsConfigurationResult dnsLogs;

    private final FlowLogsConfigurationResult flowLogs;

    private final S3LogsConfigurationResult s3Logs;

    private final KubernetesConfigurationResult kubernetes;

    private final MalwareProtectionConfigurationResult malwareProtection;

    private DataSourceConfigurationsResult(BuilderImpl builder) {
        this.cloudTrail = builder.cloudTrail;
        this.dnsLogs = builder.dnsLogs;
        this.flowLogs = builder.flowLogs;
        this.s3Logs = builder.s3Logs;
        this.kubernetes = builder.kubernetes;
        this.malwareProtection = builder.malwareProtection;
    }

    /**
     * <p>
     * An object that contains information on the status of CloudTrail as a data source.
     * </p>
     * 
     * @return An object that contains information on the status of CloudTrail as a data source.
     */
    public final CloudTrailConfigurationResult cloudTrail() {
        return cloudTrail;
    }

    /**
     * <p>
     * An object that contains information on the status of DNS logs as a data source.
     * </p>
     * 
     * @return An object that contains information on the status of DNS logs as a data source.
     */
    public final DNSLogsConfigurationResult dnsLogs() {
        return dnsLogs;
    }

    /**
     * <p>
     * An object that contains information on the status of VPC flow logs as a data source.
     * </p>
     * 
     * @return An object that contains information on the status of VPC flow logs as a data source.
     */
    public final FlowLogsConfigurationResult flowLogs() {
        return flowLogs;
    }

    /**
     * <p>
     * An object that contains information on the status of S3 Data event logs as a data source.
     * </p>
     * 
     * @return An object that contains information on the status of S3 Data event logs as a data source.
     */
    public final S3LogsConfigurationResult s3Logs() {
        return s3Logs;
    }

    /**
     * <p>
     * An object that contains information on the status of all Kubernetes data sources.
     * </p>
     * 
     * @return An object that contains information on the status of all Kubernetes data sources.
     */
    public final KubernetesConfigurationResult kubernetes() {
        return kubernetes;
    }

    /**
     * <p>
     * Describes the configuration of Malware Protection data sources.
     * </p>
     * 
     * @return Describes the configuration of Malware Protection data sources.
     */
    public final MalwareProtectionConfigurationResult malwareProtection() {
        return malwareProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudTrail());
        hashCode = 31 * hashCode + Objects.hashCode(dnsLogs());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogs());
        hashCode = 31 * hashCode + Objects.hashCode(s3Logs());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetes());
        hashCode = 31 * hashCode + Objects.hashCode(malwareProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfigurationsResult)) {
            return false;
        }
        DataSourceConfigurationsResult other = (DataSourceConfigurationsResult) obj;
        return Objects.equals(cloudTrail(), other.cloudTrail()) && Objects.equals(dnsLogs(), other.dnsLogs())
                && Objects.equals(flowLogs(), other.flowLogs()) && Objects.equals(s3Logs(), other.s3Logs())
                && Objects.equals(kubernetes(), other.kubernetes())
                && Objects.equals(malwareProtection(), other.malwareProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceConfigurationsResult").add("CloudTrail", cloudTrail()).add("DNSLogs", dnsLogs())
                .add("FlowLogs", flowLogs()).add("S3Logs", s3Logs()).add("Kubernetes", kubernetes())
                .add("MalwareProtection", malwareProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudTrail":
            return Optional.ofNullable(clazz.cast(cloudTrail()));
        case "DNSLogs":
            return Optional.ofNullable(clazz.cast(dnsLogs()));
        case "FlowLogs":
            return Optional.ofNullable(clazz.cast(flowLogs()));
        case "S3Logs":
            return Optional.ofNullable(clazz.cast(s3Logs()));
        case "Kubernetes":
            return Optional.ofNullable(clazz.cast(kubernetes()));
        case "MalwareProtection":
            return Optional.ofNullable(clazz.cast(malwareProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudTrail", CLOUD_TRAIL_FIELD);
        map.put("dnsLogs", DNS_LOGS_FIELD);
        map.put("flowLogs", FLOW_LOGS_FIELD);
        map.put("s3Logs", S3_LOGS_FIELD);
        map.put("kubernetes", KUBERNETES_FIELD);
        map.put("malwareProtection", MALWARE_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfigurationsResult, T> g) {
        return obj -> g.apply((DataSourceConfigurationsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceConfigurationsResult> {
        /**
         * <p>
         * An object that contains information on the status of CloudTrail as a data source.
         * </p>
         * 
         * @param cloudTrail
         *        An object that contains information on the status of CloudTrail as a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudTrail(CloudTrailConfigurationResult cloudTrail);

        /**
         * <p>
         * An object that contains information on the status of CloudTrail as a data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudTrailConfigurationResult.Builder}
         * avoiding the need to create one manually via {@link CloudTrailConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudTrailConfigurationResult.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudTrail(CloudTrailConfigurationResult)}.
         * 
         * @param cloudTrail
         *        a consumer that will call methods on {@link CloudTrailConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudTrail(CloudTrailConfigurationResult)
         */
        default Builder cloudTrail(Consumer<CloudTrailConfigurationResult.Builder> cloudTrail) {
            return cloudTrail(CloudTrailConfigurationResult.builder().applyMutation(cloudTrail).build());
        }

        /**
         * <p>
         * An object that contains information on the status of DNS logs as a data source.
         * </p>
         * 
         * @param dnsLogs
         *        An object that contains information on the status of DNS logs as a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsLogs(DNSLogsConfigurationResult dnsLogs);

        /**
         * <p>
         * An object that contains information on the status of DNS logs as a data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DNSLogsConfigurationResult.Builder}
         * avoiding the need to create one manually via {@link DNSLogsConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DNSLogsConfigurationResult.Builder#build()} is called immediately
         * and its result is passed to {@link #dnsLogs(DNSLogsConfigurationResult)}.
         * 
         * @param dnsLogs
         *        a consumer that will call methods on {@link DNSLogsConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsLogs(DNSLogsConfigurationResult)
         */
        default Builder dnsLogs(Consumer<DNSLogsConfigurationResult.Builder> dnsLogs) {
            return dnsLogs(DNSLogsConfigurationResult.builder().applyMutation(dnsLogs).build());
        }

        /**
         * <p>
         * An object that contains information on the status of VPC flow logs as a data source.
         * </p>
         * 
         * @param flowLogs
         *        An object that contains information on the status of VPC flow logs as a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogs(FlowLogsConfigurationResult flowLogs);

        /**
         * <p>
         * An object that contains information on the status of VPC flow logs as a data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowLogsConfigurationResult.Builder}
         * avoiding the need to create one manually via {@link FlowLogsConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowLogsConfigurationResult.Builder#build()} is called
         * immediately and its result is passed to {@link #flowLogs(FlowLogsConfigurationResult)}.
         * 
         * @param flowLogs
         *        a consumer that will call methods on {@link FlowLogsConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowLogs(FlowLogsConfigurationResult)
         */
        default Builder flowLogs(Consumer<FlowLogsConfigurationResult.Builder> flowLogs) {
            return flowLogs(FlowLogsConfigurationResult.builder().applyMutation(flowLogs).build());
        }

        /**
         * <p>
         * An object that contains information on the status of S3 Data event logs as a data source.
         * </p>
         * 
         * @param s3Logs
         *        An object that contains information on the status of S3 Data event logs as a data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Logs(S3LogsConfigurationResult s3Logs);

        /**
         * <p>
         * An object that contains information on the status of S3 Data event logs as a data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3LogsConfigurationResult.Builder}
         * avoiding the need to create one manually via {@link S3LogsConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3LogsConfigurationResult.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Logs(S3LogsConfigurationResult)}.
         * 
         * @param s3Logs
         *        a consumer that will call methods on {@link S3LogsConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Logs(S3LogsConfigurationResult)
         */
        default Builder s3Logs(Consumer<S3LogsConfigurationResult.Builder> s3Logs) {
            return s3Logs(S3LogsConfigurationResult.builder().applyMutation(s3Logs).build());
        }

        /**
         * <p>
         * An object that contains information on the status of all Kubernetes data sources.
         * </p>
         * 
         * @param kubernetes
         *        An object that contains information on the status of all Kubernetes data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetes(KubernetesConfigurationResult kubernetes);

        /**
         * <p>
         * An object that contains information on the status of all Kubernetes data sources.
         * </p>
         * This is a convenience method that creates an instance of the {@link KubernetesConfigurationResult.Builder}
         * avoiding the need to create one manually via {@link KubernetesConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KubernetesConfigurationResult.Builder#build()} is called
         * immediately and its result is passed to {@link #kubernetes(KubernetesConfigurationResult)}.
         * 
         * @param kubernetes
         *        a consumer that will call methods on {@link KubernetesConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kubernetes(KubernetesConfigurationResult)
         */
        default Builder kubernetes(Consumer<KubernetesConfigurationResult.Builder> kubernetes) {
            return kubernetes(KubernetesConfigurationResult.builder().applyMutation(kubernetes).build());
        }

        /**
         * <p>
         * Describes the configuration of Malware Protection data sources.
         * </p>
         * 
         * @param malwareProtection
         *        Describes the configuration of Malware Protection data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malwareProtection(MalwareProtectionConfigurationResult malwareProtection);

        /**
         * <p>
         * Describes the configuration of Malware Protection data sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MalwareProtectionConfigurationResult.Builder} avoiding the need to create one manually via
         * {@link MalwareProtectionConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MalwareProtectionConfigurationResult.Builder#build()} is called
         * immediately and its result is passed to {@link #malwareProtection(MalwareProtectionConfigurationResult)}.
         * 
         * @param malwareProtection
         *        a consumer that will call methods on {@link MalwareProtectionConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malwareProtection(MalwareProtectionConfigurationResult)
         */
        default Builder malwareProtection(Consumer<MalwareProtectionConfigurationResult.Builder> malwareProtection) {
            return malwareProtection(MalwareProtectionConfigurationResult.builder().applyMutation(malwareProtection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudTrailConfigurationResult cloudTrail;

        private DNSLogsConfigurationResult dnsLogs;

        private FlowLogsConfigurationResult flowLogs;

        private S3LogsConfigurationResult s3Logs;

        private KubernetesConfigurationResult kubernetes;

        private MalwareProtectionConfigurationResult malwareProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfigurationsResult model) {
            cloudTrail(model.cloudTrail);
            dnsLogs(model.dnsLogs);
            flowLogs(model.flowLogs);
            s3Logs(model.s3Logs);
            kubernetes(model.kubernetes);
            malwareProtection(model.malwareProtection);
        }

        public final CloudTrailConfigurationResult.Builder getCloudTrail() {
            return cloudTrail != null ? cloudTrail.toBuilder() : null;
        }

        public final void setCloudTrail(CloudTrailConfigurationResult.BuilderImpl cloudTrail) {
            this.cloudTrail = cloudTrail != null ? cloudTrail.build() : null;
        }

        @Override
        public final Builder cloudTrail(CloudTrailConfigurationResult cloudTrail) {
            this.cloudTrail = cloudTrail;
            return this;
        }

        public final DNSLogsConfigurationResult.Builder getDnsLogs() {
            return dnsLogs != null ? dnsLogs.toBuilder() : null;
        }

        public final void setDnsLogs(DNSLogsConfigurationResult.BuilderImpl dnsLogs) {
            this.dnsLogs = dnsLogs != null ? dnsLogs.build() : null;
        }

        @Override
        public final Builder dnsLogs(DNSLogsConfigurationResult dnsLogs) {
            this.dnsLogs = dnsLogs;
            return this;
        }

        public final FlowLogsConfigurationResult.Builder getFlowLogs() {
            return flowLogs != null ? flowLogs.toBuilder() : null;
        }

        public final void setFlowLogs(FlowLogsConfigurationResult.BuilderImpl flowLogs) {
            this.flowLogs = flowLogs != null ? flowLogs.build() : null;
        }

        @Override
        public final Builder flowLogs(FlowLogsConfigurationResult flowLogs) {
            this.flowLogs = flowLogs;
            return this;
        }

        public final S3LogsConfigurationResult.Builder getS3Logs() {
            return s3Logs != null ? s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(S3LogsConfigurationResult.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(S3LogsConfigurationResult s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public final KubernetesConfigurationResult.Builder getKubernetes() {
            return kubernetes != null ? kubernetes.toBuilder() : null;
        }

        public final void setKubernetes(KubernetesConfigurationResult.BuilderImpl kubernetes) {
            this.kubernetes = kubernetes != null ? kubernetes.build() : null;
        }

        @Override
        public final Builder kubernetes(KubernetesConfigurationResult kubernetes) {
            this.kubernetes = kubernetes;
            return this;
        }

        public final MalwareProtectionConfigurationResult.Builder getMalwareProtection() {
            return malwareProtection != null ? malwareProtection.toBuilder() : null;
        }

        public final void setMalwareProtection(MalwareProtectionConfigurationResult.BuilderImpl malwareProtection) {
            this.malwareProtection = malwareProtection != null ? malwareProtection.build() : null;
        }

        @Override
        public final Builder malwareProtection(MalwareProtectionConfigurationResult malwareProtection) {
            this.malwareProtection = malwareProtection;
            return this;
        }

        @Override
        public DataSourceConfigurationsResult build() {
            return new DataSourceConfigurationsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
