/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrustedEntitySetResponse extends GuardDutyResponse implements
        ToCopyableBuilder<CreateTrustedEntitySetResponse.Builder, CreateTrustedEntitySetResponse> {
    private static final SdkField<String> TRUSTED_ENTITY_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedEntitySetId").getter(getter(CreateTrustedEntitySetResponse::trustedEntitySetId))
            .setter(setter(Builder::trustedEntitySetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustedEntitySetId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUSTED_ENTITY_SET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trustedEntitySetId;

    private CreateTrustedEntitySetResponse(BuilderImpl builder) {
        super(builder);
        this.trustedEntitySetId = builder.trustedEntitySetId;
    }

    /**
     * <p>
     * The ID returned by GuardDuty after creation of the trusted entity set resource.
     * </p>
     * 
     * @return The ID returned by GuardDuty after creation of the trusted entity set resource.
     */
    public final String trustedEntitySetId() {
        return trustedEntitySetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustedEntitySetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustedEntitySetResponse)) {
            return false;
        }
        CreateTrustedEntitySetResponse other = (CreateTrustedEntitySetResponse) obj;
        return Objects.equals(trustedEntitySetId(), other.trustedEntitySetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrustedEntitySetResponse").add("TrustedEntitySetId", trustedEntitySetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustedEntitySetId":
            return Optional.ofNullable(clazz.cast(trustedEntitySetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trustedEntitySetId", TRUSTED_ENTITY_SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustedEntitySetResponse, T> g) {
        return obj -> g.apply((CreateTrustedEntitySetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrustedEntitySetResponse> {
        /**
         * <p>
         * The ID returned by GuardDuty after creation of the trusted entity set resource.
         * </p>
         * 
         * @param trustedEntitySetId
         *        The ID returned by GuardDuty after creation of the trusted entity set resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedEntitySetId(String trustedEntitySetId);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String trustedEntitySetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustedEntitySetResponse model) {
            super(model);
            trustedEntitySetId(model.trustedEntitySetId);
        }

        public final String getTrustedEntitySetId() {
            return trustedEntitySetId;
        }

        public final void setTrustedEntitySetId(String trustedEntitySetId) {
            this.trustedEntitySetId = trustedEntitySetId;
        }

        @Override
        public final Builder trustedEntitySetId(String trustedEntitySetId) {
            this.trustedEntitySetId = trustedEntitySetId;
            return this;
        }

        @Override
        public CreateTrustedEntitySetResponse build() {
            return new CreateTrustedEntitySetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
