/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThreatEntitySetResponse extends GuardDutyResponse implements
        ToCopyableBuilder<CreateThreatEntitySetResponse.Builder, CreateThreatEntitySetResponse> {
    private static final SdkField<String> THREAT_ENTITY_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThreatEntitySetId").getter(getter(CreateThreatEntitySetResponse::threatEntitySetId))
            .setter(setter(Builder::threatEntitySetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatEntitySetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THREAT_ENTITY_SET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String threatEntitySetId;

    private CreateThreatEntitySetResponse(BuilderImpl builder) {
        super(builder);
        this.threatEntitySetId = builder.threatEntitySetId;
    }

    /**
     * <p>
     * The ID returned by GuardDuty after creation of the threat entity set resource.
     * </p>
     * 
     * @return The ID returned by GuardDuty after creation of the threat entity set resource.
     */
    public final String threatEntitySetId() {
        return threatEntitySetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(threatEntitySetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThreatEntitySetResponse)) {
            return false;
        }
        CreateThreatEntitySetResponse other = (CreateThreatEntitySetResponse) obj;
        return Objects.equals(threatEntitySetId(), other.threatEntitySetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateThreatEntitySetResponse").add("ThreatEntitySetId", threatEntitySetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThreatEntitySetId":
            return Optional.ofNullable(clazz.cast(threatEntitySetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("threatEntitySetId", THREAT_ENTITY_SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateThreatEntitySetResponse, T> g) {
        return obj -> g.apply((CreateThreatEntitySetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateThreatEntitySetResponse> {
        /**
         * <p>
         * The ID returned by GuardDuty after creation of the threat entity set resource.
         * </p>
         * 
         * @param threatEntitySetId
         *        The ID returned by GuardDuty after creation of the threat entity set resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatEntitySetId(String threatEntitySetId);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String threatEntitySetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThreatEntitySetResponse model) {
            super(model);
            threatEntitySetId(model.threatEntitySetId);
        }

        public final String getThreatEntitySetId() {
            return threatEntitySetId;
        }

        public final void setThreatEntitySetId(String threatEntitySetId) {
            this.threatEntitySetId = threatEntitySetId;
        }

        @Override
        public final Builder threatEntitySetId(String threatEntitySetId) {
            this.threatEntitySetId = threatEntitySetId;
            return this;
        }

        @Override
        public CreateThreatEntitySetResponse build() {
            return new CreateThreatEntitySetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
