/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDetectorRequest extends GuardDutyRequest implements
        ToCopyableBuilder<CreateDetectorRequest.Builder, CreateDetectorRequest> {
    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enable").getter(getter(CreateDetectorRequest::enable)).setter(setter(Builder::enable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enable").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateDetectorRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FindingPublishingFrequency")
            .getter(getter(CreateDetectorRequest::findingPublishingFrequencyAsString))
            .setter(setter(Builder::findingPublishingFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingPublishingFrequency").build())
            .build();

    private static final SdkField<DataSourceConfigurations> DATA_SOURCES_FIELD = SdkField
            .<DataSourceConfigurations> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(CreateDetectorRequest::dataSources)).setter(setter(Builder::dataSources))
            .constructor(DataSourceConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDetectorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<DetectorFeatureConfiguration>> FEATURES_FIELD = SdkField
            .<List<DetectorFeatureConfiguration>> builder(MarshallingType.LIST)
            .memberName("Features")
            .getter(getter(CreateDetectorRequest::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectorFeatureConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectorFeatureConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_FIELD,
            CLIENT_TOKEN_FIELD, FINDING_PUBLISHING_FREQUENCY_FIELD, DATA_SOURCES_FIELD, TAGS_FIELD, FEATURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean enable;

    private final String clientToken;

    private final String findingPublishingFrequency;

    private final DataSourceConfigurations dataSources;

    private final Map<String, String> tags;

    private final List<DetectorFeatureConfiguration> features;

    private CreateDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.enable = builder.enable;
        this.clientToken = builder.clientToken;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.dataSources = builder.dataSources;
        this.tags = builder.tags;
        this.features = builder.features;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the detector is to be enabled.
     * </p>
     * 
     * @return A Boolean value that specifies whether the detector is to be enabled.
     */
    public final Boolean enable() {
        return enable;
    }

    /**
     * <p>
     * The idempotency token for the create request.
     * </p>
     * 
     * @return The idempotency token for the create request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A value that specifies how frequently updated findings are exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return A value that specifies how frequently updated findings are exported.
     * @see FindingPublishingFrequency
     */
    public final FindingPublishingFrequency findingPublishingFrequency() {
        return FindingPublishingFrequency.fromValue(findingPublishingFrequency);
    }

    /**
     * <p>
     * A value that specifies how frequently updated findings are exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return A value that specifies how frequently updated findings are exported.
     * @see FindingPublishingFrequency
     */
    public final String findingPublishingFrequencyAsString() {
        return findingPublishingFrequency;
    }

    /**
     * <p>
     * Describes which data sources will be enabled for the detector.
     * </p>
     * <p>
     * There might be regional differences because some data sources might not be available in all the Amazon Web
     * Services Regions where GuardDuty is presently supported. For more information, see <a
     * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * </p>
     * 
     * @return Describes which data sources will be enabled for the detector.</p>
     *         <p>
     *         There might be regional differences because some data sources might not be available in all the Amazon
     *         Web Services Regions where GuardDuty is presently supported. For more information, see <a
     *         href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
     * @deprecated This parameter is deprecated, use Features instead
     */
    @Deprecated
    public final DataSourceConfigurations dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be added to a new detector resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be added to a new detector resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of features that will be configured for the detector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return A list of features that will be configured for the detector.
     */
    public final List<DetectorFeatureConfiguration> features() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enable());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(findingPublishingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDetectorRequest)) {
            return false;
        }
        CreateDetectorRequest other = (CreateDetectorRequest) obj;
        return Objects.equals(enable(), other.enable()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(findingPublishingFrequencyAsString(), other.findingPublishingFrequencyAsString())
                && Objects.equals(dataSources(), other.dataSources()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasFeatures() == other.hasFeatures()
                && Objects.equals(features(), other.features());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDetectorRequest").add("Enable", enable()).add("ClientToken", clientToken())
                .add("FindingPublishingFrequency", findingPublishingFrequencyAsString()).add("DataSources", dataSources())
                .add("Tags", hasTags() ? tags() : null).add("Features", hasFeatures() ? features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enable":
            return Optional.ofNullable(clazz.cast(enable()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "FindingPublishingFrequency":
            return Optional.ofNullable(clazz.cast(findingPublishingFrequencyAsString()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Features":
            return Optional.ofNullable(clazz.cast(features()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enable", ENABLE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("findingPublishingFrequency", FINDING_PUBLISHING_FREQUENCY_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("features", FEATURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDetectorRequest, T> g) {
        return obj -> g.apply((CreateDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDetectorRequest> {
        /**
         * <p>
         * A Boolean value that specifies whether the detector is to be enabled.
         * </p>
         * 
         * @param enable
         *        A Boolean value that specifies whether the detector is to be enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enable(Boolean enable);

        /**
         * <p>
         * The idempotency token for the create request.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token for the create request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A value that specifies how frequently updated findings are exported.
         * </p>
         * 
         * @param findingPublishingFrequency
         *        A value that specifies how frequently updated findings are exported.
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(String findingPublishingFrequency);

        /**
         * <p>
         * A value that specifies how frequently updated findings are exported.
         * </p>
         * 
         * @param findingPublishingFrequency
         *        A value that specifies how frequently updated findings are exported.
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency);

        /**
         * <p>
         * Describes which data sources will be enabled for the detector.
         * </p>
         * <p>
         * There might be regional differences because some data sources might not be available in all the Amazon Web
         * Services Regions where GuardDuty is presently supported. For more information, see <a
         * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
         * </p>
         * 
         * @param dataSources
         *        Describes which data sources will be enabled for the detector.</p>
         *        <p>
         *        There might be regional differences because some data sources might not be available in all the Amazon
         *        Web Services Regions where GuardDuty is presently supported. For more information, see <a
         *        href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and
         *        endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        Builder dataSources(DataSourceConfigurations dataSources);

        /**
         * <p>
         * Describes which data sources will be enabled for the detector.
         * </p>
         * <p>
         * There might be regional differences because some data sources might not be available in all the Amazon Web
         * Services Regions where GuardDuty is presently supported. For more information, see <a
         * href="https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html">Regions and endpoints</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfigurations.Builder}
         * avoiding the need to create one manually via {@link DataSourceConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSources(DataSourceConfigurations)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link DataSourceConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(DataSourceConfigurations)
         * @deprecated This parameter is deprecated, use Features instead
         */
        @Deprecated
        default Builder dataSources(Consumer<DataSourceConfigurations.Builder> dataSources) {
            return dataSources(DataSourceConfigurations.builder().applyMutation(dataSources).build());
        }

        /**
         * <p>
         * The tags to be added to a new detector resource.
         * </p>
         * 
         * @param tags
         *        The tags to be added to a new detector resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of features that will be configured for the detector.
         * </p>
         * 
         * @param features
         *        A list of features that will be configured for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<DetectorFeatureConfiguration> features);

        /**
         * <p>
         * A list of features that will be configured for the detector.
         * </p>
         * 
         * @param features
         *        A list of features that will be configured for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(DetectorFeatureConfiguration... features);

        /**
         * <p>
         * A list of features that will be configured for the detector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorFeatureConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorFeatureConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.guardduty.model.DetectorFeatureConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #features(List<DetectorFeatureConfiguration>)}.
         * 
         * @param features
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.guardduty.model.DetectorFeatureConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(java.util.Collection<DetectorFeatureConfiguration>)
         */
        Builder features(Consumer<DetectorFeatureConfiguration.Builder>... features);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private Boolean enable;

        private String clientToken;

        private String findingPublishingFrequency;

        private DataSourceConfigurations dataSources;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<DetectorFeatureConfiguration> features = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDetectorRequest model) {
            super(model);
            enable(model.enable);
            clientToken(model.clientToken);
            findingPublishingFrequency(model.findingPublishingFrequency);
            dataSources(model.dataSources);
            tags(model.tags);
            features(model.features);
        }

        public final Boolean getEnable() {
            return enable;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFindingPublishingFrequency() {
            return findingPublishingFrequency;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        @Override
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        @Override
        public final Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency) {
            this.findingPublishingFrequency(findingPublishingFrequency == null ? null : findingPublishingFrequency.toString());
            return this;
        }

        @Deprecated
        public final DataSourceConfigurations.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(DataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(DataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<DetectorFeatureConfiguration.Builder> getFeatures() {
            List<DetectorFeatureConfiguration.Builder> result = DetectorFeatureConfigurationsCopier.copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<DetectorFeatureConfiguration.BuilderImpl> features) {
            this.features = DetectorFeatureConfigurationsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<DetectorFeatureConfiguration> features) {
            this.features = DetectorFeatureConfigurationsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(DetectorFeatureConfiguration... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<DetectorFeatureConfiguration.Builder>... features) {
            features(Stream.of(features).map(c -> DetectorFeatureConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDetectorRequest build() {
            return new CreateDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
