/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the coverage statistics for a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageStatistics.Builder, CoverageStatistics> {
    private static final SdkField<Map<String, Long>> COUNT_BY_RESOURCE_TYPE_FIELD = SdkField
            .<Map<String, Long>> builder(MarshallingType.MAP)
            .memberName("CountByResourceType")
            .getter(getter(CoverageStatistics::countByResourceTypeAsStrings))
            .setter(setter(Builder::countByResourceTypeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countByResourceType").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Long>> COUNT_BY_COVERAGE_STATUS_FIELD = SdkField
            .<Map<String, Long>> builder(MarshallingType.MAP)
            .memberName("CountByCoverageStatus")
            .getter(getter(CoverageStatistics::countByCoverageStatusAsStrings))
            .setter(setter(Builder::countByCoverageStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countByCoverageStatus").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_BY_RESOURCE_TYPE_FIELD,
            COUNT_BY_COVERAGE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, Long> countByResourceType;

    private final Map<String, Long> countByCoverageStatus;

    private CoverageStatistics(BuilderImpl builder) {
        this.countByResourceType = builder.countByResourceType;
        this.countByCoverageStatus = builder.countByCoverageStatus;
    }

    /**
     * <p>
     * Represents coverage statistics for EKS clusters aggregated by resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountByResourceType} method.
     * </p>
     * 
     * @return Represents coverage statistics for EKS clusters aggregated by resource type.
     */
    public final Map<ResourceType, Long> countByResourceType() {
        return CountByResourceTypeCopier.copyStringToEnum(countByResourceType);
    }

    /**
     * For responses, this returns true if the service returned a value for the CountByResourceType property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCountByResourceType() {
        return countByResourceType != null && !(countByResourceType instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Represents coverage statistics for EKS clusters aggregated by resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountByResourceType} method.
     * </p>
     * 
     * @return Represents coverage statistics for EKS clusters aggregated by resource type.
     */
    public final Map<String, Long> countByResourceTypeAsStrings() {
        return countByResourceType;
    }

    /**
     * <p>
     * Represents coverage statistics for EKS clusters aggregated by coverage status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountByCoverageStatus} method.
     * </p>
     * 
     * @return Represents coverage statistics for EKS clusters aggregated by coverage status.
     */
    public final Map<CoverageStatus, Long> countByCoverageStatus() {
        return CountByCoverageStatusCopier.copyStringToEnum(countByCoverageStatus);
    }

    /**
     * For responses, this returns true if the service returned a value for the CountByCoverageStatus property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCountByCoverageStatus() {
        return countByCoverageStatus != null && !(countByCoverageStatus instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Represents coverage statistics for EKS clusters aggregated by coverage status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountByCoverageStatus} method.
     * </p>
     * 
     * @return Represents coverage statistics for EKS clusters aggregated by coverage status.
     */
    public final Map<String, Long> countByCoverageStatusAsStrings() {
        return countByCoverageStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCountByResourceType() ? countByResourceTypeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCountByCoverageStatus() ? countByCoverageStatusAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageStatistics)) {
            return false;
        }
        CoverageStatistics other = (CoverageStatistics) obj;
        return hasCountByResourceType() == other.hasCountByResourceType()
                && Objects.equals(countByResourceTypeAsStrings(), other.countByResourceTypeAsStrings())
                && hasCountByCoverageStatus() == other.hasCountByCoverageStatus()
                && Objects.equals(countByCoverageStatusAsStrings(), other.countByCoverageStatusAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageStatistics")
                .add("CountByResourceType", hasCountByResourceType() ? countByResourceTypeAsStrings() : null)
                .add("CountByCoverageStatus", hasCountByCoverageStatus() ? countByCoverageStatusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CountByResourceType":
            return Optional.ofNullable(clazz.cast(countByResourceTypeAsStrings()));
        case "CountByCoverageStatus":
            return Optional.ofNullable(clazz.cast(countByCoverageStatusAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("countByResourceType", COUNT_BY_RESOURCE_TYPE_FIELD);
        map.put("countByCoverageStatus", COUNT_BY_COVERAGE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoverageStatistics, T> g) {
        return obj -> g.apply((CoverageStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageStatistics> {
        /**
         * <p>
         * Represents coverage statistics for EKS clusters aggregated by resource type.
         * </p>
         * 
         * @param countByResourceType
         *        Represents coverage statistics for EKS clusters aggregated by resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countByResourceTypeWithStrings(Map<String, Long> countByResourceType);

        /**
         * <p>
         * Represents coverage statistics for EKS clusters aggregated by resource type.
         * </p>
         * 
         * @param countByResourceType
         *        Represents coverage statistics for EKS clusters aggregated by resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countByResourceType(Map<ResourceType, Long> countByResourceType);

        /**
         * <p>
         * Represents coverage statistics for EKS clusters aggregated by coverage status.
         * </p>
         * 
         * @param countByCoverageStatus
         *        Represents coverage statistics for EKS clusters aggregated by coverage status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countByCoverageStatusWithStrings(Map<String, Long> countByCoverageStatus);

        /**
         * <p>
         * Represents coverage statistics for EKS clusters aggregated by coverage status.
         * </p>
         * 
         * @param countByCoverageStatus
         *        Represents coverage statistics for EKS clusters aggregated by coverage status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countByCoverageStatus(Map<CoverageStatus, Long> countByCoverageStatus);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Long> countByResourceType = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Long> countByCoverageStatus = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageStatistics model) {
            countByResourceTypeWithStrings(model.countByResourceType);
            countByCoverageStatusWithStrings(model.countByCoverageStatus);
        }

        public final Map<String, Long> getCountByResourceType() {
            if (countByResourceType instanceof SdkAutoConstructMap) {
                return null;
            }
            return countByResourceType;
        }

        public final void setCountByResourceType(Map<String, Long> countByResourceType) {
            this.countByResourceType = CountByResourceTypeCopier.copy(countByResourceType);
        }

        @Override
        public final Builder countByResourceTypeWithStrings(Map<String, Long> countByResourceType) {
            this.countByResourceType = CountByResourceTypeCopier.copy(countByResourceType);
            return this;
        }

        @Override
        public final Builder countByResourceType(Map<ResourceType, Long> countByResourceType) {
            this.countByResourceType = CountByResourceTypeCopier.copyEnumToString(countByResourceType);
            return this;
        }

        public final Map<String, Long> getCountByCoverageStatus() {
            if (countByCoverageStatus instanceof SdkAutoConstructMap) {
                return null;
            }
            return countByCoverageStatus;
        }

        public final void setCountByCoverageStatus(Map<String, Long> countByCoverageStatus) {
            this.countByCoverageStatus = CountByCoverageStatusCopier.copy(countByCoverageStatus);
        }

        @Override
        public final Builder countByCoverageStatusWithStrings(Map<String, Long> countByCoverageStatus) {
            this.countByCoverageStatus = CountByCoverageStatusCopier.copy(countByCoverageStatus);
            return this;
        }

        @Override
        public final Builder countByCoverageStatus(Map<CoverageStatus, Long> countByCoverageStatus) {
            this.countByCoverageStatus = CountByCoverageStatusCopier.copyEnumToString(countByCoverageStatus);
            return this;
        }

        @Override
        public CoverageStatistics build() {
            return new CoverageStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
