/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the EKS cluster that has a coverage status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageEksClusterDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageEksClusterDetails.Builder, CoverageEksClusterDetails> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(CoverageEksClusterDetails::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<Long> COVERED_NODES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CoveredNodes").getter(getter(CoverageEksClusterDetails::coveredNodes))
            .setter(setter(Builder::coveredNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coveredNodes").build()).build();

    private static final SdkField<Long> COMPATIBLE_NODES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CompatibleNodes").getter(getter(CoverageEksClusterDetails::compatibleNodes))
            .setter(setter(Builder::compatibleNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleNodes").build()).build();

    private static final SdkField<AddonDetails> ADDON_DETAILS_FIELD = SdkField.<AddonDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AddonDetails").getter(getter(CoverageEksClusterDetails::addonDetails))
            .setter(setter(Builder::addonDetails)).constructor(AddonDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonDetails").build()).build();

    private static final SdkField<String> MANAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagementType").getter(getter(CoverageEksClusterDetails::managementTypeAsString))
            .setter(setter(Builder::managementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            COVERED_NODES_FIELD, COMPATIBLE_NODES_FIELD, ADDON_DETAILS_FIELD, MANAGEMENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterName;

    private final Long coveredNodes;

    private final Long compatibleNodes;

    private final AddonDetails addonDetails;

    private final String managementType;

    private CoverageEksClusterDetails(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.coveredNodes = builder.coveredNodes;
        this.compatibleNodes = builder.compatibleNodes;
        this.addonDetails = builder.addonDetails;
        this.managementType = builder.managementType;
    }

    /**
     * <p>
     * Name of the EKS cluster.
     * </p>
     * 
     * @return Name of the EKS cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * Represents the nodes within the EKS cluster that have a <code>HEALTHY</code> coverage status.
     * </p>
     * 
     * @return Represents the nodes within the EKS cluster that have a <code>HEALTHY</code> coverage status.
     */
    public final Long coveredNodes() {
        return coveredNodes;
    }

    /**
     * <p>
     * Represents all the nodes within the EKS cluster in your account.
     * </p>
     * 
     * @return Represents all the nodes within the EKS cluster in your account.
     */
    public final Long compatibleNodes() {
        return compatibleNodes;
    }

    /**
     * <p>
     * Information about the installed EKS add-on.
     * </p>
     * 
     * @return Information about the installed EKS add-on.
     */
    public final AddonDetails addonDetails() {
        return addonDetails;
    }

    /**
     * <p>
     * Indicates how the Amazon EKS add-on GuardDuty agent is managed for this EKS cluster.
     * </p>
     * <p>
     * <code>AUTO_MANAGED</code> indicates GuardDuty deploys and manages updates for this resource.
     * </p>
     * <p>
     * <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the Amazon EKS add-on
     * GuardDuty agent for this resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managementType}
     * will return {@link ManagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #managementTypeAsString}.
     * </p>
     * 
     * @return Indicates how the Amazon EKS add-on GuardDuty agent is managed for this EKS cluster.</p>
     *         <p>
     *         <code>AUTO_MANAGED</code> indicates GuardDuty deploys and manages updates for this resource.
     *         </p>
     *         <p>
     *         <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the Amazon EKS
     *         add-on GuardDuty agent for this resource.
     * @see ManagementType
     */
    public final ManagementType managementType() {
        return ManagementType.fromValue(managementType);
    }

    /**
     * <p>
     * Indicates how the Amazon EKS add-on GuardDuty agent is managed for this EKS cluster.
     * </p>
     * <p>
     * <code>AUTO_MANAGED</code> indicates GuardDuty deploys and manages updates for this resource.
     * </p>
     * <p>
     * <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the Amazon EKS add-on
     * GuardDuty agent for this resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managementType}
     * will return {@link ManagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #managementTypeAsString}.
     * </p>
     * 
     * @return Indicates how the Amazon EKS add-on GuardDuty agent is managed for this EKS cluster.</p>
     *         <p>
     *         <code>AUTO_MANAGED</code> indicates GuardDuty deploys and manages updates for this resource.
     *         </p>
     *         <p>
     *         <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the Amazon EKS
     *         add-on GuardDuty agent for this resource.
     * @see ManagementType
     */
    public final String managementTypeAsString() {
        return managementType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(coveredNodes());
        hashCode = 31 * hashCode + Objects.hashCode(compatibleNodes());
        hashCode = 31 * hashCode + Objects.hashCode(addonDetails());
        hashCode = 31 * hashCode + Objects.hashCode(managementTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageEksClusterDetails)) {
            return false;
        }
        CoverageEksClusterDetails other = (CoverageEksClusterDetails) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(coveredNodes(), other.coveredNodes())
                && Objects.equals(compatibleNodes(), other.compatibleNodes())
                && Objects.equals(addonDetails(), other.addonDetails())
                && Objects.equals(managementTypeAsString(), other.managementTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageEksClusterDetails").add("ClusterName", clusterName())
                .add("CoveredNodes", coveredNodes()).add("CompatibleNodes", compatibleNodes())
                .add("AddonDetails", addonDetails()).add("ManagementType", managementTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "CoveredNodes":
            return Optional.ofNullable(clazz.cast(coveredNodes()));
        case "CompatibleNodes":
            return Optional.ofNullable(clazz.cast(compatibleNodes()));
        case "AddonDetails":
            return Optional.ofNullable(clazz.cast(addonDetails()));
        case "ManagementType":
            return Optional.ofNullable(clazz.cast(managementTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("coveredNodes", COVERED_NODES_FIELD);
        map.put("compatibleNodes", COMPATIBLE_NODES_FIELD);
        map.put("addonDetails", ADDON_DETAILS_FIELD);
        map.put("managementType", MANAGEMENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoverageEksClusterDetails, T> g) {
        return obj -> g.apply((CoverageEksClusterDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageEksClusterDetails> {
        /**
         * <p>
         * Name of the EKS cluster.
         * </p>
         * 
         * @param clusterName
         *        Name of the EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * Represents the nodes within the EKS cluster that have a <code>HEALTHY</code> coverage status.
         * </p>
         * 
         * @param coveredNodes
         *        Represents the nodes within the EKS cluster that have a <code>HEALTHY</code> coverage status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coveredNodes(Long coveredNodes);

        /**
         * <p>
         * Represents all the nodes within the EKS cluster in your account.
         * </p>
         * 
         * @param compatibleNodes
         *        Represents all the nodes within the EKS cluster in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleNodes(Long compatibleNodes);

        /**
         * <p>
         * Information about the installed EKS add-on.
         * </p>
         * 
         * @param addonDetails
         *        Information about the installed EKS add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonDetails(AddonDetails addonDetails);

        /**
         * <p>
         * Information about the installed EKS add-on.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddonDetails.Builder} avoiding the need
         * to create one manually via {@link AddonDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddonDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #addonDetails(AddonDetails)}.
         * 
         * @param addonDetails
         *        a consumer that will call methods on {@link AddonDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addonDetails(AddonDetails)
         */
        default Builder addonDetails(Consumer<AddonDetails.Builder> addonDetails) {
            return addonDetails(AddonDetails.builder().applyMutation(addonDetails).build());
        }

        /**
         * <p>
         * Indicates how the Amazon EKS add-on GuardDuty agent is managed for this EKS cluster.
         * </p>
         * <p>
         * <code>AUTO_MANAGED</code> indicates GuardDuty deploys and manages updates for this resource.
         * </p>
         * <p>
         * <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the Amazon EKS add-on
         * GuardDuty agent for this resource.
         * </p>
         * 
         * @param managementType
         *        Indicates how the Amazon EKS add-on GuardDuty agent is managed for this EKS cluster.</p>
         *        <p>
         *        <code>AUTO_MANAGED</code> indicates GuardDuty deploys and manages updates for this resource.
         *        </p>
         *        <p>
         *        <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the Amazon EKS
         *        add-on GuardDuty agent for this resource.
         * @see ManagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagementType
         */
        Builder managementType(String managementType);

        /**
         * <p>
         * Indicates how the Amazon EKS add-on GuardDuty agent is managed for this EKS cluster.
         * </p>
         * <p>
         * <code>AUTO_MANAGED</code> indicates GuardDuty deploys and manages updates for this resource.
         * </p>
         * <p>
         * <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the Amazon EKS add-on
         * GuardDuty agent for this resource.
         * </p>
         * 
         * @param managementType
         *        Indicates how the Amazon EKS add-on GuardDuty agent is managed for this EKS cluster.</p>
         *        <p>
         *        <code>AUTO_MANAGED</code> indicates GuardDuty deploys and manages updates for this resource.
         *        </p>
         *        <p>
         *        <code>MANUAL</code> indicates that you are responsible to deploy, update, and manage the Amazon EKS
         *        add-on GuardDuty agent for this resource.
         * @see ManagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagementType
         */
        Builder managementType(ManagementType managementType);
    }

    static final class BuilderImpl implements Builder {
        private String clusterName;

        private Long coveredNodes;

        private Long compatibleNodes;

        private AddonDetails addonDetails;

        private String managementType;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageEksClusterDetails model) {
            clusterName(model.clusterName);
            coveredNodes(model.coveredNodes);
            compatibleNodes(model.compatibleNodes);
            addonDetails(model.addonDetails);
            managementType(model.managementType);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Long getCoveredNodes() {
            return coveredNodes;
        }

        public final void setCoveredNodes(Long coveredNodes) {
            this.coveredNodes = coveredNodes;
        }

        @Override
        public final Builder coveredNodes(Long coveredNodes) {
            this.coveredNodes = coveredNodes;
            return this;
        }

        public final Long getCompatibleNodes() {
            return compatibleNodes;
        }

        public final void setCompatibleNodes(Long compatibleNodes) {
            this.compatibleNodes = compatibleNodes;
        }

        @Override
        public final Builder compatibleNodes(Long compatibleNodes) {
            this.compatibleNodes = compatibleNodes;
            return this;
        }

        public final AddonDetails.Builder getAddonDetails() {
            return addonDetails != null ? addonDetails.toBuilder() : null;
        }

        public final void setAddonDetails(AddonDetails.BuilderImpl addonDetails) {
            this.addonDetails = addonDetails != null ? addonDetails.build() : null;
        }

        @Override
        public final Builder addonDetails(AddonDetails addonDetails) {
            this.addonDetails = addonDetails;
            return this;
        }

        public final String getManagementType() {
            return managementType;
        }

        public final void setManagementType(String managementType) {
            this.managementType = managementType;
        }

        @Override
        public final Builder managementType(String managementType) {
            this.managementType = managementType;
            return this;
        }

        @Override
        public final Builder managementType(ManagementType managementType) {
            this.managementType(managementType == null ? null : managementType.toString());
            return this;
        }

        @Override
        public CoverageEksClusterDetails build() {
            return new CoverageEksClusterDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
