/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about container resources involved in a GuardDuty finding. This structure provides details about
 * containers that were identified as part of suspicious or malicious activity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerFindingResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerFindingResource.Builder, ContainerFindingResource> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Image")
            .getter(getter(ContainerFindingResource::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<String> IMAGE_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageUid").getter(getter(ContainerFindingResource::imageUid)).setter(setter(Builder::imageUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, IMAGE_UID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String image;

    private final String imageUid;

    private ContainerFindingResource(BuilderImpl builder) {
        this.image = builder.image;
        this.imageUid = builder.imageUid;
    }

    /**
     * <p>
     * The container image information, including the image name and tag used to run the container that was involved in
     * the finding.
     * </p>
     * 
     * @return The container image information, including the image name and tag used to run the container that was
     *         involved in the finding.
     */
    public final String image() {
        return image;
    }

    /**
     * <p>
     * The unique ID associated with the container image.
     * </p>
     * 
     * @return The unique ID associated with the container image.
     */
    public final String imageUid() {
        return imageUid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(imageUid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerFindingResource)) {
            return false;
        }
        ContainerFindingResource other = (ContainerFindingResource) obj;
        return Objects.equals(image(), other.image()) && Objects.equals(imageUid(), other.imageUid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerFindingResource").add("Image", image()).add("ImageUid", imageUid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "ImageUid":
            return Optional.ofNullable(clazz.cast(imageUid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("image", IMAGE_FIELD);
        map.put("imageUid", IMAGE_UID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerFindingResource, T> g) {
        return obj -> g.apply((ContainerFindingResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerFindingResource> {
        /**
         * <p>
         * The container image information, including the image name and tag used to run the container that was involved
         * in the finding.
         * </p>
         * 
         * @param image
         *        The container image information, including the image name and tag used to run the container that was
         *        involved in the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The unique ID associated with the container image.
         * </p>
         * 
         * @param imageUid
         *        The unique ID associated with the container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUid(String imageUid);
    }

    static final class BuilderImpl implements Builder {
        private String image;

        private String imageUid;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerFindingResource model) {
            image(model.image);
            imageUid(model.imageUid);
        }

        public final String getImage() {
            return image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getImageUid() {
            return imageUid;
        }

        public final void setImageUid(String imageUid) {
            this.imageUid = imageUid;
        }

        @Override
        public final Builder imageUid(String imageUid) {
            this.imageUid = imageUid;
            return this;
        }

        @Override
        public ContainerFindingResource build() {
            return new ContainerFindingResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
